/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.HadoopVersionAnnotation;
import org.apache.hadoop.util.ClassUtil;

public class VersionInfo {
    private static Package myPackage = HadoopVersionAnnotation.class.getPackage();
    private static HadoopVersionAnnotation version = myPackage.getAnnotation(HadoopVersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return VersionInfo.getVersion() + " from " + VersionInfo.getRevision() + " by " + VersionInfo.getUser() + " source checksum " + VersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        System.out.println("Hadoop " + VersionInfo.getVersion());
        System.out.println("Subversion " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
        System.out.println("This command was run using " + ClassUtil.findContainingJar(VersionInfo.class));
    }
}

