/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.stream.Stream;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.SimilarityScore;
import org.apache.commons.text.similarity.SimilarityScoreFrom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ParameterizedSimilarityScoreFromTest<R> {
    public static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "elephant", "hippo", 7}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "hippo", "elephant", 7}), Arguments.of((Object[])new Object[]{new LevenshteinDistance(), "hippo", "zzzzzzzz", 8}), Arguments.of((Object[])new Object[]{new SimilarityScore<Boolean>(){

            public Boolean apply(CharSequence left, CharSequence right) {
                return left == right || left != null && left.equals(right);
            }
        }, "Bob's your uncle.", "Every good boy does fine.", false}));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void test(SimilarityScore<R> similarityScore, CharSequence left, CharSequence right, R distance) {
        SimilarityScoreFrom similarityScoreFrom = new SimilarityScoreFrom(similarityScore, left);
        Assertions.assertThat((Object)similarityScoreFrom.apply(right)).isEqualTo(distance);
    }
}

