/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LeakDetector.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final LeakTrackerSet trackers = new LeakTrackerSet();
    private final List<String> leakMessages = Collections.synchronizedList(new ArrayList());
    private final String name;

    LeakDetector(String name) {
        this.name = name + COUNTER.getAndIncrement();
    }

    LeakDetector start() {
        Thread t = new Thread(this::run);
        t.setName(LeakDetector.class.getSimpleName() + "-" + this.name);
        t.setDaemon(true);
        LOG.info("Starting leak detector thread {}.", (Object)this.name);
        t.start();
        return this;
    }

    private void run() {
        try {
            while (true) {
                String leak;
                LeakTracker tracker;
                if (!this.trackers.remove(tracker = (LeakTracker)this.queue.remove()) || (leak = tracker.reportLeak()) == null) {
                    continue;
                }
                this.leakMessages.add(leak);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Thread interrupted, exiting.", (Throwable)e);
            LOG.warn("Exiting leak detector {}.", (Object)this.name);
            return;
        }
    }

    Runnable track(Object leakable, Supplier<String> reportLeak) {
        return this.trackers.add(leakable, this.queue, reportLeak)::remove;
    }

    public int getLeakCount() {
        return this.trackers.getNumLeaks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoLeaks(int maxRetries, TimeDuration retrySleep) throws InterruptedException {
        List<String> list = this.leakMessages;
        synchronized (list) {
            Preconditions.assertTrue(this.leakMessages.isEmpty(), () -> "#leaks = " + this.leakMessages.size() + "\n" + this.leakMessages);
        }
        for (int i = 0; i < maxRetries; ++i) {
            int numLeaks = this.trackers.getNumLeaks(false);
            if (numLeaks == 0) {
                return;
            }
            LOG.warn("{}/{}) numLeaks == {} > 0, will wait and retry ...", new Object[]{i, maxRetries, numLeaks});
            retrySleep.sleep();
        }
        this.trackers.getNumLeaks(true);
    }

    private static final class LeakTracker
    extends WeakReference<Object> {
        private final Consumer<LeakTracker> removeMethod;
        private final Supplier<String> getLeakMessage;

        LeakTracker(Object referent, ReferenceQueue<Object> referenceQueue, Consumer<LeakTracker> removeMethod, Supplier<String> getLeakMessage) {
            super(referent, referenceQueue);
            this.removeMethod = removeMethod;
            this.getLeakMessage = getLeakMessage;
        }

        void remove() {
            this.removeMethod.accept(this);
        }

        String reportLeak() {
            return this.getLeakMessage.get();
        }
    }

    private static class LeakTrackerSet {
        private final Set<LeakTracker> set = Collections.newSetFromMap(new HashMap());

        private LeakTrackerSet() {
        }

        synchronized boolean remove(LeakTracker tracker) {
            return this.set.remove(tracker);
        }

        synchronized void removeExisting(LeakTracker tracker) {
            boolean removed = this.set.remove(tracker);
            Preconditions.assertTrue(removed, () -> "Failed to remove existing " + tracker);
        }

        synchronized LeakTracker add(Object referent, ReferenceQueue<Object> queue, Supplier<String> leakReporter) {
            LeakTracker tracker = new LeakTracker(referent, queue, this::removeExisting, leakReporter);
            boolean added = this.set.add(tracker);
            Preconditions.assertTrue(added, () -> "Failed to add " + tracker + " for " + referent);
            return tracker;
        }

        synchronized int getNumLeaks(boolean throwException) {
            if (this.set.isEmpty()) {
                return 0;
            }
            int n = 0;
            for (LeakTracker tracker : this.set) {
                if (tracker.reportLeak() == null) continue;
                ++n;
            }
            if (throwException) {
                this.assertNoLeaks(n);
            }
            return n;
        }

        synchronized void assertNoLeaks(int leaks) {
            Preconditions.assertTrue(leaks == 0, () -> {
                int size = this.set.size();
                return "#leaks = " + leaks + " > 0, #leaks " + (leaks == size ? "==" : "!=") + " set.size = " + size;
            });
        }
    }
}

