/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.connection;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.extractor.schemaregion.IoTDBSchemaRegionExtractor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCollector
implements EventCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCollector.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue;
    private final long creationTime;
    private final int regionId;
    private final boolean forceTabletFormat;
    private final boolean skipParsing;
    private final boolean isUsedForConsensusPipe;
    private final AtomicInteger collectInvocationCount = new AtomicInteger(0);
    private boolean hasNoGeneratedEvent = true;
    private boolean isFailedToIncreaseReferenceCount = false;

    public PipeEventCollector(UnboundedBlockingPendingQueue<Event> pendingQueue, long creationTime, int regionId, boolean forceTabletFormat, boolean skipParsing, boolean isUsedInConsensusPipe) {
        this.pendingQueue = pendingQueue;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.forceTabletFormat = forceTabletFormat;
        this.skipParsing = skipParsing;
        this.isUsedForConsensusPipe = isUsedInConsensusPipe;
    }

    public void collect(Event event) {
        try {
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.parseAndCollectEvent((PipeTsFileInsertionEvent)event);
            } else if (event instanceof PipeDeleteDataNodeEvent) {
                this.parseAndCollectEvent((PipeDeleteDataNodeEvent)event);
            } else if (!(event instanceof ProgressReportEvent)) {
                this.collectEvent(event);
            }
        }
        catch (PipeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeException("Error occurred when collecting events from processor.", (Throwable)e);
        }
    }

    private void parseAndCollectEvent(PipeInsertNodeTabletInsertionEvent sourceEvent) {
        if (this.skipParsing) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        if (sourceEvent.shouldParseTimeOrPattern()) {
            for (PipeRawTabletInsertionEvent parsedEvent : sourceEvent.toRawTabletInsertionEvents()) {
                this.collectParsedRawTableEvent(parsedEvent);
            }
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    private void parseAndCollectEvent(PipeRawTabletInsertionEvent sourceEvent) {
        this.collectParsedRawTableEvent(sourceEvent.shouldParseTimeOrPattern() ? sourceEvent.parseEventWithPatternOrTime() : sourceEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndCollectEvent(PipeTsFileInsertionEvent sourceEvent) throws Exception {
        if (!sourceEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)sourceEvent.getTsFile());
            return;
        }
        if (this.skipParsing) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        if (!this.forceTabletFormat && this.canSkipParsing4TsFileEvent(sourceEvent)) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        try {
            for (TabletInsertionEvent parsedEvent : sourceEvent.toTabletInsertionEvents()) {
                this.collectParsedRawTableEvent((PipeRawTabletInsertionEvent)parsedEvent);
            }
        }
        finally {
            sourceEvent.close();
        }
    }

    private boolean canSkipParsing4TsFileEvent(PipeTsFileInsertionEvent sourceEvent) {
        return !sourceEvent.shouldParseTimeOrPattern() || sourceEvent.isTableModelEvent() && (sourceEvent.getTablePattern() == null || !sourceEvent.getTablePattern().hasTablePattern()) && !sourceEvent.shouldParseTime();
    }

    private void collectParsedRawTableEvent(PipeRawTabletInsertionEvent parsedEvent) {
        if (!parsedEvent.hasNoNeedParsingAndIsEmpty()) {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)parsedEvent);
        }
    }

    private void parseAndCollectEvent(PipeDeleteDataNodeEvent deleteDataEvent) {
        if (this.isUsedForConsensusPipe) {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)deleteDataEvent);
            return;
        }
        (deleteDataEvent.getDeleteDataNode() instanceof DeleteDataNode ? (Optional<PipeDeleteDataNodeEvent>)IoTDBSchemaRegionExtractor.TREE_PATTERN_PARSE_VISITOR.process(deleteDataEvent.getDeleteDataNode(), (IoTDBTreePattern)deleteDataEvent.getTreePattern()) : ((Optional)IoTDBSchemaRegionExtractor.TABLE_PATTERN_PARSE_VISITOR.process(deleteDataEvent.getDeleteDataNode(), deleteDataEvent.getTablePattern())).flatMap(planNode -> (Optional)IoTDBSchemaRegionExtractor.TABLE_PRIVILEGE_PARSE_VISITOR.process((PlanNode)planNode, deleteDataEvent.getUserName()))).map(planNode -> new PipeDeleteDataNodeEvent((AbstractDeleteDataNode)planNode, deleteDataEvent.getPipeName(), deleteDataEvent.getCreationTime(), deleteDataEvent.getPipeTaskMeta(), deleteDataEvent.getTreePattern(), deleteDataEvent.getTablePattern(), deleteDataEvent.getUserName(), deleteDataEvent.isSkipIfNoPrivileges(), deleteDataEvent.isGeneratedByPipe())).ifPresent(event -> {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)event);
        });
    }

    private void collectEvent(Event event) {
        if (event instanceof EnrichedEvent) {
            if (!((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName())) {
                LOGGER.warn("PipeEventCollector: The event {} is already released, skipping it.", (Object)event);
                this.isFailedToIncreaseReferenceCount = true;
                return;
            }
            PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId((EnrichedEvent)event, this.creationTime, this.regionId);
            ((EnrichedEvent)event).setRebootTimes(PipeDataNodeAgent.runtime().getRebootTimes());
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        this.pendingQueue.directOffer(event);
        this.collectInvocationCount.incrementAndGet();
    }

    public void resetFlags() {
        this.collectInvocationCount.set(0);
        this.hasNoGeneratedEvent = true;
        this.isFailedToIncreaseReferenceCount = false;
    }

    public long getCollectInvocationCount() {
        return this.collectInvocationCount.get();
    }

    public boolean hasNoCollectInvocationAfterReset() {
        return this.collectInvocationCount.get() == 0;
    }

    public boolean hasNoGeneratedEvent() {
        return this.hasNoGeneratedEvent;
    }

    public boolean isFailedToIncreaseReferenceCount() {
        return this.isFailedToIncreaseReferenceCount;
    }
}

