/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.processor;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.pipe.agent.task.connection.EventSupplier;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeReportableSubtask;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.agent.task.subtask.processor.PipeProcessorSubtaskWorkerManager;
import org.apache.iotdb.db.pipe.event.UserDefinedEnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.metric.processor.PipeProcessorMetrics;
import org.apache.iotdb.db.pipe.processor.pipeconsensus.PipeConsensusProcessor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcessorSubtask
extends PipeReportableSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeProcessorSubtask.class);
    private static final AtomicReference<PipeProcessorSubtaskWorkerManager> subtaskWorkerManager = new AtomicReference();
    private final String pipeName;
    private final String pipeNameWithCreationTime;
    private final int regionId;
    private final EventSupplier inputEventSupplier;
    private final PipeProcessor pipeProcessor;
    private final PipeEventCollector outputEventCollector;
    private final long subtaskCreationTime;

    public PipeProcessorSubtask(String taskID, String pipeName, long creationTime, int regionId, EventSupplier inputEventSupplier, PipeProcessor pipeProcessor, PipeEventCollector outputEventCollector) {
        super(taskID, creationTime);
        this.pipeName = pipeName;
        this.pipeNameWithCreationTime = pipeName + "_" + creationTime;
        this.regionId = regionId;
        this.inputEventSupplier = inputEventSupplier;
        this.pipeProcessor = pipeProcessor;
        this.outputEventCollector = outputEventCollector;
        this.subtaskCreationTime = System.currentTimeMillis();
        if (StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(regionId))) {
            PipeProcessorMetrics.getInstance().register(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService ignored, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskScheduler = subtaskScheduler;
        if (subtaskWorkerManager.get() == null) {
            Class<PipeProcessorSubtaskWorkerManager> clazz = PipeProcessorSubtaskWorkerManager.class;
            // MONITORENTER : org.apache.iotdb.db.pipe.agent.task.subtask.processor.PipeProcessorSubtaskWorkerManager.class
            if (subtaskWorkerManager.get() == null) {
                subtaskWorkerManager.set(new PipeProcessorSubtaskWorkerManager(subtaskWorkerThreadPoolExecutor));
            }
            // MONITOREXIT : clazz
        }
        subtaskWorkerManager.get().schedule(this);
    }

    protected boolean executeOnce() throws Exception {
        if (this.isClosed.get()) {
            return false;
        }
        Event event = this.lastEvent != null ? this.lastEvent : UserDefinedEnrichedEvent.maybeOf(this.inputEventSupplier.supply());
        this.setLastEvent(event);
        if (Objects.isNull(event)) {
            return false;
        }
        this.outputEventCollector.resetFlags();
        try {
            boolean shouldReport;
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).throwIfNoPrivilege();
            }
            if (!this.isClosed.get()) {
                if (event instanceof TabletInsertionEvent) {
                    this.pipeProcessor.process((TabletInsertionEvent)event, (EventCollector)this.outputEventCollector);
                    PipeProcessorMetrics.getInstance().markTabletEvent(this.taskID);
                } else if (event instanceof TsFileInsertionEvent) {
                    if (event instanceof PipeTsFileInsertionEvent && ((PipeTsFileInsertionEvent)event).shouldParse4Privilege()) {
                        try (PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)event;){
                            for (TabletInsertionEvent tabletInsertionEvent : tsFileInsertionEvent.toTabletInsertionEvents()) {
                                this.pipeProcessor.process(tabletInsertionEvent, (EventCollector)this.outputEventCollector);
                            }
                        }
                    } else {
                        this.pipeProcessor.process((TsFileInsertionEvent)event, (EventCollector)this.outputEventCollector);
                    }
                    PipeProcessorMetrics.getInstance().markTsFileEvent(this.taskID);
                    PipeDataNodeRemainingEventAndTimeMetrics.getInstance().markTsFileCollectInvocationCount(this.pipeNameWithCreationTime, this.outputEventCollector.getCollectInvocationCount());
                } else if (event instanceof PipeHeartbeatEvent) {
                    this.pipeProcessor.process(event, (EventCollector)this.outputEventCollector);
                    ((PipeHeartbeatEvent)event).onProcessed();
                    PipeProcessorMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
                } else {
                    this.pipeProcessor.process((Event)(event instanceof UserDefinedEnrichedEvent ? ((UserDefinedEnrichedEvent)event).getUserDefinedEvent() : event), (EventCollector)this.outputEventCollector);
                }
            }
            boolean bl = shouldReport = !this.isClosed.get() && this.outputEventCollector.hasNoGeneratedEvent() && !this.outputEventCollector.isFailedToIncreaseReferenceCount() && !(this.pipeProcessor instanceof PipeConsensusProcessor);
            if (shouldReport && event instanceof EnrichedEvent && this.outputEventCollector.hasNoCollectInvocationAfterReset()) {
                PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId((EnrichedEvent)event, this.creationTime, this.regionId);
            }
            this.decreaseReferenceCountAndReleaseLastEvent(event, shouldReport);
        }
        catch (PipeRuntimeOutOfMemoryCriticalException e) {
            LOGGER.info("Temporarily out of memory in pipe event processing, will wait for the memory to release.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                throw new PipeException(String.format("Exception in pipe process, subtask: %s, last event: %s, root cause: %s", this.taskID, this.lastEvent instanceof EnrichedEvent ? ((EnrichedEvent)this.lastEvent).coreReportMessage() : this.lastEvent, ErrorHandlingUtils.getRootCause(e).getMessage()), (Throwable)e);
            }
            LOGGER.info("Exception in pipe event processing, ignored because pipe is dropped.", (Throwable)e);
            this.clearReferenceCountAndReleaseLastEvent(event);
        }
        return true;
    }

    public void submitSelf() {
    }

    public boolean isStoppedByException() {
        return this.lastEvent instanceof EnrichedEvent && this.retryCount.get() > 5;
    }

    public void close() {
        PipeProcessorMetrics.getInstance().deregister(this.taskID);
        try {
            this.isClosed.set(true);
            this.pipeProcessor.close();
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred when closing pipe processor subtask {}, root cause: {}", new Object[]{this.taskID, ErrorHandlingUtils.getRootCause(e).getMessage(), e});
        }
        finally {
            super.close();
        }
    }

    boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeProcessorSubtask that = (PipeProcessorSubtask)((Object)obj);
        return Objects.equals(this.taskID, that.taskID) && Objects.equals(this.subtaskCreationTime, that.subtaskCreationTime);
    }

    public int hashCode() {
        return Objects.hash(this.taskID, this.subtaskCreationTime);
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getEventCount(boolean ignoreHeartbeat) {
        EnrichedEvent event = this.lastEvent instanceof EnrichedEvent ? (EnrichedEvent)this.lastEvent : null;
        return Objects.nonNull(event) && (!ignoreHeartbeat || !(event instanceof PipeHeartbeatEvent)) ? 1 : 0;
    }

    protected String getRootCause(Throwable throwable) {
        return ErrorHandlingUtils.getRootCause(throwable).getMessage();
    }

    protected void report(EnrichedEvent event, PipeRuntimeException exception) {
        PipeDataNodeAgent.runtime().report(event, exception);
    }
}

