/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public class PipeTransferSchemaSnapshotSealReq
extends PipeTransferFileSealReqV2 {
    private PipeTransferSchemaSnapshotSealReq() {
    }

    protected PipeRequestType getPlanType() {
        return PipeRequestType.TRANSFER_SCHEMA_SNAPSHOT_SEAL;
    }

    public static PipeTransferSchemaSnapshotSealReq toTPipeTransferReq(String treePattern, String tablePatternDatabase, String tablePatternTable, boolean isTreeCaptured, boolean isTableCaptured, String mTreeSnapshotName, long mTreeSnapshotLength, String tLogName, long tLogLength, String attributeSnapshotName, long attributeSnapshotLength, String databaseName, String typeString) throws IOException {
        List<Long> fileLengthList;
        List<String> fileNameList;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("PathPattern", treePattern);
        parameters.put("database_pattern", tablePatternDatabase);
        parameters.put("TableName", tablePatternTable);
        if (isTreeCaptured) {
            parameters.put("tree", "");
        }
        if (isTableCaptured) {
            parameters.put("table", "");
        }
        parameters.put("Database", databaseName);
        parameters.put("Type", typeString);
        if (Objects.isNull(attributeSnapshotName)) {
            fileNameList = Objects.nonNull(tLogName) ? Arrays.asList(mTreeSnapshotName, tLogName) : Collections.singletonList(mTreeSnapshotName);
            fileLengthList = Objects.nonNull(tLogName) ? Arrays.asList(mTreeSnapshotLength, tLogLength) : Collections.singletonList(mTreeSnapshotLength);
        } else {
            fileNameList = Arrays.asList(mTreeSnapshotName, tLogName, attributeSnapshotName);
            fileLengthList = Arrays.asList(mTreeSnapshotLength, tLogLength, attributeSnapshotLength);
        }
        return (PipeTransferSchemaSnapshotSealReq)new PipeTransferSchemaSnapshotSealReq().convertToTPipeTransferReq(fileNameList, fileLengthList, parameters);
    }

    public static PipeTransferSchemaSnapshotSealReq fromTPipeTransferReq(TPipeTransferReq req) {
        return (PipeTransferSchemaSnapshotSealReq)new PipeTransferSchemaSnapshotSealReq().translateFromTPipeTransferReq(req);
    }

    public static byte[] toTPipeTransferBytes(String treePattern, String tablePatternDatabase, String tablePatternTable, boolean isTreeCaptured, boolean isTableCaptured, String mTreeSnapshotName, long mTreeSnapshotLength, String tLogName, long tLogLength, String attributeSnapshotName, long attributeSnapshotLength, String databaseName, String typeString) throws IOException {
        List<Long> fileLengthList;
        List<String> fileNameList;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("PathPattern", treePattern);
        parameters.put("database_pattern", tablePatternDatabase);
        parameters.put("TableName", tablePatternTable);
        if (isTreeCaptured) {
            parameters.put("tree", "");
        }
        if (isTableCaptured) {
            parameters.put("table", "");
        }
        parameters.put("Database", databaseName);
        parameters.put("Type", typeString);
        if (Objects.isNull(attributeSnapshotName)) {
            fileNameList = Objects.nonNull(tLogName) ? Arrays.asList(mTreeSnapshotName, tLogName) : Collections.singletonList(mTreeSnapshotName);
            fileLengthList = Objects.nonNull(tLogName) ? Arrays.asList(mTreeSnapshotLength, tLogLength) : Collections.singletonList(mTreeSnapshotLength);
        } else {
            fileNameList = Arrays.asList(mTreeSnapshotName, tLogName, attributeSnapshotName);
            fileLengthList = Arrays.asList(mTreeSnapshotLength, tLogLength, attributeSnapshotLength);
        }
        return new PipeTransferSchemaSnapshotSealReq().convertToTPipeTransferSnapshotSealBytes(fileNameList, fileLengthList, parameters);
    }

    public boolean equals(Object obj) {
        return obj instanceof PipeTransferSchemaSnapshotSealReq && super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

