/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.processor.downsampling.PartialPathLastObjectCache;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;

public abstract class DownSamplingProcessor
implements PipeProcessor {
    protected long memoryLimitInBytes;
    protected boolean shouldSplitFile;
    protected String dataBaseNameWithPathSeparator;
    protected PartialPathLastObjectCache<?> pathLastObjectCache;

    public void validate(PipeParameterValidator validator) throws Exception {
        this.memoryLimitInBytes = validator.getParameters().getLongOrDefault("processor.down-sampling.memory-limit-in-bytes", 0x1000000L);
        validator.validate(memoryLimitInBytes -> (Long)memoryLimitInBytes > 0L, String.format("%s must be > 0, but got %s", "processor.down-sampling.memory-limit-in-bytes", this.memoryLimitInBytes), (Object)this.memoryLimitInBytes);
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) {
        this.shouldSplitFile = parameters.getBooleanOrDefault("processor.down-sampling.split-file", false);
        this.dataBaseNameWithPathSeparator = StorageEngine.getInstance().getDataRegion(new DataRegionId(((PipeTaskProcessorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getRegionId())).getDatabaseName() + ".";
        this.pathLastObjectCache = this.initPathLastObjectCache(this.memoryLimitInBytes);
    }

    protected abstract PartialPathLastObjectCache<?> initPathLastObjectCache(long var1);

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            eventCollector.collect((Event)tabletInsertionEvent);
            return;
        }
        AtomicReference deviceSuffix = new AtomicReference();
        AtomicReference exception = new AtomicReference();
        tabletInsertionEvent.processRowByRow((row, rowCollector) -> {
            if (deviceSuffix.get() == null) {
                deviceSuffix.set(row.getDeviceId().replaceFirst(this.dataBaseNameWithPathSeparator, ""));
            }
            this.processRow((Row)row, (RowCollector)rowCollector, (String)deviceSuffix.get(), exception);
        }).forEach(event -> {
            try {
                eventCollector.collect((Event)event);
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
    }

    protected abstract void processRow(Row var1, RowCollector var2, String var3, AtomicReference<Exception> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        if (this.shouldSplitFile) {
            try {
                for (TabletInsertionEvent tabletInsertionEvent : tsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.process(tabletInsertionEvent, eventCollector);
                }
            }
            finally {
                tsFileInsertionEvent.close();
            }
        } else {
            eventCollector.collect((Event)tsFileInsertionEvent);
        }
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        eventCollector.collect(event);
    }

    public void close() throws Exception {
        if (this.pathLastObjectCache != null) {
            this.pathLastObjectCache.close();
        }
    }
}

