/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.thrift;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.common.PipeTransferSliceReqHandler;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV1;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFileSealReqV2;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferSliceReq;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.receiver.IoTDBFileReceiver;
import org.apache.iotdb.commons.pipe.receiver.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.metric.receiver.PipeDataNodeReceiverMetrics;
import org.apache.iotdb.db.pipe.receiver.visitor.PipePlanToStatementVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementExceptionVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementTSStatusVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementTablePatternParseVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeStatementTreePatternParseVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeTableStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeTreeStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.db.pipe.receiver.visitor.PipeTreeStatementToBatchVisitor;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.protocol.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.db.tools.schema.SRStatementGenerator;
import org.apache.iotdb.db.tools.schema.SchemaRegionSnapshotParser;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataNodeReceiver
extends IoTDBFileReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeReceiver.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String[] RECEIVER_FILE_BASE_DIRS = IOTDB_CONFIG.getPipeReceiverFileDirs();
    private static FolderManager folderManager = null;
    public static final PipePlanToStatementVisitor PLAN_TO_STATEMENT_VISITOR = new PipePlanToStatementVisitor();
    public static final PipeStatementTSStatusVisitor STATEMENT_STATUS_VISITOR = new PipeStatementTSStatusVisitor();
    public static final PipeStatementExceptionVisitor STATEMENT_EXCEPTION_VISITOR = new PipeStatementExceptionVisitor();
    private static final PipeStatementTreePatternParseVisitor STATEMENT_TREE_PATTERN_PARSE_VISITOR = new PipeStatementTreePatternParseVisitor();
    private static final PipeStatementTablePatternParseVisitor STATEMENT_TABLE_PATTERN_PARSE_VISITOR = new PipeStatementTablePatternParseVisitor();
    private final PipeTableStatementDataTypeConvertExecutionVisitor tableStatementDataTypeConvertExecutionVisitor = new PipeTableStatementDataTypeConvertExecutionVisitor(this::executeStatementForTableModel);
    private final PipeTreeStatementDataTypeConvertExecutionVisitor treeStatementDataTypeConvertExecutionVisitor = new PipeTreeStatementDataTypeConvertExecutionVisitor(this::executeStatementForTreeModel);
    private final PipeTreeStatementToBatchVisitor batchVisitor = new PipeTreeStatementToBatchVisitor();
    private static final AtomicLong CONFIG_RECEIVER_ID_GENERATOR = new AtomicLong(0L);
    protected final AtomicReference<String> configReceiverId = new AtomicReference();
    private final PipeTransferSliceReqHandler sliceReqHandler = new PipeTransferSliceReqHandler();
    private static final Set<String> ALREADY_CREATED_TABLE_MODEL_DATABASES = ConcurrentHashMap.newKeySet();
    private final SqlParser tableSqlParser = new SqlParser();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private PipeMemoryBlock allocatedMemoryBlock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized TPipeTransferResp receive(TPipeTransferReq req) {
        try {
            long startTime = System.nanoTime();
            short rawRequestType = req.getType();
            if (PipeRequestType.isValidatedRequestType((short)rawRequestType)) {
                PipeRequestType requestType = PipeRequestType.valueOf((short)rawRequestType);
                if (requestType != PipeRequestType.TRANSFER_SLICE) {
                    this.sliceReqHandler.clear();
                }
                switch (requestType) {
                    case HANDSHAKE_DATANODE_V1: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferHandshakeV1(PipeTransferDataNodeHandshakeV1Req.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordHandshakeDatanodeV1Timer(System.nanoTime() - startTime);
                        }
                    }
                    case HANDSHAKE_DATANODE_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferHandshakeV2(PipeTransferDataNodeHandshakeV2Req.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordHandshakeDatanodeV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_INSERT_NODE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletInsertNode(PipeTransferTabletInsertNodeReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletInsertNodeTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_INSERT_NODE_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletInsertNode(PipeTransferTabletInsertNodeReqV2.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletInsertNodeV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_RAW: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletRaw(PipeTransferTabletRawReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletRawTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_RAW_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletRaw(PipeTransferTabletRawReqV2.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletRawV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BINARY: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBinary(PipeTransferTabletBinaryReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBinaryTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BINARY_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBinary(PipeTransferTabletBinaryReqV2.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBinaryV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BATCH: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBatch(PipeTransferTabletBatchReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBatchTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TABLET_BATCH_V2: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferTabletBatchV2(PipeTransferTabletBatchReqV2.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTabletBatchV2Timer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_PIECE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferTsFilePieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, true);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFilePieceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV1(PipeTransferTsFileSealReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFileSealTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_PIECE_WITH_MOD: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferTsFilePieceWithModReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFilePieceWithModTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_TS_FILE_SEAL_WITH_MOD: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV2(PipeTransferTsFileSealWithModReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferTsFileSealWithModTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_PLAN_NODE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferSchemaPlan(PipeTransferPlanNodeReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaPlanTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SCHEMA_SNAPSHOT_PIECE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFilePiece(PipeTransferSchemaSnapshotPieceReq.fromTPipeTransferReq(req), req instanceof AirGapPseudoTPipeTransferRequest, false);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaSnapshotPieceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SCHEMA_SNAPSHOT_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferFileSealV2(PipeTransferSchemaSnapshotSealReq.fromTPipeTransferReq(req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSchemaSnapshotSealTimer(System.nanoTime() - startTime);
                        }
                    }
                    case HANDSHAKE_CONFIGNODE_V1: 
                    case HANDSHAKE_CONFIGNODE_V2: 
                    case TRANSFER_CONFIG_PLAN: 
                    case TRANSFER_CONFIG_SNAPSHOT_PIECE: 
                    case TRANSFER_CONFIG_SNAPSHOT_SEAL: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferConfigPlan(req);
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferConfigPlanTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_SLICE: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.handleTransferSlice(PipeTransferSliceReq.fromTPipeTransferReq((TPipeTransferReq)req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferSliceTimer(System.nanoTime() - startTime);
                        }
                    }
                    case TRANSFER_COMPRESSED: {
                        try {
                            TPipeTransferResp tPipeTransferResp = this.receive(PipeTransferCompressedReq.fromTPipeTransferReq((TPipeTransferReq)req));
                            return tPipeTransferResp;
                        }
                        finally {
                            PipeDataNodeReceiverMetrics.getInstance().recordTransferCompressedTimer(System.nanoTime() - startTime);
                        }
                    }
                }
            }
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unknown PipeRequestType %s.", rawRequestType));
            LOGGER.warn("Receiver id = {}: Unknown PipeRequestType, response status = {}.", (Object)this.receiverId.get(), (Object)status);
            return new TPipeTransferResp(status);
        }
        catch (Exception e) {
            String error = String.format("Exception %s encountered while handling request %s.", e.getMessage(), req);
            LOGGER.warn("Receiver id = {}: {}", new Object[]{this.receiverId.get(), error, e});
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)error));
        }
    }

    private TPipeTransferResp handleTransferTabletInsertNode(PipeTransferTabletInsertNodeReq req) {
        InsertBaseStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletBinary(PipeTransferTabletBinaryReq req) {
        InsertBaseStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletRaw(PipeTransferTabletRawReq req) {
        InsertTabletStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndClassifyExceptions(statement));
    }

    private TPipeTransferResp handleTransferTabletBatch(PipeTransferTabletBatchReq req) {
        Pair<InsertRowsStatement, InsertMultiTabletsStatement> statementPair = req.constructStatements();
        return new TPipeTransferResp(PipeReceiverStatusHandler.getPriorStatus(Stream.of(((InsertRowsStatement)statementPair.getLeft()).isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndAddRedirectInfo((InsertBaseStatement)statementPair.getLeft()), ((InsertMultiTabletsStatement)statementPair.getRight()).isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatementAndAddRedirectInfo((InsertBaseStatement)statementPair.getRight())).collect(Collectors.toList())));
    }

    private TPipeTransferResp handleTransferTabletBatchV2(PipeTransferTabletBatchReqV2 req) {
        List<InsertBaseStatement> statementSet = req.constructStatements();
        return new TPipeTransferResp(PipeReceiverStatusHandler.getPriorStatus((statementSet.isEmpty() ? Stream.of(RpcUtils.SUCCESS_STATUS) : statementSet.stream().map(this::executeStatementAndAddRedirectInfo)).collect(Collectors.toList())));
    }

    protected String getClusterId() {
        return IoTDBDescriptor.getInstance().getConfig().getClusterId();
    }

    protected boolean shouldLogin() {
        IClientSession clientSession = SESSION_MANAGER.getCurrSessionAndUpdateIdleTime();
        return clientSession == null || !clientSession.isLogin() || super.shouldLogin();
    }

    protected String getReceiverFileBaseDir() throws DiskSpaceInsufficientException {
        return Objects.isNull(folderManager) ? null : folderManager.getNextFolder();
    }

    protected String getSenderHost() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? session.getClientAddress() : "unknown";
    }

    protected String getSenderPort() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        return session != null ? String.valueOf(session.getClientPort()) : "unknown";
    }

    protected TSStatus loadFileV1(PipeTransferFileSealReqV1 req, String fileAbsolutePath) throws IOException {
        return this.isUsingAsyncLoadTsFileStrategy.get() ? this.loadTsFileAsync(null, Collections.singletonList(fileAbsolutePath)) : this.loadTsFileSync(null, fileAbsolutePath);
    }

    protected TSStatus loadFileV2(PipeTransferFileSealReqV2 req, List<String> fileAbsolutePaths) throws IOException, IllegalPathException {
        return req instanceof PipeTransferTsFileSealWithModReq ? (this.isUsingAsyncLoadTsFileStrategy.get() ? this.loadTsFileAsync(((PipeTransferTsFileSealWithModReq)req).getDatabaseNameByTsFileName(), fileAbsolutePaths) : this.loadTsFileSync(((PipeTransferTsFileSealWithModReq)req).getDatabaseNameByTsFileName(), fileAbsolutePaths.get(req.getFileNames().size() - 1))) : this.loadSchemaSnapShot(req.getParameters(), fileAbsolutePaths);
    }

    private TSStatus loadTsFileAsync(String dataBaseName, List<String> absolutePaths) throws IOException {
        String loadActiveListeningPipeDir = IOTDB_CONFIG.getLoadActiveListeningPipeDir();
        if (Objects.isNull(loadActiveListeningPipeDir)) {
            throw new PipeException("Load active listening pipe dir is not set.");
        }
        if (Objects.nonNull(dataBaseName)) {
            File targetDir = new File(loadActiveListeningPipeDir, dataBaseName);
            return this.loadTsFileAsyncToTargetDir(targetDir, absolutePaths);
        }
        return this.loadTsFileAsyncToTargetDir(new File(loadActiveListeningPipeDir), absolutePaths);
    }

    private TSStatus loadTsFileAsyncToTargetDir(File targetDir, List<String> absolutePaths) throws IOException {
        for (String absolutePath : absolutePaths) {
            if (absolutePath == null) continue;
            File sourceFile = new File(absolutePath);
            if (Objects.equals(targetDir.getAbsolutePath(), sourceFile.getParentFile().getAbsolutePath())) continue;
            RetryUtils.retryOnException(() -> {
                FileUtils.moveFileWithMD5Check((File)sourceFile, (File)targetDir);
                return null;
            });
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus loadTsFileSync(String dataBaseName, String fileAbsolutePath) throws FileNotFoundException {
        LoadTsFileStatement statement = new LoadTsFileStatement(fileAbsolutePath);
        statement.setDeleteAfterLoad(true);
        statement.setConvertOnTypeMismatch(true);
        statement.setVerifySchema(this.validateTsFile.get());
        statement.setAutoCreateDatabase(false);
        statement.setDatabase(dataBaseName);
        return this.executeStatementAndClassifyExceptions(statement);
    }

    private TSStatus loadSchemaSnapShot(Map<String, String> parameters, List<String> fileAbsolutePaths) throws IllegalPathException, IOException {
        PartialPath databasePath = PartialPath.getQualifiedDatabasePartialPath((String)parameters.get("Database"));
        SRStatementGenerator generator = SchemaRegionSnapshotParser.translate2Statements(Paths.get(fileAbsolutePaths.get(0), new String[0]), fileAbsolutePaths.size() > 1 && Objects.nonNull(fileAbsolutePaths.get(1)) ? Paths.get(fileAbsolutePaths.get(1), new String[0]) : null, fileAbsolutePaths.size() > 2 && Objects.nonNull(fileAbsolutePaths.get(2)) ? Paths.get(fileAbsolutePaths.get(2), new String[0]) : null, databasePath);
        Set<StatementType> executionTypes = PipeSchemaRegionSnapshotEvent.getStatementTypeSet(parameters.get("Type"));
        IoTDBTreePattern treePattern = new IoTDBTreePattern(parameters.containsKey("tree"), parameters.get("PathPattern"));
        TablePattern tablePattern = new TablePattern(parameters.containsKey("table"), parameters.get("database_pattern"), parameters.get("TableName"));
        this.batchVisitor.clear();
        ArrayList results = new ArrayList();
        while (generator.hasNext()) {
            Object originalStatement;
            Object treeOrTableStatement = generator.next();
            if (treeOrTableStatement instanceof org.apache.iotdb.db.queryengine.plan.statement.Statement) {
                originalStatement = (org.apache.iotdb.db.queryengine.plan.statement.Statement)treeOrTableStatement;
                if (!executionTypes.contains((Object)((org.apache.iotdb.db.queryengine.plan.statement.Statement)originalStatement).getType())) continue;
                ((Optional)STATEMENT_TREE_PATTERN_PARSE_VISITOR.process((StatementNode)originalStatement, treePattern)).flatMap(parsedStatement -> (Optional)this.batchVisitor.process((StatementNode)parsedStatement, null)).ifPresent(statement -> results.add(this.executeStatementAndClassifyExceptions((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement)));
                continue;
            }
            if (!(treeOrTableStatement instanceof Statement)) continue;
            originalStatement = (Statement)treeOrTableStatement;
            if (!executionTypes.contains((Object)StatementType.AUTO_CREATE_DEVICE_MNODE)) continue;
            ((Optional)STATEMENT_TABLE_PATTERN_PARSE_VISITOR.process((Node)originalStatement, tablePattern)).ifPresent(statement -> results.add(this.executeStatementForTableModelWithPermissionCheck((Statement)statement, databasePath.getNodes()[1])));
        }
        this.batchVisitor.getRemainBatches().stream().filter(Optional::isPresent).forEach(statement -> results.add(this.executeStatementAndClassifyExceptions((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement.get())));
        return PipeReceiverStatusHandler.getPriorStatus(results);
    }

    private TPipeTransferResp handleTransferSchemaPlan(PipeTransferPlanNodeReq req) {
        if (req.getPlanNode() instanceof AlterLogicalViewNode) {
            TSStatus status = ((AlterLogicalViewNode)req.getPlanNode()).checkPermissionBeforeProcess(this.username);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Failed to check authority for statement {}, username = {}, response = {}.", new Object[]{this.receiverId.get(), StatementType.ALTER_LOGICAL_VIEW.name(), this.username, status});
                return new TPipeTransferResp(status);
            }
            return new TPipeTransferResp(ClusterConfigTaskExecutor.getInstance().alterLogicalViewByPipe((AlterLogicalViewNode)req.getPlanNode()));
        }
        Object statement = PLAN_TO_STATEMENT_VISITOR.process(req.getPlanNode(), null);
        return statement instanceof org.apache.iotdb.db.queryengine.plan.statement.Statement ? new TPipeTransferResp(this.executeStatementAndClassifyExceptions((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement)) : new TPipeTransferResp(this.executeStatementForTableModelWithPermissionCheck((Statement)statement, null));
    }

    private TPipeTransferResp handleTransferConfigPlan(TPipeTransferReq req) {
        return ClusterConfigTaskExecutor.getInstance().handleTransferConfigPlan(this.getConfigReceiverId(), req);
    }

    private String getConfigReceiverId() {
        if (Objects.isNull(this.configReceiverId.get())) {
            this.configReceiverId.set(IoTDBDescriptor.getInstance().getConfig().getDataNodeId() + "_" + PipeDataNodeAgent.runtime().getRebootTimes() + "_" + CONFIG_RECEIVER_ID_GENERATOR.incrementAndGet());
        }
        return this.configReceiverId.get();
    }

    private TPipeTransferResp handleTransferSlice(PipeTransferSliceReq pipeTransferSliceReq) {
        boolean isInorder = this.sliceReqHandler.receiveSlice(pipeTransferSliceReq);
        if (!isInorder) {
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_SLICE_OUT_OF_ORDER, (String)"Slice request is out of order, please check the request sequence."));
        }
        Optional req = this.sliceReqHandler.makeReqIfComplete();
        if (!req.isPresent()) {
            return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Slice received, waiting for more slices to complete the request."));
        }
        return this.receive((TPipeTransferReq)req.get());
    }

    private TSStatus executeStatementAndAddRedirectInfo(InsertBaseStatement statement) {
        TSStatus result = this.executeStatementAndClassifyExceptions(statement);
        if (result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && result.getSubStatusSize() > 0) {
            List<PartialPath> devicePaths;
            if (statement instanceof InsertRowsStatement) {
                devicePaths = ((InsertRowsStatement)statement).getDevicePaths();
            } else if (statement instanceof InsertMultiTabletsStatement) {
                devicePaths = ((InsertMultiTabletsStatement)statement).getDevicePaths();
            } else {
                LOGGER.warn("Receiver id = {}: Unsupported statement type {} for redirection.", (Object)this.receiverId.get(), (Object)statement);
                return result;
            }
            if (devicePaths.size() == result.getSubStatusSize()) {
                for (int i = 0; i < devicePaths.size(); ++i) {
                    if (!((TSStatus)result.getSubStatus().get(i)).isSetRedirectNode()) continue;
                    ((TSStatus)result.getSubStatus().get(i)).setMessage(devicePaths.get(i).getFullPath());
                }
            } else {
                LOGGER.warn("Receiver id = {}: The number of device paths is not equal to sub-status in statement {}: {}.", new Object[]{this.receiverId.get(), statement, result});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSStatus executeStatementAndClassifyExceptions(org.apache.iotdb.db.queryengine.plan.statement.Statement statement) {
        long estimatedMemory = 0L;
        double pipeReceiverActualToEstimatedMemoryRatio = PIPE_CONFIG.getPipeReceiverActualToEstimatedMemoryRatio();
        try {
            TSStatus result;
            if (statement instanceof InsertBaseStatement) {
                estimatedMemory = ((InsertBaseStatement)statement).ramBytesUsed();
                this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocate((long)((double)estimatedMemory * pipeReceiverActualToEstimatedMemoryRatio));
            }
            if ((result = this.executeStatementWithPermissionCheckAndRetryOnDataTypeMismatch(statement)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                TSStatus tSStatus = result;
                return tSStatus;
            }
            LOGGER.warn("Receiver id = {}: Failure status encountered while executing statement {}: {}", new Object[]{this.receiverId.get(), statement, result});
            TSStatus tSStatus = statement.accept(STATEMENT_STATUS_VISITOR, result);
            return tSStatus;
        }
        catch (PipeRuntimeOutOfMemoryCriticalException e) {
            String message = String.format("Temporarily out of memory when executing statement %s, Requested memory: %s, used memory: %s, total memory: %s", statement, (double)estimatedMemory * pipeReceiverActualToEstimatedMemoryRatio, PipeDataNodeResourceManager.memory().getUsedMemorySizeInBytes(), PipeDataNodeResourceManager.memory().getFreeMemorySizeInBytes());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Receiver id = {}: {}", new Object[]{this.receiverId.get(), message, e});
            }
            TSStatus tSStatus = new TSStatus(TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(message);
            return tSStatus;
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Exception encountered while executing statement {}: ", new Object[]{this.receiverId.get(), statement, e});
            TSStatus tSStatus = statement.accept(STATEMENT_EXCEPTION_VISITOR, e);
            return tSStatus;
        }
        finally {
            if (Objects.nonNull(this.allocatedMemoryBlock)) {
                this.allocatedMemoryBlock.close();
                this.allocatedMemoryBlock = null;
            }
        }
    }

    private TSStatus executeStatementWithPermissionCheckAndRetryOnDataTypeMismatch(org.apache.iotdb.db.queryengine.plan.statement.Statement statement) {
        TSStatus status;
        TSStatus permissionCheckStatus;
        String databaseName;
        boolean isTableModelStatement;
        if (statement == null) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_EXECUTE_STATEMENT_ERROR, (String)"Execute null statement.");
        }
        if (statement instanceof LoadTsFileStatement && ((LoadTsFileStatement)statement).getDatabase() != null) {
            isTableModelStatement = true;
            databaseName = ((LoadTsFileStatement)statement).getDatabase();
        } else if (statement instanceof InsertBaseStatement && ((InsertBaseStatement)statement).isWriteToTable()) {
            isTableModelStatement = true;
            databaseName = ((InsertBaseStatement)statement).getDatabaseName().isPresent() ? ((InsertBaseStatement)statement).getDatabaseName().get() : null;
        } else {
            isTableModelStatement = false;
            databaseName = null;
        }
        TSStatus loginStatus = this.loginIfNecessary();
        if (loginStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return loginStatus;
        }
        IClientSession clientSession = SESSION_MANAGER.getCurrSession();
        if (!isTableModelStatement && (permissionCheckStatus = AuthorityChecker.checkAuthority(statement, clientSession)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Receiver id = {}: Failed to check authority for statement {}, username = {}, response = {}.", new Object[]{this.receiverId.get(), statement.getType().name(), this.username, permissionCheckStatus});
            return RpcUtils.getStatus((int)permissionCheckStatus.getCode(), (String)permissionCheckStatus.getMessage());
        }
        TSStatus tSStatus = status = isTableModelStatement ? this.executeStatementForTableModel(statement, databaseName) : this.executeStatementForTreeModel(statement);
        return this.shouldConvertDataTypeOnTypeMismatch && (statement instanceof InsertBaseStatement && ((InsertBaseStatement)statement).hasFailedMeasurements() || status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) ? (isTableModelStatement ? statement.accept(this.tableStatementDataTypeConvertExecutionVisitor, new Pair((Object)status, (Object)databaseName)).orElse(status) : statement.accept(this.treeStatementDataTypeConvertExecutionVisitor, status).orElse(status)) : status;
    }

    protected TSStatus login() {
        BasicOpenSessionResp openSessionResp = SESSION_MANAGER.login(SESSION_MANAGER.getCurrSession(), this.username, this.password, ZoneId.systemDefault().toString(), SessionManager.CURRENT_RPC_VERSION, IoTDBConstant.ClientVersion.V_1_0);
        return RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
    }

    private TSStatus executeStatementForTableModel(org.apache.iotdb.db.queryengine.plan.statement.Statement statement, String databaseName) {
        try {
            this.autoCreateDatabaseIfNecessary(databaseName);
            return Coordinator.getInstance().executeForTableModel((org.apache.iotdb.db.queryengine.plan.statement.Statement)(this.shouldMarkAsPipeRequest.get() ? new PipeEnrichedStatement((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement) : statement), (SqlParser)this.tableSqlParser, (IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (long)IoTDBDataNodeReceiver.SESSION_MANAGER.requestQueryId(), (SessionInfo)IoTDBDataNodeReceiver.SESSION_MANAGER.getSessionInfoOfPipeReceiver((IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (String)databaseName), (String)"", (Metadata)LocalExecutionPlanner.getInstance().metadata, (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold()).status;
        }
        catch (Exception e) {
            ALREADY_CREATED_TABLE_MODEL_DATABASES.remove(databaseName);
            Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
            if (rootCause.getMessage() != null && rootCause.getMessage().toLowerCase(Locale.ENGLISH).contains("Database is not set".toLowerCase(Locale.ENGLISH))) {
                this.autoCreateDatabaseIfNecessary(databaseName);
                return Coordinator.getInstance().executeForTableModel((org.apache.iotdb.db.queryengine.plan.statement.Statement)(this.shouldMarkAsPipeRequest.get() ? new PipeEnrichedStatement((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement) : statement), (SqlParser)this.tableSqlParser, (IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (long)IoTDBDataNodeReceiver.SESSION_MANAGER.requestQueryId(), (SessionInfo)IoTDBDataNodeReceiver.SESSION_MANAGER.getSessionInfoOfPipeReceiver((IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (String)databaseName), (String)"", (Metadata)LocalExecutionPlanner.getInstance().metadata, (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold()).status;
            }
            throw e;
        }
    }

    private void autoCreateDatabaseIfNecessary(String database) {
        if (ALREADY_CREATED_TABLE_MODEL_DATABASES.contains(database)) {
            return;
        }
        Coordinator.getInstance().getAccessControl().checkCanCreateDatabase(this.username, database);
        TDatabaseSchema schema = new TDatabaseSchema(new TDatabaseSchema(database));
        schema.setIsTableModel(true);
        CreateDBTask task = new CreateDBTask(schema, true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(ClusterConfigTaskExecutor.getInstance());
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            int statusCode = result.getStatusCode().getStatusCode();
            if (statusCode != TSStatusCode.SUCCESS_STATUS.getStatusCode() && statusCode != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
                throw new PipeException(String.format("Auto create database failed: %s, status code: %s", database, result.getStatusCode()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PipeException("Auto create database failed because: " + e.getMessage());
        }
        ALREADY_CREATED_TABLE_MODEL_DATABASES.add(database);
    }

    private TSStatus executeStatementForTreeModel(org.apache.iotdb.db.queryengine.plan.statement.Statement statement) {
        return Coordinator.getInstance().executeForTreeModel((org.apache.iotdb.db.queryengine.plan.statement.Statement)(this.shouldMarkAsPipeRequest.get() ? new PipeEnrichedStatement((org.apache.iotdb.db.queryengine.plan.statement.Statement)statement) : statement), (long)IoTDBDataNodeReceiver.SESSION_MANAGER.requestQueryId(), (SessionInfo)IoTDBDataNodeReceiver.SESSION_MANAGER.getSessionInfo((IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession()), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), (boolean)false).status;
    }

    private TSStatus executeStatementForTableModelWithPermissionCheck(Statement statement, String databaseName) {
        try {
            TSStatus status = this.loginIfNecessary();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            TSStatus result = Coordinator.getInstance().executeForTableModel((Statement)(this.shouldMarkAsPipeRequest.get() ? new PipeEnriched((Statement)statement) : statement), (SqlParser)this.tableSqlParser, (IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (long)IoTDBDataNodeReceiver.SESSION_MANAGER.requestQueryId(), (SessionInfo)IoTDBDataNodeReceiver.SESSION_MANAGER.getSessionInfoOfPipeReceiver((IClientSession)IoTDBDataNodeReceiver.SESSION_MANAGER.getCurrSession(), (String)databaseName), (String)"", (Metadata)LocalExecutionPlanner.getInstance().metadata, (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), (boolean)false).status;
            if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                LOGGER.warn("Receiver id = {}: Failure status encountered while executing statement {}: {}", new Object[]{this.receiverId.get(), statement, result});
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.warn("Receiver id = {}: Exception encountered while executing statement {}: ", new Object[]{this.receiverId.get(), statement, e});
            return new TSStatus(TSStatusCode.PIPE_TRANSFER_EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public synchronized void handleExit() {
        if (Objects.nonNull(this.configReceiverId.get())) {
            try {
                ClusterConfigTaskExecutor.getInstance().handlePipeConfigClientExit(this.configReceiverId.get());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to handle config client (id = {}) exit", (Object)this.configReceiverId.get(), (Object)e);
            }
        }
        super.handleExit();
    }

    protected void closeSession() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        if (session != null) {
            SESSION_MANAGER.closeSession(session, Coordinator.getInstance()::cleanupQueryExecution);
        }
        SESSION_MANAGER.removeCurrSession();
    }

    static {
        try {
            folderManager = new FolderManager(Arrays.asList(RECEIVER_FILE_BASE_DIRS), DirectoryStrategyType.SEQUENCE_STRATEGY);
        }
        catch (DiskSpaceInsufficientException e) {
            LOGGER.error("Fail to create pipe receiver file folders allocation strategy because all disks of folders are full.", (Throwable)((Object)e));
        }
    }
}

