/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.builder.EvaluationDAGBuilder;
import org.apache.iotdb.db.queryengine.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.input.TsBlockInputDataSet;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class TransformOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TransformOperator.class);
    protected final float udfReaderMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfReaderMemoryBudgetInMB();
    protected final float udfTransformerMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfTransformerMemoryBudgetInMB();
    protected final float udfCollectorMemoryBudgetInMB = IoTDBDescriptor.getInstance().getConfig().getUdfCollectorMemoryBudgetInMB();
    protected final OperatorContext operatorContext;
    protected final Operator inputOperator;
    protected final boolean keepNull;
    protected QueryDataSetInputLayer inputLayer;
    protected UDTFContext udtfContext;
    protected LayerReader[] transformers;
    protected List<TSDataType> outputDataTypes;
    protected TimeSelector timeHeap;
    protected TsBlock[] outputColumns;
    protected int[] currentIndexes;
    protected boolean[] shouldIterateReadersToNextValid;
    private final String udtfQueryId;

    public TransformOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> inputDataTypes, Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, boolean keepNull, ZoneId zoneId, Map<NodeRef<Expression>, TSDataType> expressionTypes, boolean isAscending) throws QueryProcessException {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.keepNull = keepNull;
        this.udtfQueryId = operatorContext.getDriverContext().getDriverTaskID().getFullId();
        this.initInputLayer(inputDataTypes);
        this.initUdtfContext(outputExpressions, zoneId);
        this.initTransformers(inputLocations, outputExpressions, expressionTypes);
        this.outputColumns = new TsBlock[this.transformers.length];
        this.currentIndexes = new int[this.transformers.length];
        this.timeHeap = new TimeSelector(this.transformers.length << 1, isAscending);
        this.shouldIterateReadersToNextValid = new boolean[outputExpressions.length];
        Arrays.fill(this.shouldIterateReadersToNextValid, true);
    }

    private void initInputLayer(List<TSDataType> inputDataTypes) throws QueryProcessException {
        this.inputLayer = new QueryDataSetInputLayer(this.udtfQueryId, this.udfReaderMemoryBudgetInMB, new TsBlockInputDataSet(this.inputOperator, inputDataTypes));
    }

    private void initUdtfContext(Expression[] outputExpressions, ZoneId zoneId) {
        this.udtfContext = new UDTFContext(zoneId);
        this.udtfContext.constructUdfExecutors(outputExpressions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTransformers(Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        UDFManagementService.getInstance().acquireLock();
        try {
            UDFClassLoaderManager.getInstance().initializeUDFQuery(this.udtfQueryId);
            this.transformers = new EvaluationDAGBuilder(this.udtfQueryId, this.inputLayer, inputLocations, outputExpressions, expressionTypes, this.udtfContext, this.udfTransformerMemoryBudgetInMB + this.udfCollectorMemoryBudgetInMB).buildLayerMemoryAssigner().bindInputLayerColumnIndexWithExpression().buildResultColumnPointReaders().getOutputReaders();
        }
        finally {
            UDFManagementService.getInstance().releaseLock();
        }
    }

    protected YieldableState iterateAllColumnsToNextValid() throws Exception {
        int n = this.shouldIterateReadersToNextValid.length;
        for (int i = 0; i < n; ++i) {
            if (!this.shouldIterateReadersToNextValid[i]) continue;
            YieldableState yieldableState = this.iterateReaderToNextValid(i);
            if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            this.shouldIterateReadersToNextValid[i] = false;
        }
        return YieldableState.YIELDABLE;
    }

    protected YieldableState iterateReaderToNextValid(int index) throws Exception {
        block0: do {
            if (this.outputColumns[index] == null) {
                TsBlock block;
                YieldableState state = this.transformers[index].yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = this.transformers[index].current();
                this.outputColumns[index] = block = new TsBlock(columns[1], new Column[]{columns[0]});
                this.currentIndexes[index] = 0;
            }
            Column outputValueColumn = this.outputColumns[index].getColumn(0);
            while (outputValueColumn.isNull(this.currentIndexes[index]) && !this.keepNull) {
                int n = index;
                this.currentIndexes[n] = this.currentIndexes[n] + 1;
                if (this.currentIndexes[index] != outputValueColumn.getPositionCount()) continue;
                this.transformers[index].consumedAll();
                this.outputColumns[index] = null;
                this.currentIndexes[index] = 0;
                continue block0;
            }
        } while (this.outputColumns[index] == null);
        Column outputTimeColumn = this.outputColumns[index].getTimeColumn();
        long time = outputTimeColumn.getLong(this.currentIndexes[index]);
        this.timeHeap.add(time);
        return YieldableState.YIELDABLE;
    }

    @Override
    public final boolean hasNext() throws Exception {
        if (!this.timeHeap.isEmpty()) {
            return true;
        }
        try {
            if (this.iterateAllColumnsToNextValid() == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return !this.timeHeap.isEmpty();
    }

    @Override
    public TsBlock next() throws Exception {
        try {
            YieldableState yieldableState = this.iterateAllColumnsToNextValid();
            if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return null;
            }
            TsBlockBuilder tsBlockBuilder = TsBlockBuilder.createWithOnlyTimeColumn();
            this.prepareTsBlockBuilder(tsBlockBuilder);
            TimeColumnBuilder timeBuilder = tsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
            int columnCount = columnBuilders.length;
            int rowCount = 0;
            while (!this.timeHeap.isEmpty()) {
                long currentTime = this.timeHeap.pollFirst();
                timeBuilder.writeLong(currentTime);
                for (int i = 0; i < columnCount; ++i) {
                    yieldableState = this.collectDataPoint(columnBuilders[i], currentTime, i);
                    if (yieldableState != YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) continue;
                    for (int j = 0; j <= i; ++j) {
                        this.shouldIterateReadersToNextValid[j] = false;
                    }
                    this.timeHeap.add(currentTime);
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                this.prepareEachColumn(columnCount);
                ++rowCount;
                yieldableState = this.iterateAllColumnsToNextValid();
                if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                this.inputLayer.updateRowRecordListEvictionUpperBound();
            }
            tsBlockBuilder.declarePositions(rowCount);
            return tsBlockBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void prepareTsBlockBuilder(TsBlockBuilder tsBlockBuilder) {
        if (this.outputDataTypes == null) {
            this.outputDataTypes = new ArrayList<TSDataType>();
            for (LayerReader reader : this.transformers) {
                this.outputDataTypes.add(reader.getDataTypes()[0]);
            }
        }
        tsBlockBuilder.buildValueColumnBuilders(this.outputDataTypes);
    }

    private void prepareEachColumn(int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            if (!this.shouldIterateReadersToNextValid[i]) continue;
            int n = i;
            this.currentIndexes[n] = this.currentIndexes[n] + 1;
            if (this.currentIndexes[i] != this.outputColumns[i].getColumn(0).getPositionCount()) continue;
            this.transformers[i].consumedAll();
            this.outputColumns[i] = null;
            this.currentIndexes[i] = 0;
        }
    }

    protected YieldableState collectDataPoint(ColumnBuilder writer, long currentTime, int index) throws Exception {
        YieldableState state = this.transformers[index].yield();
        if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) {
            writer.appendNull();
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        if (state != YieldableState.YIELDABLE) {
            return state;
        }
        Column timeColumn = this.outputColumns[index].getTimeColumn();
        Column valueColumn = this.outputColumns[index].getColumn(0);
        int currentIndex = this.currentIndexes[index];
        if (timeColumn.getLong(currentIndex) != currentTime) {
            writer.appendNull();
            return YieldableState.YIELDABLE;
        }
        if (valueColumn.isNull(currentIndex)) {
            writer.appendNull();
        } else {
            TSDataType type = this.transformers[index].getDataTypes()[0];
            switch (type) {
                case INT32: 
                case DATE: {
                    writer.writeInt(valueColumn.getInt(currentIndex));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    writer.writeLong(valueColumn.getLong(currentIndex));
                    break;
                }
                case FLOAT: {
                    writer.writeFloat(valueColumn.getFloat(currentIndex));
                    break;
                }
                case DOUBLE: {
                    writer.writeDouble(valueColumn.getDouble(currentIndex));
                    break;
                }
                case BOOLEAN: {
                    writer.writeBoolean(valueColumn.getBoolean(currentIndex));
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    writer.writeBinary(valueColumn.getBinary(currentIndex));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                }
            }
        }
        this.shouldIterateReadersToNextValid[index] = true;
        return YieldableState.YIELDABLE;
    }

    @Override
    public void close() throws Exception {
        this.udtfContext.finalizeUDFExecutors(this.udtfQueryId);
        this.inputOperator.close();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        boolean flag = !this.hasNextWithTimer();
        return this.timeHeap.isEmpty() && (flag || this.inputOperator.isFinished());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return (long)(this.udfCollectorMemoryBudgetInMB + this.udfTransformerMemoryBudgetInMB + (float)this.inputOperator.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return (long)(1 + this.transformers.length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.shouldIterateReadersToNextValid) + RamUsageEstimator.sizeOf((String)this.udtfQueryId);
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return (long)((float)this.inputOperator.calculateRetainedSizeAfterCallingNext() + this.udfCollectorMemoryBudgetInMB);
    }

    @TestOnly
    public LayerReader[] getTransformers() {
        return this.transformers;
    }
}

