/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AlterLogicalViewNode
extends PlanNode {
    private final Map<PartialPath, ViewExpression> viewPathToSourceMap;

    public AlterLogicalViewNode(PlanNodeId id, Map<PartialPath, ViewExpression> viewPathToSourceMap) {
        super(id);
        this.viewPathToSourceMap = viewPathToSourceMap;
    }

    public Map<PartialPath, ViewExpression> getViewPathToSourceMap() {
        return this.viewPathToSourceMap;
    }

    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        ArrayList<PartialPath> targetPathList = new ArrayList<PartialPath>(this.viewPathToSourceMap.keySet());
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, targetPathList, PrivilegeType.WRITE_SCHEMA), targetPathList, PrivilegeType.WRITE_SCHEMA);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlterLogicalView(this, context);
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.ALTER_LOGICAL_VIEW;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of AlterLogicalNode is not implemented");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterLogicalViewNode that = (AlterLogicalViewNode)obj;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.viewPathToSourceMap, that.viewPathToSourceMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.viewPathToSourceMap);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new NotImplementedException("getOutputColumnNames of AlterLogicalViewNode is not implemented");
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALTER_LOGICAL_VIEW.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.viewPathToSourceMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            ViewExpression.serialize((ViewExpression)entry.getValue(), (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALTER_LOGICAL_VIEW.serialize(stream);
        ReadWriteIOUtils.write((int)this.viewPathToSourceMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ViewExpression.serialize((ViewExpression)entry.getValue(), (OutputStream)stream);
        }
    }

    public static AlterLogicalViewNode deserialize(ByteBuffer byteBuffer) {
        HashMap<PartialPath, ViewExpression> viewPathToSourceMap = new HashMap<PartialPath, ViewExpression>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            ViewExpression viewExpression = ViewExpression.deserialize((ByteBuffer)byteBuffer);
            viewPathToSourceMap.put(path, viewExpression);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlterLogicalViewNode(planNodeId, viewPathToSourceMap);
    }
}

