/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataTypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericDataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NumericParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TypeParameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    public static <T extends Expression> T rewriteWith(ExpressionRewriter<Void> rewriter, T node) {
        return new ExpressionTreeRewriter<Void>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    private List<Expression> rewrite(List<Expression> items, Context<C> context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : items) {
            builder.add((Object)this.rewrite(expression, context.get()));
        }
        return builder.build();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, true));
    }

    public static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    public static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            throw new UnsupportedOperationException("visit() not implemented for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteRow(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List items = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getItems()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getItems(), items)) {
                return new Row(items);
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticUnary(ArithmeticUnaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticUnary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticUnaryExpression(node.getSign(), child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticBinary(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalExpression(LogicalExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List terms = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getTerms()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getTerms(), terms)) {
                return new LogicalExpression(node.getOperator(), terms);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNotNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitIfExpression(IfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression condition = ExpressionTreeRewriter.this.rewrite(node.getCondition(), context.get());
            Expression trueValue = ExpressionTreeRewriter.this.rewrite(node.getTrueValue(), context.get());
            Expression falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = ExpressionTreeRewriter.this.rewrite(node.getFalseValue().get(), context.get());
            }
            if (condition != node.getCondition() || trueValue != node.getTrueValue() || falseValue != node.getFalseValue().orElse(null)) {
                return new IfExpression(condition, trueValue, falseValue);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression2 : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression2, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return defaultValue.map(expression -> new SearchedCaseExpression((List<WhenClause>)builder.build(), (Expression)expression)).orElseGet(() -> new SearchedCaseExpression((List<WhenClause>)builder.build()));
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression2 : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression2, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> ExpressionTreeRewriter.this.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return defaultValue.map(expression -> new SimpleCaseExpression(operand, (List<WhenClause>)builder.build(), (Expression)expression)).orElseGet(() -> new SimpleCaseExpression(operand, (List<WhenClause>)builder.build()));
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWhenClause(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result2 = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(operand, result2);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCoalesceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List operands = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getOperands()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), operands)) {
                return new CoalesceExpression(operands);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List arguments = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getArguments()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getArguments(), arguments)) {
                return new FunctionCall(node.getName(), arguments);
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLikePredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression pattern = ExpressionTreeRewriter.this.rewrite(node.getPattern(), context.get());
            Optional<Expression> rewrittenEscape = node.getEscape().map(escape -> ExpressionTreeRewriter.this.rewrite(escape, context.get()));
            if (value != node.getValue() || pattern != node.getPattern() || !ExpressionTreeRewriter.sameElements(node.getEscape(), rewrittenEscape)) {
                return rewrittenEscape.map(expression -> new LikePredicate(value, pattern, (Expression)expression)).orElseGet(() -> new LikePredicate(value, pattern));
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression list = ExpressionTreeRewriter.this.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInListExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            List values = ExpressionTreeRewriter.this.rewrite((Expression)((Object)node.getValues()), (Object)context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new InListExpression(values);
            }
            return node;
        }

        @Override
        protected Expression visitExists(ExistsPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExists(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression subquery = node.getSubquery();
            if ((subquery = ExpressionTreeRewriter.this.rewrite(subquery, context.get())) != node.getSubquery()) {
                return new ExistsPredicate(subquery);
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubqueryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLiteral(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitParameter(Parameter node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteParameter(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitIdentifier(Identifier node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIdentifier(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitDereferenceExpression(DereferenceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteDereferenceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression base = ExpressionTreeRewriter.this.rewrite(node.getBase(), context.get());
            if (base != node.getBase()) {
                if (node.getField().isPresent()) {
                    return new DereferenceExpression(base, node.getField().get());
                }
                return new DereferenceExpression((Identifier)base);
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            DataType type = ExpressionTreeRewriter.this.rewrite(node.getType(), context.get());
            if (node.getExpression() != expression || node.getType() != type) {
                return new Cast(expression, type, node.isSafe());
            }
            return node;
        }

        @Override
        public Expression visitCurrentDatabase(CurrentDatabase node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentDatabase(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCurrentUser(CurrentUser node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentUser(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitGenericDataType(GenericDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteGenericDataType(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Identifier name = ExpressionTreeRewriter.this.rewrite(node.getName(), context.get());
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (DataTypeParameter argument : node.getArguments()) {
                if (argument instanceof NumericParameter) {
                    arguments.add((Object)argument);
                    continue;
                }
                if (!(argument instanceof TypeParameter)) continue;
                TypeParameter parameter = (TypeParameter)argument;
                DataType value = (DataType)this.process(parameter.getValue(), context);
                if (value != parameter.getValue()) {
                    arguments.add((Object)new TypeParameter(value));
                    continue;
                }
                arguments.add((Object)argument);
            }
            ImmutableList rewrittenArguments = arguments.build();
            if (name != node.getName() || !ExpressionTreeRewriter.sameElements(rewrittenArguments, node.getArguments())) {
                return node.getLocation().isPresent() ? new GenericDataType(node.getLocation().get(), name, (List<DataTypeParameter>)rewrittenArguments) : new GenericDataType(name, (List<DataTypeParameter>)rewrittenArguments);
            }
            return node;
        }

        @Override
        protected Expression visitFieldReference(FieldReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFieldReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitSymbolReference(SymbolReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSymbolReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteQuantifiedComparison(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression subquery = ExpressionTreeRewriter.this.rewrite(node.getSubquery(), context.get());
            if (node.getValue() != value || node.getSubquery() != subquery) {
                return new QuantifiedComparisonExpression(node.getOperator(), node.getQuantifier(), value, subquery);
            }
            return node;
        }

        @Override
        protected Expression visitTrim(Trim node, Context<C> context) {
            Optional<Expression> trimChar;
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteTrim(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            expressions.add((Object)node.getTrimSource());
            node.getTrimCharacter().ifPresent(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
            Expression trimSource = ExpressionTreeRewriter.this.rewrite(node.getTrimSource(), context.get());
            Optional<Expression> optional = trimChar = node.getTrimCharacter().isPresent() ? Optional.of(ExpressionTreeRewriter.this.rewrite(node.getTrimCharacter().get(), context.get())) : Optional.empty();
            if (trimSource != node.getTrimSource() || !ExpressionTreeRewriter.sameElements(trimChar, node.getTrimCharacter())) {
                return trimChar.map(expression -> new Trim(node.getSpecification(), trimSource, (Expression)expression)).orElseGet(() -> new Trim(node.getSpecification(), trimSource));
            }
            return node;
        }
    }
}

