/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class DropTable
extends Statement {
    private final QualifiedName tableName;
    private final boolean exists;

    public DropTable(QualifiedName tableName, boolean exists) {
        super(null);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.exists = exists;
    }

    public DropTable(NodeLocation location, QualifiedName tableName, boolean exists) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.exists = exists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropTable o = (DropTable)obj;
        return Objects.equals(this.tableName, o.tableName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("exists", this.exists).toString();
    }
}

