/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.udf;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDFParametersFactory;
import org.apache.iotdb.udf.api.UDAF;
import org.apache.iotdb.udf.api.customizer.config.UDAFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDAFInformationInferrer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDAFInformationInferrer.class);
    protected final String functionName;

    public UDAFInformationInferrer(String functionName) {
        this.functionName = functionName;
    }

    public TSDataType inferOutputType(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        try {
            return UDFDataTypeTransformer.transformToTsDataType((Type)this.reflectAndGetConfigurations(childExpressions, childExpressionDataTypes, attributes).getOutputDataType());
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during inferring UDF data type", (Throwable)e);
            throw new SemanticException(String.format("Error occurred during inferring UDF data type: %s", System.lineSeparator()) + e);
        }
    }

    private UDAFConfigurations reflectAndGetConfigurations(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) throws Exception {
        UDAF udaf = (UDAF)UDFManagementService.getInstance().reflect(this.functionName, UDAF.class);
        UDFParameters parameters = UDFParametersFactory.buildUdfParameters(childExpressions, childExpressionDataTypes, attributes);
        udaf.validate(new UDFParameterValidator(parameters));
        UDAFConfigurations configurations = new UDAFConfigurations();
        udaf.beforeStart(parameters, configurations);
        udaf.beforeDestroy();
        return configurations;
    }
}

