/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.metrics;

import java.util.function.Supplier;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.RatisMetrics;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.thirdparty.com.google.protobuf.AbstractMessage;

public class ZeroCopyMetrics
extends RatisMetrics {
    private static final String RATIS_GRPC_METRICS_APP_NAME = "ratis_grpc";
    private static final String RATIS_GRPC_METRICS_COMP_NAME = "zero_copy";
    private static final String RATIS_GRPC_METRICS_DESC = "Metrics for Ratis Grpc Zero copy";
    private final LongCounter zeroCopyMessages = this.getRegistry().counter("num_zero_copy_messages");
    private final LongCounter nonZeroCopyMessages = this.getRegistry().counter("num_non_zero_copy_messages");
    private final LongCounter releasedMessages = this.getRegistry().counter("num_released_messages");

    public ZeroCopyMetrics() {
        super(ZeroCopyMetrics.createRegistry());
    }

    private static RatisMetricRegistry createRegistry() {
        return ZeroCopyMetrics.create((MetricRegistryInfo)new MetricRegistryInfo("", RATIS_GRPC_METRICS_APP_NAME, RATIS_GRPC_METRICS_COMP_NAME, RATIS_GRPC_METRICS_DESC));
    }

    public void addUnreleased(String name, Supplier<Integer> unreleased) {
        this.getRegistry().gauge(name + "_num_unreleased_messages", () -> unreleased);
    }

    public void onZeroCopyMessage(AbstractMessage ignored) {
        this.zeroCopyMessages.inc();
    }

    public void onNonZeroCopyMessage(AbstractMessage ignored) {
        this.nonZeroCopyMessages.inc();
    }

    public void onReleasedMessage(AbstractMessage ignored) {
        this.releasedMessages.inc();
    }

    @VisibleForTesting
    public long zeroCopyMessages() {
        return this.zeroCopyMessages.getCount();
    }

    @VisibleForTesting
    public long nonZeroCopyMessages() {
        return this.nonZeroCopyMessages.getCount();
    }

    @VisibleForTesting
    public long releasedMessages() {
        return this.releasedMessages.getCount();
    }
}

