/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.utils;

import org.apache.iotdb.common.rpc.thrift.FunctionType;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.relational.ScalarFunction;
import org.apache.iotdb.udf.api.relational.TableFunction;

public class TableUDFUtils {
    private TableUDFUtils() {
    }

    public static boolean isScalarFunction(String functionName) {
        UDFInformation information = UDFManagementService.getInstance().getUDFInformation(Model.TABLE, functionName);
        return information != null && FunctionType.SCALAR.equals((Object)information.getUdfType().getType());
    }

    public static boolean isAggregateFunction(String functionName) {
        UDFInformation information = UDFManagementService.getInstance().getUDFInformation(Model.TABLE, functionName);
        return information != null && FunctionType.AGGREGATE.equals((Object)information.getUdfType().getType());
    }

    public static boolean isTableFunction(String functionName) {
        UDFInformation information = UDFManagementService.getInstance().getUDFInformation(Model.TABLE, functionName);
        return information != null && FunctionType.TABLE.equals((Object)information.getUdfType().getType());
    }

    public static ScalarFunction getScalarFunction(String functionName) throws UDFException {
        return UDFManagementService.getInstance().reflect(functionName, ScalarFunction.class);
    }

    public static AggregateFunction getAggregateFunction(String functionName) throws UDFException {
        return UDFManagementService.getInstance().reflect(functionName, AggregateFunction.class);
    }

    public static TableFunction getTableFunction(String functionName) throws UDFException {
        return UDFManagementService.getInstance().reflect(functionName, TableFunction.class);
    }
}

