/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class PreDeleteDatabasePlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private PreDeleteType preDeleteType;

    public PreDeleteDatabasePlan() {
        super(ConfigPhysicalPlanType.PreDeleteDatabase);
    }

    public PreDeleteDatabasePlan(String storageGroup, PreDeleteType preDeleteType) {
        this();
        this.storageGroup = storageGroup;
        this.preDeleteType = preDeleteType;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(String storageGroup) {
        this.storageGroup = storageGroup;
    }

    public PreDeleteType getPreDeleteType() {
        return this.preDeleteType;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.write(this.preDeleteType.getType());
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.preDeleteType = buffer.get() == 1 ? PreDeleteType.ROLLBACK : PreDeleteType.EXECUTE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreDeleteDatabasePlan that = (PreDeleteDatabasePlan)o;
        return this.storageGroup.equals(that.storageGroup) && this.preDeleteType == that.preDeleteType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.storageGroup, this.preDeleteType});
    }

    public static enum PreDeleteType {
        EXECUTE(0),
        ROLLBACK(1);

        private final byte type;

        private PreDeleteType(byte type) {
            this.type = type;
        }

        public byte getType() {
            return this.type;
        }
    }
}

