/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.schemaregion;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;

public class PipePlanTreePatternParseVisitor
extends PlanVisitor<Optional<PlanNode>, IoTDBTreePattern> {
    @Override
    public Optional<PlanNode> visitPlan(PlanNode node, IoTDBTreePattern pattern) {
        return Optional.of(node);
    }

    @Override
    public Optional<PlanNode> visitCreateTimeSeries(CreateTimeSeriesNode node, IoTDBTreePattern pattern) {
        return pattern.matchesMeasurement(node.getPath().getIDeviceID(), node.getPath().getMeasurement()) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, IoTDBTreePattern pattern) {
        int[] filteredIndexes = IntStream.range(0, node.getMeasurements().size()).filter(index -> pattern.matchesMeasurement(node.getDevicePath().getIDeviceIDAsFullDevice(), node.getMeasurements().get(index))).toArray();
        return filteredIndexes.length > 0 ? Optional.of(new CreateAlignedTimeSeriesNode(node.getPlanNodeId(), node.getDevicePath(), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getMeasurements()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getDataTypes()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getEncodings()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getCompressors()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getAliasList()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getTagsList()), IoTDBTreePattern.applyIndexesOnList((int[])filteredIndexes, node.getAttributesList()))) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, MeasurementGroup> filteredMeasurementGroupMap = node.getMeasurementGroupMap().entrySet().stream().filter(entry -> pattern.matchPrefixPath(((PartialPath)entry.getKey()).getFullPath())).map(entry -> new Pair((Object)((PartialPath)entry.getKey()), (Object)PipePlanTreePatternParseVisitor.trimMeasurementGroup(((PartialPath)entry.getKey()).getIDeviceIDAsFullDevice(), (MeasurementGroup)entry.getValue(), pattern))).filter(pair -> Objects.nonNull(pair.getRight())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        return !filteredMeasurementGroupMap.isEmpty() ? Optional.of(new CreateMultiTimeSeriesNode(node.getPlanNodeId(), filteredMeasurementGroupMap)) : Optional.empty();
    }

    private static MeasurementGroup trimMeasurementGroup(IDeviceID device, MeasurementGroup group, IoTDBTreePattern pattern) {
        int[] filteredIndexes = IntStream.range(0, group.size()).filter(index -> pattern.matchesMeasurement(device, group.getMeasurements().get(index))).toArray();
        if (filteredIndexes.length == 0) {
            return null;
        }
        MeasurementGroup targetMeasurementGroup = new MeasurementGroup();
        Arrays.stream(filteredIndexes).forEach(index -> {
            targetMeasurementGroup.addMeasurement(group.getMeasurements().get(index), group.getDataTypes().get(index), group.getEncodings().get(index), group.getCompressors().get(index));
            if (Objects.nonNull(group.getTagsList())) {
                targetMeasurementGroup.addTags(group.getTagsList().get(index));
            }
            if (Objects.nonNull(group.getAttributesList())) {
                targetMeasurementGroup.addAttributes(group.getAttributesList().get(index));
            }
            if (Objects.nonNull(group.getAliasList())) {
                targetMeasurementGroup.addAlias(group.getAliasList().get(index));
            }
            if (Objects.nonNull(group.getPropsList())) {
                targetMeasurementGroup.addProps(group.getPropsList().get(index));
            }
        });
        return targetMeasurementGroup;
    }

    @Override
    public Optional<PlanNode> visitAlterTimeSeries(AlterTimeSeriesNode node, IoTDBTreePattern pattern) {
        return pattern.matchesMeasurement(node.getPath().getIDeviceID(), node.getPath().getMeasurement()) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, IoTDBTreePattern pattern) {
        MeasurementGroup group = pattern.matchPrefixPath(node.getDevicePath().getFullPath()) ? PipePlanTreePatternParseVisitor.trimMeasurementGroup(node.getDevicePath().getIDeviceIDAsFullDevice(), node.getMeasurementGroup(), pattern) : null;
        return Objects.nonNull(group) ? Optional.of(new InternalCreateTimeSeriesNode(node.getPlanNodeId(), node.getDevicePath(), group, node.isAligned())) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitActivateTemplate(ActivateTemplateNode node, IoTDBTreePattern pattern) {
        return pattern.matchDevice(node.getActivatePath().getFullPath()) ? Optional.of(node) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, Pair<Integer, Integer>> filteredTemplateActivationMap = node.getTemplateActivationMap().entrySet().stream().filter(entry -> pattern.matchDevice(((PartialPath)entry.getKey()).getFullPath())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return !filteredTemplateActivationMap.isEmpty() ? Optional.of(new InternalBatchActivateTemplateNode(node.getPlanNodeId(), filteredTemplateActivationMap)) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, Pair<Boolean, MeasurementGroup>> filteredDeviceMap = node.getDeviceMap().entrySet().stream().filter(entry -> pattern.matchPrefixPath(((PartialPath)entry.getKey()).getFullPath())).map(entry -> new Pair((Object)((PartialPath)entry.getKey()), (Object)new Pair((Object)((Boolean)((Pair)entry.getValue()).getLeft()), (Object)PipePlanTreePatternParseVisitor.trimMeasurementGroup(((PartialPath)entry.getKey()).getIDeviceIDAsFullDevice(), (MeasurementGroup)((Pair)entry.getValue()).getRight(), pattern)))).filter(pair -> Objects.nonNull(((Pair)pair.getRight()).getRight())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        return !filteredDeviceMap.isEmpty() ? Optional.of(new InternalCreateMultiTimeSeriesNode(node.getPlanNodeId(), filteredDeviceMap)) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitBatchActivateTemplate(BatchActivateTemplateNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, Pair<Integer, Integer>> filteredTemplateActivationMap = node.getTemplateActivationMap().entrySet().stream().filter(entry -> pattern.matchDevice(((PartialPath)entry.getKey()).getFullPath())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return !filteredTemplateActivationMap.isEmpty() ? Optional.of(new BatchActivateTemplateNode(node.getPlanNodeId(), filteredTemplateActivationMap)) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitCreateLogicalView(CreateLogicalViewNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, ViewExpression> filteredViewPathToSourceMap = node.getViewPathToSourceExpressionMap().entrySet().stream().filter(entry -> pattern.matchesMeasurement(((PartialPath)entry.getKey()).getIDeviceID(), ((PartialPath)entry.getKey()).getMeasurement())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return !filteredViewPathToSourceMap.isEmpty() ? Optional.of(new CreateLogicalViewNode(node.getPlanNodeId(), filteredViewPathToSourceMap)) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitAlterLogicalView(AlterLogicalViewNode node, IoTDBTreePattern pattern) {
        Map<PartialPath, ViewExpression> filteredViewPathToSourceMap = node.getViewPathToSourceMap().entrySet().stream().filter(entry -> pattern.matchesMeasurement(((PartialPath)entry.getKey()).getIDeviceID(), ((PartialPath)entry.getKey()).getMeasurement())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return !filteredViewPathToSourceMap.isEmpty() ? Optional.of(new AlterLogicalViewNode(node.getPlanNodeId(), filteredViewPathToSourceMap)) : Optional.empty();
    }

    @Override
    public Optional<PlanNode> visitDeleteData(DeleteDataNode node, IoTDBTreePattern pattern) {
        List<MeasurementPath> intersectedPaths = node.getPathList().stream().map(arg_0 -> ((IoTDBTreePattern)pattern).getIntersection(arg_0)).flatMap(Collection::stream).distinct().map(d -> (MeasurementPath)d).collect(Collectors.toList());
        return !intersectedPaths.isEmpty() ? Optional.of(new DeleteDataNode(node.getPlanNodeId(), intersectedPaths, node.getDeleteStartTime(), node.getDeleteEndTime())) : Optional.empty();
    }
}

