/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.IoTDBWarning;
import org.apache.iotdb.db.queryengine.execution.warnings.StandardWarningCode;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.AggregationAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CanonicalizationAware;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CorrelationSupport;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionTreeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.tablefunction.ArgumentAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.tablefunction.ArgumentsAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.tablefunction.TableArgumentAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.tablefunction.TableFunctionInvocationAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.MetadataUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrExpressionInterpreter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractQueryDeviceWithCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AliasedRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Columns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateOrUpdateDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DeleteDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DescribeTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Except;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExplainAnalyze;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FetchDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingElement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingSets;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Insert;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRow;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertRows;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InsertTablet;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Intersect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinCriteria;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinUsing;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Limit;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NaturalJoin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetOperation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowFunctions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowIndex;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipePlugins;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleGroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SingleColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionArgument;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionInvocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionTableArgument;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableSubquery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Union;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Update;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Use;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Values;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.With;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WithQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.AstUtil;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.utils.NodeUtils;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.relational.TableFunction;
import org.apache.iotdb.udf.api.relational.table.TableFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.ScalarParameterSpecification;
import org.apache.iotdb.udf.api.relational.table.specification.TableParameterSpecification;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.RowType;
import org.apache.tsfile.utils.Binary;

public class StatementAnalyzer {
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final Analysis analysis;
    private boolean hasFillInParentScope = false;
    private final MPPQueryContext queryContext;
    private final AccessControl accessControl;
    private final WarningCollector warningCollector;
    private final SessionInfo sessionContext;
    private final TypeManager typeManager = new InternalTypeManager();
    private final Metadata metadata;
    private final CorrelationSupport correlationSupport;

    public StatementAnalyzer(StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, MPPQueryContext queryContext, AccessControl accessControl, WarningCollector warningCollector, SessionInfo sessionContext, Metadata metadata, CorrelationSupport correlationSupport) {
        this.statementAnalyzerFactory = statementAnalyzerFactory;
        this.analysis = analysis;
        this.queryContext = queryContext;
        this.accessControl = accessControl;
        this.warningCollector = warningCollector;
        this.sessionContext = sessionContext;
        this.metadata = metadata;
        this.correlationSupport = correlationSupport;
    }

    public Scope analyze(Node node) {
        return this.analyze(node, Optional.empty(), true);
    }

    public Scope analyze(Node node, Scope outerQueryScope) {
        return this.analyze(node, Optional.of(outerQueryScope), false);
    }

    private Scope analyze(Node node, Optional<Scope> outerQueryScope, boolean isTopLevel) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.empty(), isTopLevel).process(node, Optional.empty());
    }

    public Scope analyzeForUpdate(Relation relation, Optional<Scope> outerQueryScope, UpdateKind updateKind) {
        return new Visitor(outerQueryScope, this.warningCollector, Optional.of(updateKind), true).process((Node)relation, Optional.empty());
    }

    private static boolean hasScopeAsLocalParent(Scope root, Scope parent) {
        Scope scope = root;
        while (scope.getLocalParent().isPresent()) {
            if (!(scope = scope.getLocalParent().get()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(Expression predicate, String clause) {
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate));
        if (!aggregates.isEmpty()) {
            throw new SemanticException(String.format("%s cannot contain aggregations, window functions or grouping operations: %s", clause, aggregates));
        }
    }

    private final class Visitor
    extends AstVisitor<Scope, Optional<Scope>> {
        private final boolean isTopLevel;
        private final Optional<Scope> outerQueryScope;
        private final WarningCollector warningCollector;
        private final Optional<UpdateKind> updateKind;

        private Visitor(Optional<Scope> outerQueryScope, WarningCollector warningCollector, Optional<UpdateKind> updateKind, boolean isTopLevel) {
            this.outerQueryScope = Objects.requireNonNull(outerQueryScope, "outerQueryScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.updateKind = Objects.requireNonNull(updateKind, "updateKind is null");
            this.isTopLevel = isTopLevel;
        }

        @Override
        public Scope process(Node node, Optional<Scope> scope) {
            Scope returnScope = (Scope)super.process(node, scope);
            if (node instanceof PipeEnriched) {
                node = ((PipeEnriched)node).getInnerStatement();
            }
            if (node instanceof CreateOrUpdateDevice || node instanceof FetchDevice || node instanceof ShowDevice || node instanceof CountDevice || node instanceof Update || node instanceof DeleteDevice) {
                return returnScope;
            }
            Preconditions.checkState((boolean)returnScope.getOuterQueryParent().equals(this.outerQueryScope), (Object)"result scope should have outer query scope equal with parameter outer query scope");
            scope.ifPresent(value -> Preconditions.checkState((boolean)StatementAnalyzer.hasScopeAsLocalParent(returnScope, value), (Object)"return scope should have context scope as one of its ancestors"));
            return returnScope;
        }

        @Override
        private Scope process(Node node, Scope scope) {
            return this.process(node, Optional.of(scope));
        }

        @Override
        protected Scope visitNode(Node node, Optional<Scope> context) {
            throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
        }

        @Override
        protected Scope visitCreateDB(CreateDB node, Optional<Scope> context) {
            throw new SemanticException("Create Database statement is not supported yet.");
        }

        @Override
        protected Scope visitAlterDB(AlterDB node, Optional<Scope> context) {
            throw new SemanticException("Alter Database statement is not supported yet.");
        }

        @Override
        protected Scope visitDropDB(DropDB node, Optional<Scope> context) {
            throw new SemanticException("Drop Database statement is not supported yet.");
        }

        @Override
        protected Scope visitShowDB(ShowDB node, Optional<Scope> context) {
            throw new SemanticException("Show Database statement is not supported yet.");
        }

        @Override
        protected Scope visitCreateTable(CreateTable node, Optional<Scope> context) {
            this.validateProperties(node.getProperties(), context);
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDropTable(DropTable node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitShowTables(ShowTables node, Optional<Scope> context) {
            throw new SemanticException("Show Tables statement is not supported yet.");
        }

        @Override
        protected Scope visitRenameTable(RenameTable node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDescribeTable(DescribeTable node, Optional<Scope> context) {
            throw new SemanticException("Describe Table statement is not supported yet.");
        }

        @Override
        protected Scope visitSetProperties(SetProperties node, Optional<Scope> context) {
            this.validateProperties(node.getProperties(), context);
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitRenameColumn(RenameColumn node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDropColumn(DropColumn node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitAddColumn(AddColumn node, Optional<Scope> context) {
            throw new SemanticException("Add Column statement is not supported yet.");
        }

        @Override
        protected Scope visitCreateIndex(CreateIndex node, Optional<Scope> context) {
            throw new SemanticException("Create Index statement is not supported yet.");
        }

        @Override
        protected Scope visitDropIndex(DropIndex node, Optional<Scope> context) {
            throw new SemanticException("Drop Index statement is not supported yet.");
        }

        @Override
        protected Scope visitShowIndex(ShowIndex node, Optional<Scope> context) {
            throw new SemanticException("Show Index statement is not supported yet.");
        }

        @Override
        protected Scope visitUpdate(Update node, Optional<Scope> context) {
            StatementAnalyzer.this.queryContext.setQueryType(QueryType.WRITE);
            node.parseTable(StatementAnalyzer.this.sessionContext);
            StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.sessionContext.getUserName(), new QualifiedObjectName(node.getDatabase(), node.getTableName()));
            TranslationMap translationMap = this.analyzeTraverseDevice(node, context, true);
            TsTable table = DataNodeTableCache.getInstance().getTable(node.getDatabase(), node.getTableName());
            node.parseRawExpression(null, table, table.getColumnList().stream().filter(columnSchema -> columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)).map(TsTableColumnSchema::getColumnName).collect(Collectors.toList()), StatementAnalyzer.this.queryContext);
            if (node.getLocation().isPresent()) {
                HashSet attributeNames = new HashSet();
                node.setAssignments(node.getAssignments().stream().map(assignment -> {
                    Expression parsedColumn = this.analyzeAndRewriteExpression(translationMap, translationMap.getScope(), assignment.getName());
                    if (!(parsedColumn instanceof SymbolReference) || table.getColumnSchema(((SymbolReference)parsedColumn).getName()).getColumnCategory() != TsTableColumnCategory.ATTRIBUTE) {
                        throw new SemanticException("Update can only specify attribute columns.");
                    }
                    if (attributeNames.contains(parsedColumn)) {
                        throw new SemanticException("Update attribute shall specify a attribute only once.");
                    }
                    attributeNames.add((SymbolReference)parsedColumn);
                    return new UpdateAssignment(parsedColumn, this.analyzeAndRewriteExpression(translationMap, translationMap.getScope(), assignment.getValue()));
                }).collect(Collectors.toList()));
            }
            return null;
        }

        @Override
        protected Scope visitDeleteDevice(DeleteDevice node, Optional<Scope> context) {
            StatementAnalyzer.this.queryContext.setQueryType(QueryType.READ);
            node.parseTable(StatementAnalyzer.this.sessionContext);
            StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.sessionContext.getUserName(), new QualifiedObjectName(node.getDatabase(), node.getTableName()));
            TsTable table = DataNodeTableCache.getInstance().getTable(node.getDatabase(), node.getTableName());
            if (Objects.isNull(table)) {
                TableMetadataImpl.throwTableNotExistsException(node.getDatabase(), node.getTableName());
            }
            node.parseModEntries(table);
            this.analyzeTraverseDevice(node, context, node.getWhere().isPresent());
            node.parseRawExpression(null, table, table.getColumnList().stream().filter(columnSchema -> columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)).map(TsTableColumnSchema::getColumnName).collect(Collectors.toList()), StatementAnalyzer.this.queryContext);
            return null;
        }

        @Override
        protected Scope visitDropFunction(DropFunction node, Optional<Scope> context) {
            throw new SemanticException("Drop Function statement is not supported yet.");
        }

        @Override
        protected Scope visitShowFunctions(ShowFunctions node, Optional<Scope> context) {
            throw new SemanticException("Show Function statement is not supported yet.");
        }

        @Override
        protected Scope visitUse(Use node, Optional<Scope> scope) {
            throw new SemanticException("USE statement is not supported yet.");
        }

        @Override
        protected Scope visitInsert(Insert insert, Optional<Scope> scope) {
            throw new SemanticException("This kind of insert statement is not supported yet, please check your grammar.");
        }

        @Override
        protected Scope visitInsertRow(InsertRow node, Optional<Scope> context) {
            return this.visitInsert(node, context);
        }

        @Override
        protected Scope visitInsertTablet(InsertTablet insert, Optional<Scope> scope) {
            return this.visitInsert(insert, scope);
        }

        @Override
        protected Scope visitInsertRows(InsertRows node, Optional<Scope> context) {
            return this.visitInsert(node, context);
        }

        private Scope visitInsert(WrappedInsertStatement insert, Optional<Scope> scope) {
            Scope ret = Scope.create();
            MPPQueryContext context = insert.getContext();
            InsertBaseStatement innerInsert = insert.getInnerTreeStatement();
            innerInsert.semanticCheck();
            innerInsert.toLowerCase();
            innerInsert = AnalyzeUtils.analyzeInsert(context, innerInsert, () -> SchemaValidator.validate(StatementAnalyzer.this.metadata, insert, context, StatementAnalyzer.this.accessControl), StatementAnalyzer.this.metadata::getOrCreateDataPartition, AnalyzeUtils::computeTableDataPartitionParams, StatementAnalyzer.this.analysis, false);
            insert.setInnerTreeStatement(innerInsert);
            StatementAnalyzer.this.analysis.setScope(insert, ret);
            return ret;
        }

        @Override
        protected Scope visitDelete(Delete node, Optional<Scope> scope) {
            Scope ret = Scope.create();
            StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.sessionContext.getUserName(), new QualifiedObjectName(AnalyzeUtils.getDatabaseName(node, StatementAnalyzer.this.queryContext), node.getTable().getName().getSuffix()));
            AnalyzeUtils.analyzeDelete(node, StatementAnalyzer.this.queryContext);
            StatementAnalyzer.this.analysis.setScope(node, ret);
            return ret;
        }

        @Override
        protected Scope visitPipeEnriched(PipeEnriched node, Optional<Scope> scope) {
            if (node.getInnerStatement() instanceof LoadTsFile) {
                ((LoadTsFile)node.getInnerStatement()).markIsGeneratedByPipe();
            }
            Scope ret = node.getInnerStatement().accept(this, scope);
            this.createAndAssignScope(node, scope);
            StatementAnalyzer.this.analysis.setScope(node, ret);
            return ret;
        }

        @Override
        protected Scope visitLoadTsFile(LoadTsFile node, Optional<Scope> scope) {
            StatementAnalyzer.this.queryContext.setQueryType(QueryType.WRITE);
            try (LoadTsFileAnalyzer loadTsFileAnalyzer = new LoadTsFileAnalyzer(node, node.isGeneratedByPipe(), StatementAnalyzer.this.queryContext);){
                loadTsFileAnalyzer.analyzeFileByFile(StatementAnalyzer.this.analysis);
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Failed to execute load tsfile statement %s. Detail: %s", node, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                StatementAnalyzer.this.analysis.setFinishQueryAfterAnalyze(true);
                StatementAnalyzer.this.analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
            }
            return this.createAndAssignScope(node, scope);
        }

        @Override
        protected Scope visitExplain(Explain node, Optional<Scope> context) {
            StatementAnalyzer.this.analysis.setFinishQueryAfterAnalyze();
            return this.visitQuery((Query)node.getStatement(), context);
        }

        @Override
        protected Scope visitExplainAnalyze(ExplainAnalyze node, Optional<Scope> context) {
            StatementAnalyzer.this.queryContext.setExplainAnalyze(true);
            return this.visitQuery((Query)node.getStatement(), context);
        }

        @Override
        protected Scope visitQuery(Query node, Optional<Scope> context) {
            boolean requiresOrderBy;
            StatementAnalyzer.this.analysis.setQuery(true);
            Scope withScope = this.analyzeWith(node, context);
            StatementAnalyzer.this.hasFillInParentScope = node.getFill().isPresent() || StatementAnalyzer.this.hasFillInParentScope;
            Scope queryBodyScope = this.process((Node)node.getQueryBody(), withScope);
            if (node.getFill().isPresent()) {
                this.analyzeFill(node.getFill().get(), queryBodyScope);
            }
            List<Expression> orderByExpressions = Collections.emptyList();
            if (node.getOrderBy().isPresent()) {
                orderByExpressions = this.analyzeOrderBy(node, NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()), queryBodyScope);
                if (!(!queryBodyScope.getOuterQueryParent().isPresent() && this.isTopLevel || node.getLimit().isPresent() || node.getOffset().isPresent() || StatementAnalyzer.this.hasFillInParentScope)) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(node.getOrderBy().get());
                    this.warningCollector.add(new IoTDBWarning(StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions(node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset(node.getOffset().get(), queryBodyScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit(node.getLimit().get(), queryBodyScope)) && !node.getOrderBy().isPresent()) {
                throw new SemanticException("FETCH FIRST WITH TIES clause requires ORDER BY");
            }
            StatementAnalyzer.this.analysis.setSelectExpressions(node, (List)this.descriptorToFields(queryBodyScope).stream().map(expression -> new Analysis.SelectExpression((Expression)expression, Optional.empty())).collect(ImmutableList.toImmutableList()));
            Scope queryScope = Scope.builder().withParent(withScope).withRelationType(RelationId.of(node), queryBodyScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope(node, queryScope);
            return queryScope;
        }

        private List<Expression> descriptorToFields(Scope scope) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
                FieldReference expression = new FieldReference(fieldIndex);
                builder.add((Object)expression);
                this.analyzeExpression(expression, scope);
            }
            return builder.build();
        }

        private Scope analyzeWith(Query node, Optional<Scope> scope) {
            if (!node.getWith().isPresent()) {
                return this.createScope(scope);
            }
            With with = node.getWith().get();
            Scope.Builder withScopeBuilder = this.scopeBuilder(scope);
            for (WithQuery withQuery : with.getQueries()) {
                List<Node> recursiveReferences;
                String name = withQuery.getName().getValue().toLowerCase(Locale.ENGLISH);
                if (withScopeBuilder.containsNamedQuery(name)) {
                    throw new SemanticException(String.format("WITH query name '%s' specified more than once", name));
                }
                boolean isRecursive = false;
                if (with.isRecursive() && !(isRecursive = this.tryProcessRecursiveQuery(withQuery, name, withScopeBuilder)) && !(recursiveReferences = this.findReferences(withQuery.getQuery(), withQuery.getName())).isEmpty()) {
                    throw new SemanticException("recursive reference not allowed in this context");
                }
                if (isRecursive) continue;
                Query query = withQuery.getQuery();
                StatementAnalyzer.this.analyze(query, withScopeBuilder.build());
                if (withQuery.getColumnNames().isPresent()) {
                    this.validateColumnAliases(withQuery.getColumnNames().get(), StatementAnalyzer.this.analysis.getOutputDescriptor(query).getVisibleFieldCount());
                }
                withScopeBuilder.withNamedQuery(name, withQuery);
            }
            Scope withScope = withScopeBuilder.build();
            StatementAnalyzer.this.analysis.setScope(with, withScope);
            return withScope;
        }

        private boolean tryProcessRecursiveQuery(WithQuery withQuery, String name, Scope.Builder withScopeBuilder) {
            if (!withQuery.getColumnNames().isPresent()) {
                throw new SemanticException("missing column aliases in recursive WITH query");
            }
            AstUtil.preOrder(withQuery.getQuery()).filter(child -> child instanceof With && ((With)child).isRecursive()).findFirst().ifPresent(child -> {
                throw new SemanticException("nested recursive WITH query");
            });
            if (!(withQuery.getQuery().getQueryBody() instanceof Union)) {
                return false;
            }
            Union union = (Union)withQuery.getQuery().getQueryBody();
            if (union.getRelations().size() != 2) {
                return false;
            }
            Relation anchor = union.getRelations().get(0);
            Relation step = union.getRelations().get(1);
            List<Node> anchorReferences = this.findReferences(anchor, withQuery.getName());
            if (!anchorReferences.isEmpty()) {
                throw new SemanticException("WITH table name is referenced in the base relation of recursion");
            }
            List<Node> stepReferences = this.findReferences(step, withQuery.getName());
            if (stepReferences.size() > 1) {
                throw new SemanticException("multiple recursive references in the step relation of recursion");
            }
            if (stepReferences.size() != 1) {
                return false;
            }
            Relation specification = step;
            while (specification instanceof TableSubquery) {
                Query query = ((TableSubquery)specification).getQuery();
                query.getLimit().ifPresent(limit -> {
                    throw new SemanticException("FETCH FIRST / LIMIT clause in the step relation of recursion");
                });
                specification = query.getQueryBody();
            }
            if (!(specification instanceof QuerySpecification) || !((QuerySpecification)specification).getFrom().isPresent()) {
                throw new SemanticException("recursive reference outside of FROM clause of the step relation of recursion");
            }
            Relation from = ((QuerySpecification)specification).getFrom().get();
            List<Node> fromReferences = this.findReferences(from, withQuery.getName());
            if (fromReferences.isEmpty()) {
                throw new SemanticException("recursive reference outside of FROM clause of the step relation of recursion");
            }
            withQuery.getQuery().getWith().ifPresent(innerWith -> {
                throw new SemanticException("immediate WITH clause in recursive query is not supported");
            });
            withQuery.getQuery().getFill().ifPresent(orderBy -> {
                throw new SemanticException("immediate FILL clause in recursive query is not supported");
            });
            withQuery.getQuery().getOrderBy().ifPresent(orderBy -> {
                throw new SemanticException("immediate ORDER BY clause in recursive query is not supported");
            });
            withQuery.getQuery().getOffset().ifPresent(offset -> {
                throw new SemanticException("immediate OFFSET clause in recursive query is not supported");
            });
            withQuery.getQuery().getLimit().ifPresent(limit -> {
                throw new SemanticException("immediate FETCH FIRST / LIMIT clause in recursive query is not support");
            });
            this.validateFromClauseOfRecursiveTerm(from, withQuery.getName());
            Scope parentScope = withScopeBuilder.build();
            Scope anchorScope = this.process((Node)anchor, parentScope);
            Scope aliasedAnchorScope = this.setAliases(anchorScope, withQuery.getName(), withQuery.getColumnNames().get());
            Node recursiveReference = fromReferences.get(0);
            StatementAnalyzer.this.analysis.setExpandableBaseScope(recursiveReference, aliasedAnchorScope);
            Scope stepScope = this.process((Node)step, parentScope);
            RelationType anchorType = aliasedAnchorScope.getRelationType().withOnlyVisibleFields();
            RelationType stepType = stepScope.getRelationType().withOnlyVisibleFields();
            if (anchorType.getVisibleFieldCount() != stepType.getVisibleFieldCount()) {
                throw new SemanticException(String.format("base and step relations of recursion have different number of fields: %s, %s", anchorType.getVisibleFieldCount(), stepType.getVisibleFieldCount()));
            }
            List anchorFieldTypes = (List)anchorType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            List stepFieldTypes = (List)stepType.getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < anchorFieldTypes.size(); ++i) {
                if (stepFieldTypes.get(i) == anchorFieldTypes.get(i)) continue;
                throw new SemanticException(String.format("recursion step relation output type (%s) is not coercible to recursion base relation output type (%s) at column %s", stepFieldTypes.get(i), anchorFieldTypes.get(i), i + 1));
            }
            if (!anchorFieldTypes.equals(stepFieldTypes)) {
                StatementAnalyzer.this.analysis.addRelationCoercion(step, anchorFieldTypes.toArray(new org.apache.tsfile.read.common.type.Type[0]));
            }
            StatementAnalyzer.this.analysis.setScope(withQuery.getQuery(), aliasedAnchorScope);
            StatementAnalyzer.this.analysis.registerExpandableQuery(withQuery.getQuery(), recursiveReference);
            withScopeBuilder.withNamedQuery(name, withQuery);
            return true;
        }

        @Override
        protected Scope visitTableSubquery(TableSubquery node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = StatementAnalyzer.this.statementAnalyzerFactory.createStatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, this.warningCollector, CorrelationSupport.ALLOWED);
            analyzer.hasFillInParentScope = StatementAnalyzer.this.hasFillInParentScope;
            Scope queryScope = analyzer.analyze(node.getQuery(), scope.orElseThrow(() -> new NoSuchElementException("No value present")));
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        @Override
        protected Scope visitQuerySpecification(QuerySpecification node, Optional<Scope> scope) {
            boolean requiresOrderBy;
            StatementAnalyzer.this.hasFillInParentScope = node.getFill().isPresent() || StatementAnalyzer.this.hasFillInParentScope;
            Scope sourceScope = this.analyzeFrom(node, scope);
            node.getWhere().ifPresent(where -> this.analyzeWhere(node, sourceScope, (Expression)where));
            List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
            Analysis.GroupingSetAnalysis groupByAnalysis = this.analyzeGroupBy(node, sourceScope, outputExpressions);
            this.analyzeHaving(node, sourceScope);
            Scope outputScope = this.computeAndAssignOutputScope(node, scope, sourceScope);
            node.getFill().ifPresent(fill -> {
                Scope fillScope = this.computeAndAssignFillScope((Fill)fill, sourceScope, outputScope);
                this.analyzeFill((Fill)fill, fillScope);
            });
            List<Expression> orderByExpressions = Collections.emptyList();
            Optional<Object> orderByScope = Optional.empty();
            if (node.getOrderBy().isPresent()) {
                OrderBy orderBy = node.getOrderBy().get();
                orderByScope = Optional.of(this.computeAndAssignOrderByScope(orderBy, sourceScope, outputScope));
                orderByExpressions = this.analyzeOrderBy(node, orderBy.getSortItems(), (Scope)orderByScope.get());
                if (!(!sourceScope.getOuterQueryParent().isPresent() && this.isTopLevel || node.getLimit().isPresent() || node.getOffset().isPresent() || StatementAnalyzer.this.hasFillInParentScope)) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(orderBy);
                    this.warningCollector.add(new IoTDBWarning(StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions(node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset(node.getOffset().get(), outputScope);
            }
            if (node.getLimit().isPresent() && (requiresOrderBy = this.analyzeLimit(node.getLimit().get(), outputScope)) && !node.getOrderBy().isPresent()) {
                throw new SemanticException("FETCH FIRST WITH TIES clause requires ORDER BY");
            }
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>();
            StatementAnalyzer.this.analysis.getSelectExpressions(node).stream().map(Analysis.SelectExpression::getExpression).forEach(sourceExpressions::add);
            node.getHaving().ifPresent(sourceExpressions::add);
            this.analyzeAggregations(node, sourceScope, orderByScope, groupByAnalysis, sourceExpressions, orderByExpressions);
            if (StatementAnalyzer.this.analysis.isAggregation(node) && node.getOrderBy().isPresent()) {
                ImmutableList.Builder aggregates = ImmutableList.builder().addAll(groupByAnalysis.getOriginalExpressions()).addAll(ExpressionTreeUtils.extractAggregateFunctions(orderByExpressions));
                StatementAnalyzer.this.analysis.setOrderByAggregates(node.getOrderBy().get(), (List<Expression>)aggregates.build());
            }
            if (node.getOrderBy().isPresent() && node.getSelect().isDistinct()) {
                this.verifySelectDistinct(node, orderByExpressions, outputExpressions, sourceScope, (Scope)orderByScope.orElseThrow(() -> new NoSuchElementException("No value present")));
            }
            return outputScope;
        }

        private Scope analyzeFrom(QuerySpecification node, Optional<Scope> scope) {
            if (node.getFrom().isPresent()) {
                return this.process((Node)node.getFrom().get(), scope);
            }
            Scope result = this.createScope(scope);
            StatementAnalyzer.this.analysis.setImplicitFromScope(node, result);
            return result;
        }

        private void analyzeWhere(Node node, Scope scope, Expression predicate) {
            StatementAnalyzer.verifyNoAggregateWindowOrGroupingFunctions(predicate, "WHERE clause");
            if (this.containsColumns(predicate)) {
                ExpandColumnsVisitor visitor = new ExpandColumnsVisitor(null);
                List expandedExpressions = (List)visitor.process(predicate, scope);
                if (expandedExpressions.isEmpty()) {
                    throw new IllegalStateException("There is at least one result of expanded");
                }
                predicate = expandedExpressions.size() >= 2 ? new LogicalExpression(LogicalExpression.Operator.AND, expandedExpressions) : (Expression)expandedExpressions.get(0);
            }
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            org.apache.tsfile.read.common.type.Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN)) {
                throw new SemanticException(String.format("WHERE clause must evaluate to a boolean: actual type %s", predicateType));
            }
            StatementAnalyzer.this.analysis.setWhere(node, predicate);
        }

        private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
            ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
            ImmutableList.Builder selectExpressionBuilder = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    this.analyzeSelectAllColumns((AllColumns)item, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                if (item instanceof SingleColumn) {
                    SingleColumn singleColumn = (SingleColumn)item;
                    Expression selectExpression = singleColumn.getExpression();
                    if (this.containsColumns(selectExpression)) {
                        ExpandColumnsVisitor visitor = new ExpandColumnsVisitor(singleColumn.getAlias().orElse(null));
                        List expandedExpressions = (List)visitor.process(selectExpression, scope);
                        if (expandedExpressions.isEmpty()) {
                            throw new IllegalStateException("There is at least one result of expanded");
                        }
                        singleColumn.setExpandedExpressions(expandedExpressions);
                        singleColumn.setAccordingColumnName(visitor.getAccordingColumnNames());
                        for (Expression expression : expandedExpressions) {
                            this.analyzeSelectSingleColumn(expression, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                        }
                        continue;
                    }
                    this.analyzeSelectSingleColumn(selectExpression, node, scope, (ImmutableList.Builder<Expression>)outputExpressionBuilder, (ImmutableList.Builder<Analysis.SelectExpression>)selectExpressionBuilder);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            StatementAnalyzer.this.analysis.setSelectExpressions(node, (List<Analysis.SelectExpression>)selectExpressionBuilder.build());
            if (node.getSelect().isDistinct()) {
                StatementAnalyzer.this.analysis.setContainsSelectDistinct();
            }
            return outputExpressionBuilder.build();
        }

        private boolean containsColumns(Expression expression) {
            return this.containsColumnsHelper(expression) != null;
        }

        private Node containsColumnsHelper(Node node) {
            if (node instanceof Columns) {
                return node;
            }
            Node target = null;
            for (Node node2 : node.getChildren()) {
                Node childResult = this.containsColumnsHelper(node2);
                if (childResult == null) continue;
                if (target == null) {
                    target = childResult;
                    continue;
                }
                if (childResult.equals(target)) continue;
                throw new SemanticException("Multiple different COLUMNS in the same expression are not supported");
            }
            return target;
        }

        private void analyzeSelectAllColumns(AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            if (allColumns.getTarget().isPresent()) {
                Scope.AsteriskedIdentifierChainBasis identifierChainBasis;
                Expression expression = allColumns.getTarget().get();
                QualifiedName prefix = ExpressionTreeUtils.asQualifiedName(expression);
                if (prefix != null && (identifierChainBasis = scope.resolveAsteriskedIdentifierChainBasis(prefix, allColumns).orElseThrow(() -> new SemanticException(String.format("Unable to resolve reference %s", prefix)))).getBasisType() == Scope.BasisType.TABLE) {
                    RelationType relationType = identifierChainBasis.getRelationType().orElseThrow(() -> new NoSuchElementException("No value present"));
                    List<Field> requestedFields = relationType.resolveVisibleFieldsWithRelationPrefix(Optional.of(prefix));
                    List<Field> fields = this.filterInaccessibleFields(requestedFields);
                    if (fields.isEmpty()) {
                        if (!requestedFields.isEmpty()) {
                            throw new SemanticException("Relation not found or not allowed");
                        }
                        throw new SemanticException("SELECT * not allowed from relation that has no columns");
                    }
                    boolean local = scope.isLocalScope(identifierChainBasis.getScope().orElseThrow(() -> new NoSuchElementException("No value present")));
                    this.analyzeAllColumnsFromTable(fields, allColumns, node, local ? scope : identifierChainBasis.getScope().get(), outputExpressionBuilder, selectExpressionBuilder, relationType, local);
                    return;
                }
                throw new SemanticException("identifierChainBasis.get().getBasisType == FIELD or target expression isn't a QualifiedName");
            }
            if (!allColumns.getAliases().isEmpty()) {
                throw new SemanticException("Column aliases not supported");
            }
            List requestedFields = (List)scope.getRelationType().getVisibleFields();
            List<Field> fields = this.filterInaccessibleFields(requestedFields);
            if (fields.isEmpty()) {
                if (!node.getFrom().isPresent()) {
                    throw new SemanticException("SELECT * not allowed in queries without FROM clause");
                }
                if (!requestedFields.isEmpty()) {
                    throw new SemanticException("Relation not found or not allowed");
                }
                throw new SemanticException("SELECT * not allowed from relation that has no columns");
            }
            this.analyzeAllColumnsFromTable(fields, allColumns, node, scope, outputExpressionBuilder, selectExpressionBuilder, scope.getRelationType(), true);
        }

        private List<Field> filterInaccessibleFields(List<Field> fields) {
            ImmutableSet.Builder accessibleFields = ImmutableSet.builder();
            ArrayListMultimap tableFieldsMap = ArrayListMultimap.create();
            fields.forEach(arg_0 -> Visitor.lambda$filterInaccessibleFields$21((ListMultimap)tableFieldsMap, accessibleFields, arg_0));
            tableFieldsMap.asMap().forEach((table, tableFields) -> accessibleFields.addAll((Iterable)tableFields.stream().collect(ImmutableList.toImmutableList())));
            return (List)fields.stream().filter(arg_0 -> ((ImmutableSet)accessibleFields.build()).contains(arg_0)).collect(ImmutableList.toImmutableList());
        }

        private void analyzeAllColumnsFromTable(List<Field> fields, AllColumns allColumns, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder, RelationType relationType, boolean local) {
            if (!allColumns.getAliases().isEmpty()) {
                this.validateColumnAliasesCount(allColumns.getAliases(), fields.size());
            }
            ImmutableList.Builder itemOutputFieldBuilder = ImmutableList.builder();
            for (int i = 0; i < fields.size(); ++i) {
                Expression fieldExpression;
                Field field = fields.get(i);
                if (local) {
                    fieldExpression = new FieldReference(relationType.indexOf(field));
                } else {
                    if (!field.getName().isPresent()) {
                        throw new SemanticException("SELECT * from outer scope table not supported with anonymous columns");
                    }
                    Preconditions.checkState((boolean)field.getRelationAlias().isPresent(), (Object)"missing relation alias");
                    fieldExpression = new DereferenceExpression(DereferenceExpression.from(field.getRelationAlias().get()), new Identifier(field.getName().get()));
                }
                this.analyzeExpression(fieldExpression, scope);
                outputExpressionBuilder.add((Object)fieldExpression);
                selectExpressionBuilder.add((Object)new Analysis.SelectExpression(fieldExpression, Optional.empty()));
                Optional<String> alias = field.getName();
                if (!allColumns.getAliases().isEmpty()) {
                    alias = Optional.of(allColumns.getAliases().get(i).getValue());
                }
                Field newField = new Field(field.getRelationAlias(), alias, field.getType(), field.getColumnCategory(), false, field.getOriginTable(), field.getOriginColumnName(), !allColumns.getAliases().isEmpty() || field.isAliased());
                itemOutputFieldBuilder.add((Object)newField);
                StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns(field));
                org.apache.tsfile.read.common.type.Type type = field.getType();
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw new SemanticException(String.format("DISTINCT can only be applied to comparable types (actual: %s)", type));
            }
            StatementAnalyzer.this.analysis.setSelectAllResultFields(allColumns, (List<Field>)itemOutputFieldBuilder.build());
        }

        private void analyzeSelectSingleColumn(Expression expression, QuerySpecification node, Scope scope, ImmutableList.Builder<Expression> outputExpressionBuilder, ImmutableList.Builder<Analysis.SelectExpression> selectExpressionBuilder) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, scope);
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            outputExpressionBuilder.add((Object)expression);
            selectExpressionBuilder.add((Object)new Analysis.SelectExpression(expression, Optional.empty()));
            org.apache.tsfile.read.common.type.Type type = expressionAnalysis.getType(expression);
            if (node.getSelect().isDistinct() && !type.isComparable()) {
                throw new SemanticException(String.format("DISTINCT can only be applied to comparable types (actual: %s): %s", type, expression));
            }
        }

        /*
         * WARNING - void declaration
         */
        private Analysis.GroupingSetAnalysis analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
            if (node.getGroupBy().isPresent()) {
                ImmutableList.Builder cubes = ImmutableList.builder();
                ImmutableList.Builder rollups = ImmutableList.builder();
                ImmutableList.Builder sets = ImmutableList.builder();
                ImmutableList.Builder complexExpressions = ImmutableList.builder();
                ImmutableList.Builder groupingExpressions = ImmutableList.builder();
                FunctionCall gapFillColumn = null;
                ImmutableList.Builder gapFillGroupingExpressions = ImmutableList.builder();
                this.checkGroupingSetsCount(node.getGroupBy().get());
                for (GroupingElement groupingElement : node.getGroupBy().get().getGroupingElements()) {
                    if (groupingElement instanceof SimpleGroupBy) {
                        for (Expression expression : groupingElement.getExpressions()) {
                            void var14_20;
                            if (expression instanceof LongLiteral) {
                                long ordinal = ((LongLiteral)expression).getParsedValue();
                                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                                    throw new SemanticException(String.format("GROUP BY position %s is not in select list", ordinal));
                                }
                                Expression expression2 = outputExpressions.get(Math.toIntExact(ordinal - 1L));
                                StatementAnalyzer.verifyNoAggregateWindowOrGroupingFunctions(expression2, "GROUP BY clause");
                            } else {
                                StatementAnalyzer.verifyNoAggregateWindowOrGroupingFunctions(expression, "GROUP BY clause");
                                this.analyzeExpression(expression, scope);
                            }
                            ResolvedField field = StatementAnalyzer.this.analysis.getColumnReferenceFields().get(NodeRef.of(var14_20));
                            if (field != null) {
                                sets.add((Object)ImmutableList.of((Object)ImmutableSet.of((Object)field.getFieldId())));
                            } else {
                                StatementAnalyzer.this.analysis.recordSubqueries(node, this.analyzeExpression((Expression)var14_20, scope));
                                complexExpressions.add((Object)var14_20);
                            }
                            if (this.isDateBinGapFill((Expression)var14_20)) {
                                if (gapFillColumn != null) {
                                    throw new SemanticException("multiple date_bin_gapfill calls not allowed");
                                }
                                gapFillColumn = (FunctionCall)var14_20;
                            } else {
                                gapFillGroupingExpressions.add((Object)var14_20);
                            }
                            groupingExpressions.add((Object)var14_20);
                        }
                        continue;
                    }
                    if (!(groupingElement instanceof GroupingSets)) continue;
                    GroupingSets element = (GroupingSets)groupingElement;
                    for (Expression column3 : groupingElement.getExpressions()) {
                        this.analyzeExpression(column3, scope);
                        if (!StatementAnalyzer.this.analysis.getColumnReferences().contains(NodeRef.of(column3))) {
                            throw new SemanticException(String.format("GROUP BY expression must be a column reference: %s", column3));
                        }
                        groupingExpressions.add((Object)column3);
                    }
                    List list = (List)element.getSets().stream().map(set -> (ImmutableSet)set.stream().map(NodeRef::of).map(StatementAnalyzer.this.analysis.getColumnReferenceFields()::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
                    switch (element.getType()) {
                        case CUBE: {
                            cubes.add((Object)list);
                            break;
                        }
                        case ROLLUP: {
                            rollups.add((Object)list);
                            break;
                        }
                        case EXPLICIT: {
                            sets.add((Object)list);
                        }
                    }
                }
                ImmutableList expressions = groupingExpressions.build();
                for (Expression expression : expressions) {
                    org.apache.tsfile.read.common.type.Type type = StatementAnalyzer.this.analysis.getType(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(String.format("%s is not comparable, and therefore cannot be used in GROUP BY", type));
                }
                Analysis.GroupingSetAnalysis groupingSetAnalysis = new Analysis.GroupingSetAnalysis((List<Expression>)expressions, (List<List<Set<FieldId>>>)cubes.build(), (List<List<Set<FieldId>>>)rollups.build(), (List<List<Set<FieldId>>>)sets.build(), (List<Expression>)complexExpressions.build());
                StatementAnalyzer.this.analysis.setGroupingSets(node, groupingSetAnalysis);
                if (gapFillColumn != null) {
                    StatementAnalyzer.this.analysis.setGapFill(node, gapFillColumn);
                    StatementAnalyzer.this.analysis.setGapFillGroupingKeys(node, (List<Expression>)gapFillGroupingExpressions.build());
                }
                return groupingSetAnalysis;
            }
            Analysis.GroupingSetAnalysis result = new Analysis.GroupingSetAnalysis((List<Expression>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<List<Set<FieldId>>>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
            if (this.hasAggregates(node) || node.getHaving().isPresent()) {
                StatementAnalyzer.this.analysis.setGroupingSets(node, result);
            }
            return result;
        }

        private boolean isDateBinGapFill(Expression column) {
            return column instanceof FunctionCall && TableBuiltinScalarFunction.DATE_BIN.getFunctionName().equalsIgnoreCase(((FunctionCall)column).getName().getSuffix()) && ((FunctionCall)column).getArguments().size() == 5;
        }

        private boolean hasAggregates(QuerySpecification node) {
            ImmutableList toExtract = ImmutableList.builder().addAll(node.getSelect().getSelectItems()).addAll(NodeUtils.getSortItemsFromOrderBy(node.getOrderBy())).build();
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)toExtract);
            return !aggregates.isEmpty();
        }

        private void checkGroupingSetsCount(GroupBy node) {
            int crossProduct = 1;
            for (GroupingElement element : node.getGroupingElements()) {
                try {
                    int product = 0;
                    if (element instanceof SimpleGroupBy) {
                        product = 1;
                    } else if (element instanceof GroupingSets) {
                        GroupingSets groupingSets = (GroupingSets)element;
                        switch (groupingSets.getType()) {
                            case CUBE: {
                                int exponent = ((GroupingSets)element).getSets().size();
                                if (exponent > 30) {
                                    throw new ArithmeticException();
                                }
                                product = 1 << exponent;
                                break;
                            }
                            case ROLLUP: {
                                product = groupingSets.getSets().size() + 1;
                                break;
                            }
                            case EXPLICIT: {
                                product = groupingSets.getSets().size();
                            }
                        }
                    } else {
                        throw new UnsupportedOperationException("Unsupported grouping element type: " + element.getClass().getName());
                    }
                    crossProduct = Math.multiplyExact(crossProduct, product);
                }
                catch (ArithmeticException e) {
                    throw new SemanticException(String.format("GROUP BY has more than %s grouping sets", Integer.MAX_VALUE));
                }
            }
        }

        private void analyzeHaving(QuerySpecification node, Scope scope) {
            if (node.getHaving().isPresent()) {
                Expression predicate = node.getHaving().get();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                org.apache.tsfile.read.common.type.Type predicateType = expressionAnalysis.getType(predicate);
                if (!predicateType.equals(BooleanType.BOOLEAN)) {
                    throw new SemanticException(String.format("HAVING clause must evaluate to a boolean: actual type %s", predicateType));
                }
                StatementAnalyzer.this.analysis.setHaving(node, predicate);
            }
        }

        private Scope computeAndAssignOutputScope(QuerySpecification node, Optional<Scope> scope, Scope sourceScope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                Optional<Identifier> field;
                if (item instanceof AllColumns) {
                    AllColumns allColumns = (AllColumns)item;
                    List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                    Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                    for (int i = 0; i < fields.size(); ++i) {
                        field = fields.get(i);
                        Optional<String> name = !allColumns.getAliases().isEmpty() ? Optional.of(allColumns.getAliases().get(i).getCanonicalValue()) : ((Field)((Object)field)).getName();
                        Field newField = Field.newUnqualified(name, ((Field)((Object)field)).getType(), ((Field)((Object)field)).getColumnCategory(), ((Field)((Object)field)).getOriginTable(), ((Field)((Object)field)).getOriginColumnName(), false);
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getSourceColumns((Field)((Object)field)));
                        outputFields.add((Object)newField);
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    Expression expression = column.getExpression();
                    List<Expression> expandedExpressions = column.getExpandedExpressions();
                    if (expandedExpressions != null) {
                        for (int i = 0; i < expandedExpressions.size(); ++i) {
                            boolean aliased;
                            expression = expandedExpressions.get(i);
                            Optional<Object> field2 = Optional.empty();
                            Optional<QualifiedObjectName> originTable = Optional.empty();
                            Optional<String> originColumn = Optional.of(column.getAccordingColumnNames().get(i));
                            QualifiedName name = null;
                            if (expression instanceof Identifier) {
                                name = QualifiedName.of(((Identifier)expression).getValue());
                            }
                            if (name != null) {
                                Field matchingField;
                                block23: {
                                    matchingField = null;
                                    try {
                                        matchingField = StatementAnalyzer.this.analysis.getResolvedField(expression).getField();
                                    }
                                    catch (IllegalArgumentException e) {
                                        List<Field> matchingFields = sourceScope.getRelationType().resolveFields(name);
                                        if (matchingFields.isEmpty()) break block23;
                                        matchingField = matchingFields.get(0);
                                    }
                                }
                                if (matchingField != null) {
                                    originTable = matchingField.getOriginTable();
                                }
                                field2 = originColumn;
                            }
                            Field newField = Field.newUnqualified((aliased = column.getAlias().isPresent()) ? originColumn : field2, StatementAnalyzer.this.analysis.getType(expression), TsTableColumnCategory.FIELD, originTable, originColumn, aliased);
                            if (originTable.isPresent()) {
                                StatementAnalyzer.this.analysis.addSourceColumns(newField, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(originTable.get(), originColumn.orElseThrow(() -> new NoSuchElementException("No value present")))));
                            } else {
                                StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getExpressionSourceColumns(expression));
                            }
                            outputFields.add((Object)newField);
                        }
                        continue;
                    }
                    field = column.getAlias();
                    Optional<QualifiedObjectName> originTable = Optional.empty();
                    Optional<String> originColumn = Optional.empty();
                    QualifiedName name = null;
                    if (expression instanceof Identifier) {
                        name = QualifiedName.of(((Identifier)expression).getValue());
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)expression);
                    }
                    if (name != null) {
                        Field matchingField;
                        block24: {
                            matchingField = null;
                            try {
                                matchingField = StatementAnalyzer.this.analysis.getResolvedField(expression).getField();
                            }
                            catch (IllegalArgumentException e) {
                                List<Field> matchingFields = sourceScope.getRelationType().resolveFields(name);
                                if (matchingFields.isEmpty()) break block24;
                                matchingField = matchingFields.get(0);
                            }
                        }
                        if (matchingField != null) {
                            originTable = matchingField.getOriginTable();
                            originColumn = matchingField.getOriginColumnName();
                        }
                    }
                    if (!field.isPresent() && name != null) {
                        field = Optional.of((Identifier)Iterables.getLast(name.getOriginalParts()));
                    }
                    Field newField = Field.newUnqualified(field.map(Identifier::getValue), StatementAnalyzer.this.analysis.getType(expression), TsTableColumnCategory.FIELD, originTable, originColumn, column.getAlias().isPresent());
                    if (originTable.isPresent()) {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(originTable.get(), originColumn.orElseThrow(() -> new NoSuchElementException("No value present")))));
                    } else {
                        StatementAnalyzer.this.analysis.addSourceColumns(newField, StatementAnalyzer.this.analysis.getExpressionSourceColumns(expression));
                    }
                    outputFields.add((Object)newField);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private Scope computeAndAssignOrderByScope(OrderBy node, Scope sourceScope, Scope outputScope) {
            Scope orderByScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope(node, orderByScope);
            return orderByScope;
        }

        private Scope computeAndAssignFillScope(Fill node, Scope sourceScope, Scope outputScope) {
            Scope fillScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope(node, fillScope);
            return fillScope;
        }

        @Override
        protected Scope visitSubqueryExpression(SubqueryExpression node, Optional<Scope> context) {
            return this.process((Node)node.getQuery(), context);
        }

        @Override
        protected Scope visitSetOperation(SetOperation node, Optional<Scope> scope) {
            Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
            List childrenTypes = (List)node.getRelations().stream().map(relation -> this.process((Node)relation, scope).getRelationType().withOnlyVisibleFields()).collect(ImmutableList.toImmutableList());
            String setOperationName = node.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            org.apache.tsfile.read.common.type.Type[] outputFieldTypes = (org.apache.tsfile.read.common.type.Type[])((RelationType)childrenTypes.get(0)).getVisibleFields().stream().map(Field::getType).toArray(org.apache.tsfile.read.common.type.Type[]::new);
            org.apache.tsfile.read.common.type.Type[] typeArray = childrenTypes.iterator();
            while (typeArray.hasNext()) {
                int outputFieldSize = outputFieldTypes.length;
                RelationType relationType2 = (RelationType)typeArray.next();
                int descFieldSize = relationType2.getVisibleFields().size();
                if (outputFieldSize != descFieldSize) {
                    throw new SemanticException(String.format("%s query has different number of fields: %d, %d", setOperationName, outputFieldSize, descFieldSize));
                }
                for (int i = 0; i < descFieldSize; ++i) {
                    org.apache.tsfile.read.common.type.Type descFieldType = relationType2.getFieldByIndex(i).getType();
                    if (descFieldType == outputFieldTypes[i]) continue;
                    throw new SemanticException(String.format("column %d in %s query has incompatible types: %s, %s", i + 1, setOperationName, outputFieldTypes[i].getDisplayName(), descFieldType.getDisplayName()));
                }
            }
            if (node instanceof Intersect || node instanceof Except || node instanceof Union && node.isDistinct()) {
                for (org.apache.tsfile.read.common.type.Type type : outputFieldTypes) {
                    if (type.isComparable()) continue;
                    throw new SemanticException(String.format("Type %s is not comparable and therefore cannot be used in %s%s", type, setOperationName, node instanceof Union ? " DISTINCT" : ""));
                }
            }
            Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
            RelationType firstDescriptor = (RelationType)childrenTypes.get(0);
            int i = 0;
            while (i < outputFieldTypes.length) {
                Field oldField = firstDescriptor.getFieldByIndex(i);
                outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.getColumnCategory(), oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
                int index = i++;
                StatementAnalyzer.this.analysis.addSourceColumns(outputDescriptorFields[index], (Set)childrenTypes.stream().map(relationType -> relationType.getFieldByIndex(index)).flatMap(field -> StatementAnalyzer.this.analysis.getSourceColumns((Field)field).stream()).collect(ImmutableSet.toImmutableSet()));
            }
            block4: for (i = 0; i < node.getRelations().size(); ++i) {
                Relation relation2 = node.getRelations().get(i);
                RelationType relationType3 = (RelationType)childrenTypes.get(i);
                for (int j = 0; j < relationType3.getVisibleFields().size(); ++j) {
                    org.apache.tsfile.read.common.type.Type outputFieldType = outputFieldTypes[j];
                    org.apache.tsfile.read.common.type.Type descFieldType = relationType3.getFieldByIndex(j).getType();
                    if (outputFieldType.equals(descFieldType)) continue;
                    StatementAnalyzer.this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                    continue block4;
                }
            }
            return this.createAndAssignScope((Node)node, scope, outputDescriptorFields);
        }

        @Override
        protected Scope visitTable(Table table, Optional<Scope> scope) {
            if (!table.getName().getPrefix().isPresent()) {
                Optional<WithQuery> withQuery = this.createScope(scope).getNamedQuery(table.getName().getSuffix());
                if (withQuery.isPresent()) {
                    StatementAnalyzer.this.analysis.setRelationName(table, table.getName());
                    return this.createScopeForCommonTableExpression(table, scope, withQuery.get());
                }
                Optional<Scope> expandableBaseScope = StatementAnalyzer.this.analysis.getExpandableBaseScope(table);
                if (expandableBaseScope.isPresent()) {
                    Scope baseScope = expandableBaseScope.get();
                    Scope resultScope = this.scopeBuilder(scope).withRelationType(baseScope.getRelationId(), baseScope.getRelationType()).build();
                    StatementAnalyzer.this.analysis.setScope(table, resultScope);
                    StatementAnalyzer.this.analysis.setRelationName(table, table.getName());
                    return resultScope;
                }
            }
            QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.sessionContext, table.getName());
            StatementAnalyzer.this.accessControl.checkCanSelectFromTable(StatementAnalyzer.this.sessionContext.getUserName(), name);
            StatementAnalyzer.this.analysis.setRelationName(table, QualifiedName.of(name.getDatabaseName(), name.getObjectName()));
            Optional<TableSchema> tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.sessionContext, name);
            if (!tableSchema.isPresent()) {
                TableMetadataImpl.throwTableNotExistsException(name.getDatabaseName(), name.getObjectName());
            }
            StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sessionContext.getIdentity(), name);
            ImmutableList.Builder fields = ImmutableList.builder();
            fields.addAll(this.analyzeTableOutputFields(table, name, tableSchema.get()));
            ImmutableList outputFields = fields.build();
            RelationType relationType = new RelationType((List<Field>)outputFields);
            StatementAnalyzer.this.analysis.registerTable(table, tableSchema, name);
            return this.createAndAssignScope((Node)table, scope, relationType);
        }

        private Scope createScopeForCommonTableExpression(Table table, Optional<Scope> scope, WithQuery withQuery) {
            ImmutableList fields;
            Query query = withQuery.getQuery();
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor(query);
            Optional<List<Identifier>> columnNames = withQuery.getColumnNames();
            if (columnNames.isPresent()) {
                Preconditions.checkState((columnNames.get().size() == queryDescriptor.getVisibleFieldCount() ? 1 : 0) != 0, (Object)"mismatched aliases");
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                Iterator<Identifier> aliases = columnNames.get().iterator();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    Field field = Field.newQualified(QualifiedName.of(table.getName().getSuffix()), Optional.of(aliases.next().getValue()), inputField.getType(), inputField.getColumnCategory(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased());
                    fieldBuilder.add((Object)field);
                    StatementAnalyzer.this.analysis.addSourceColumns(field, StatementAnalyzer.this.analysis.getSourceColumns(inputField));
                }
                fields = fieldBuilder.build();
            } else {
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                for (int i = 0; i < queryDescriptor.getAllFieldCount(); ++i) {
                    Field inputField = queryDescriptor.getFieldByIndex(i);
                    if (inputField.isHidden()) continue;
                    Field field = Field.newQualified(QualifiedName.of(table.getName().getSuffix()), inputField.getName(), inputField.getType(), inputField.getColumnCategory(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased());
                    fieldBuilder.add((Object)field);
                    StatementAnalyzer.this.analysis.addSourceColumns(field, StatementAnalyzer.this.analysis.getSourceColumns(inputField));
                }
                fields = fieldBuilder.build();
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)fields);
        }

        private List<Field> analyzeTableOutputFields(Table table, QualifiedObjectName tableName, TableSchema tableSchema) {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnSchema column : tableSchema.getColumns()) {
                Field field = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.getColumnCategory(), column.isHidden(), Optional.of(tableName), Optional.of(column.getName()), false);
                fields.add((Object)field);
                StatementAnalyzer.this.analysis.addSourceColumns(field, (Set<Analysis.SourceColumn>)ImmutableSet.of((Object)new Analysis.SourceColumn(tableName, column.getName())));
            }
            return fields.build();
        }

        @Override
        protected Scope visitValues(Values node, Optional<Scope> scope) {
            Preconditions.checkState((!node.getRows().isEmpty() ? 1 : 0) != 0);
            List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, this.createScope(scope)).getType((Expression)row)).map(type -> {
                if (type instanceof RowType) {
                    return type;
                }
                return RowType.anonymousRow((org.apache.tsfile.read.common.type.Type[])new org.apache.tsfile.read.common.type.Type[]{type});
            }).collect(ImmutableList.toImmutableList());
            int fieldCount = ((org.apache.tsfile.read.common.type.Type)rowTypes.get(0)).getTypeParameters().size();
            org.apache.tsfile.read.common.type.Type commonSuperType = (org.apache.tsfile.read.common.type.Type)rowTypes.get(0);
            for (Object rowType : rowTypes) {
                if (rowType.getTypeParameters().size() == fieldCount) continue;
                throw new SemanticException(String.format("Values rows have mismatched sizes: %s vs %s", fieldCount, rowType.getTypeParameters().size()));
            }
            int rowIndex = 0;
            for (Expression row2 : node.getRows()) {
                org.apache.tsfile.read.common.type.Type actualType = StatementAnalyzer.this.analysis.getType(row2);
                if (row2 instanceof Row) {
                    for (int i = 0; i < actualType.getTypeParameters().size(); ++i) {
                        org.apache.tsfile.read.common.type.Type expectedItemType;
                        org.apache.tsfile.read.common.type.Type actualItemType = (org.apache.tsfile.read.common.type.Type)actualType.getTypeParameters().get(i);
                        if (actualItemType.equals(expectedItemType = (org.apache.tsfile.read.common.type.Type)commonSuperType.getTypeParameters().get(i))) continue;
                        throw new SemanticException(String.format("Type of row %d column %d is mismatched, expected: %s, actual: %s", rowIndex, i, expectedItemType, actualItemType));
                    }
                } else {
                    if (actualType instanceof RowType) {
                        throw new SemanticException(String.format("Type of row %d is mismatched, expected: %s, actual: %s", rowIndex, commonSuperType, actualType));
                    }
                    org.apache.tsfile.read.common.type.Type superType = (org.apache.tsfile.read.common.type.Type)Iterables.getOnlyElement((Iterable)commonSuperType.getTypeParameters());
                    if (!actualType.equals(superType)) {
                        throw new SemanticException(String.format("Type of row %d is mismatched, expected: %s, actual: %s", rowIndex, superType, actualType));
                    }
                }
                ++rowIndex;
            }
            List fields = (List)commonSuperType.getTypeParameters().stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType, TsTableColumnCategory.FIELD)).collect(ImmutableList.toImmutableList());
            return this.createAndAssignScope((Node)node, scope, fields);
        }

        @Override
        protected Scope visitAliasedRelation(AliasedRelation relation, Optional<Scope> scope) {
            int totalColumns;
            StatementAnalyzer.this.analysis.setRelationName(relation, QualifiedName.of((Iterable<Identifier>)ImmutableList.of((Object)relation.getAlias())));
            StatementAnalyzer.this.analysis.addAliased(relation.getRelation());
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            RelationType relationType = relationScope.getRelationType();
            if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
                throw new SemanticException(String.format("Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns));
            }
            List aliases = null;
            Collection<Field> inputFields = relationType.getAllFields();
            if (relation.getColumnNames() != null) {
                aliases = relation.getColumnNames().stream().map(Identifier::getValue).collect(Collectors.toList());
                inputFields = relationType.getVisibleFields();
            }
            RelationType descriptor = relationType.withAlias(relation.getAlias().getValue(), aliases);
            Preconditions.checkArgument((inputFields.size() == descriptor.getAllFieldCount() ? 1 : 0) != 0, (String)"Expected %s fields, got %s", (int)descriptor.getAllFieldCount(), (int)inputFields.size());
            Streams.forEachPair(descriptor.getAllFields().stream(), inputFields.stream(), (newField, field) -> StatementAnalyzer.this.analysis.addSourceColumns((Field)newField, StatementAnalyzer.this.analysis.getSourceColumns((Field)field)));
            return this.createAndAssignScope((Node)relation, scope, descriptor);
        }

        @Override
        protected Scope visitJoin(Join node, Optional<Scope> scope) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            JoinCriteria criteria = node.getCriteria().orElse(null);
            this.joinConditionCheck(criteria);
            Scope left = this.process((Node)node.getLeft(), scope);
            Scope right = this.process((Node)node.getRight(), scope);
            if (criteria instanceof JoinUsing) {
                return this.analyzeJoinUsing(node, ((JoinUsing)criteria).getColumns(), scope, left, right);
            }
            Scope output = this.createAndAssignScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
            if (node.getType() == Join.Type.LEFT || node.getType() == Join.Type.RIGHT) {
                throw new SemanticException(String.format("%s JOIN is not supported, only support INNER JOIN in current version.", new Object[]{node.getType()}));
            }
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                return output;
            }
            if (criteria instanceof JoinOn) {
                expression = ((JoinOn)criteria).getExpression();
                StatementAnalyzer.verifyNoAggregateWindowOrGroupingFunctions(expression, "JOIN clause");
                expressionAnalysis = this.analyzeExpression(expression, output, node.getType() == Join.Type.INNER ? CorrelationSupport.ALLOWED : CorrelationSupport.DISALLOWED);
                org.apache.tsfile.read.common.type.Type clauseType = expressionAnalysis.getType(expression);
                if (!clauseType.equals(BooleanType.BOOLEAN)) {
                    throw new SemanticException(String.format("JOIN ON clause must evaluate to a boolean: actual type %s", clauseType));
                }
            } else {
                throw new UnsupportedOperationException("Unsupported join criteria: " + criteria.getClass().getName());
            }
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            StatementAnalyzer.this.analysis.setJoinCriteria(node, expression);
            return output;
        }

        private void joinConditionCheck(JoinCriteria criteria) {
            if (criteria instanceof NaturalJoin) {
                throw new SemanticException("Natural join not supported");
            }
        }

        private Scope analyzeJoinUsing(Join node, List<Identifier> columns, Optional<Scope> scope, Scope left, Scope right) {
            ArrayList<Field> joinFields = new ArrayList<Field>();
            ArrayList<Integer> leftJoinFields = new ArrayList<Integer>();
            ArrayList<Integer> rightJoinFields = new ArrayList<Integer>();
            HashSet<Identifier> seen = new HashSet<Identifier>();
            for (Identifier column : columns) {
                if (!seen.add(column)) {
                    throw new SemanticException(String.format("Column '%s' appears multiple times in USING clause", column.getValue()));
                }
                ResolvedField leftField = left.tryResolveField(column).orElseThrow(() -> new SemanticException(String.format("Column '%s' is missing from left side of join", column.getValue())));
                ResolvedField rightField = right.tryResolveField(column).orElseThrow(() -> new SemanticException(String.format("Column '%s' is missing from right side of join", column.getValue())));
                if (leftField.getType() != rightField.getType()) {
                    throw new SemanticException(String.format("Column Types of left and right side are different: left is %s, right is %s", leftField.getType(), rightField.getType()));
                }
                StatementAnalyzer.this.analysis.addTypes((Map<NodeRef<Expression>, org.apache.tsfile.read.common.type.Type>)ImmutableMap.of(NodeRef.of(column), (Object)leftField.getType()));
                joinFields.add(Field.newUnqualified(column.getValue(), leftField.getType(), leftField.getColumnCategory()));
                leftJoinFields.add(leftField.getRelationFieldIndex());
                rightJoinFields.add(rightField.getRelationFieldIndex());
                this.recordColumnAccess(leftField.getField());
                this.recordColumnAccess(rightField.getField());
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.addAll(joinFields);
            ImmutableList.Builder leftFields = ImmutableList.builder();
            for (int i = 0; i < left.getRelationType().getAllFieldCount(); ++i) {
                if (leftJoinFields.contains(i)) continue;
                outputs.add((Object)left.getRelationType().getFieldByIndex(i));
                leftFields.add((Object)i);
            }
            ImmutableList.Builder rightFields = ImmutableList.builder();
            for (int i = 0; i < right.getRelationType().getAllFieldCount(); ++i) {
                if (rightJoinFields.contains(i)) continue;
                outputs.add((Object)right.getRelationType().getFieldByIndex(i));
                rightFields.add((Object)i);
            }
            StatementAnalyzer.this.analysis.setJoinUsing(node, new Analysis.JoinUsingAnalysis(leftJoinFields, rightJoinFields, (List<Integer>)leftFields.build(), (List<Integer>)rightFields.build()));
            return this.createAndAssignScope((Node)node, scope, new RelationType((List<Field>)outputs.build()));
        }

        private void recordColumnAccess(Field field) {
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sessionContext.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.of((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get()));
            }
        }

        private void analyzeFill(Fill node, Scope scope) {
            Analysis.FillAnalysis fillAnalysis;
            if (node.getFillMethod() == FillPolicy.PREVIOUS) {
                FieldReference timeColumn = null;
                List<FieldReference> groupingKeys = null;
                if (node.getTimeBound().isPresent() || node.getFillGroupingElements().isPresent()) {
                    timeColumn = this.getHelperColumn(node, scope, FillPolicy.PREVIOUS);
                    ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, timeColumn, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                    groupingKeys = this.analyzeFillGroup(node, scope, FillPolicy.PREVIOUS);
                }
                fillAnalysis = new Analysis.PreviousFillAnalysis(node.getTimeBound().orElse(null), timeColumn, groupingKeys);
            } else if (node.getFillMethod() == FillPolicy.CONSTANT) {
                Literal literal = node.getFillValue().get();
                ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, literal, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                fillAnalysis = new Analysis.ValueFillAnalysis(literal);
            } else if (node.getFillMethod() == FillPolicy.LINEAR) {
                FieldReference helperColumn = this.getHelperColumn(node, scope, FillPolicy.LINEAR);
                ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, helperColumn, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                List<FieldReference> groupingKeys = this.analyzeFillGroup(node, scope, FillPolicy.LINEAR);
                fillAnalysis = new Analysis.LinearFillAnalysis(helperColumn, groupingKeys);
            } else {
                throw new IllegalArgumentException("Unknown fill method: " + (Object)((Object)node.getFillMethod()));
            }
            StatementAnalyzer.this.analysis.setFill(node, fillAnalysis);
        }

        private FieldReference getHelperColumn(Fill node, Scope scope, FillPolicy fillMethod) {
            FieldReference helperColumn;
            if (node.getTimeColumnIndex().isPresent()) {
                helperColumn = this.getFieldReferenceForTimeColumn(node.getTimeColumnIndex().get(), scope, fillMethod);
            } else {
                int index = -1;
                for (Field field : scope.getRelationType().getVisibleFields()) {
                    if (!TableMetadataImpl.isTimestampType(field.getType())) continue;
                    index = scope.getRelationType().indexOf(field);
                    break;
                }
                if (index == -1) {
                    throw new SemanticException(String.format("Cannot infer TIME_COLUMN for %s FILL, there exists no column whose type is TIMESTAMP", fillMethod.name()));
                }
                helperColumn = new FieldReference(index);
            }
            return helperColumn;
        }

        private List<FieldReference> analyzeFillGroup(Fill node, Scope scope, FillPolicy fillMethod) {
            if (node.getFillGroupingElements().isPresent()) {
                ImmutableList.Builder groupingFieldsBuilder = ImmutableList.builder();
                for (LongLiteral index : node.getFillGroupingElements().get()) {
                    FieldReference element = this.getFieldReferenceForFillGroup(index, scope, fillMethod);
                    groupingFieldsBuilder.add((Object)element);
                    ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, element, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                }
                return groupingFieldsBuilder.build();
            }
            return null;
        }

        private FieldReference getFieldReferenceForTimeColumn(LongLiteral index, Scope scope, FillPolicy fillMethod) {
            long ordinal = index.getParsedValue();
            if (ordinal < 1L || ordinal > (long)scope.getRelationType().getVisibleFieldCount()) {
                throw new SemanticException(String.format("%s FILL TIME_COLUMN position %s is not in select list", fillMethod.name(), ordinal));
            }
            if (!TableMetadataImpl.isTimestampType(scope.getRelationType().getFieldByIndex((int)ordinal - 1).getType())) {
                throw new SemanticException(String.format("Type of TIME_COLUMN for %s FILL should only be TIMESTAMP, but type of the column you specify is %s", fillMethod.name(), scope.getRelationType().getFieldByIndex((int)ordinal - 1).getType()));
            }
            return new FieldReference(Math.toIntExact(ordinal - 1L));
        }

        private FieldReference getFieldReferenceForFillGroup(LongLiteral index, Scope scope, FillPolicy fillMethod) {
            long ordinal = index.getParsedValue();
            if (ordinal < 1L || ordinal > (long)scope.getRelationType().getVisibleFieldCount()) {
                throw new SemanticException(String.format("%s FILL FILL_GROUP position %s is not in select list", fillMethod.name(), ordinal));
            }
            if (!scope.getRelationType().getFieldByIndex((int)ordinal - 1).getType().isOrderable()) {
                throw new SemanticException(String.format("Type %s is not orderable, and therefore cannot be used in FILL_GROUP: %s", scope.getRelationType().getFieldByIndex((int)ordinal - 1).getType(), index));
            }
            return new FieldReference(Math.toIntExact(ordinal - 1L));
        }

        private List<Expression> analyzeOrderBy(Node node, List<SortItem> sortItems, Scope orderByScope) {
            ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
            for (SortItem item : sortItems) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getParsedValue();
                    if (ordinal < 1L || ordinal > (long)orderByScope.getRelationType().getVisibleFieldCount()) {
                        throw new SemanticException(String.format("ORDER BY position %s is not in select list", ordinal));
                    }
                    expression = new FieldReference(Math.toIntExact(ordinal - 1L));
                }
                ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, orderByScope, StatementAnalyzer.this.analysis, expression, WarningCollector.NOOP, StatementAnalyzer.this.correlationSupport);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                org.apache.tsfile.read.common.type.Type type = StatementAnalyzer.this.analysis.getType(expression);
                if (!type.isOrderable()) {
                    throw new SemanticException(String.format("Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression));
                }
                orderByFieldsBuilder.add((Object)expression);
            }
            return orderByFieldsBuilder.build();
        }

        private void analyzeOffset(Offset node, Scope scope) {
            if (!(node.getRowCount() instanceof LongLiteral)) {
                throw new SemanticException("unexpected OFFSET rowCount: " + node.getRowCount().getClass().getSimpleName());
            }
            long rowCount = ((LongLiteral)node.getRowCount()).getParsedValue();
            if (rowCount < 0L) {
                throw new SemanticException(String.format("OFFSET row count must be greater or equal to 0 (actual value: %s)", rowCount));
            }
            StatementAnalyzer.this.analysis.setOffset(node, rowCount);
        }

        private boolean analyzeLimit(Node node, Scope scope) {
            Preconditions.checkState((boolean)(node instanceof Limit), (String)"Invalid limit node type. Expected: Limit. Actual: %s", (Object)node.getClass().getName());
            return this.analyzeLimit((Limit)node, scope);
        }

        private boolean analyzeLimit(Limit node, Scope scope) {
            OptionalLong rowCount;
            if (node.getRowCount() instanceof AllRows) {
                rowCount = OptionalLong.empty();
            } else if (node.getRowCount() instanceof LongLiteral) {
                rowCount = OptionalLong.of(((LongLiteral)node.getRowCount()).getParsedValue());
            } else {
                throw new SemanticException("unexpected LIMIT rowCount: " + node.getRowCount().getClass().getSimpleName());
            }
            rowCount.ifPresent(count -> {
                if (count < 0L) {
                    throw new SemanticException(String.format("LIMIT row count must be greater or equal to 0 (actual value: %s)", count));
                }
            });
            StatementAnalyzer.this.analysis.setLimit((Node)node, rowCount);
            return false;
        }

        private void analyzeAggregations(QuerySpecification node, Scope sourceScope, Optional<Scope> orderByScope, Analysis.GroupingSetAnalysis groupByAnalysis, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            Preconditions.checkState((orderByExpressions.isEmpty() || orderByScope.isPresent() ? 1 : 0) != 0, (Object)"non-empty orderByExpressions list without orderByScope provided");
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(Iterables.concat(outputExpressions, orderByExpressions));
            StatementAnalyzer.this.analysis.setAggregates(node, aggregates);
            if (StatementAnalyzer.this.analysis.isAggregation(node)) {
                ImmutableList distinctGroupingColumns = ImmutableSet.copyOf(groupByAnalysis.getOriginalExpressions()).asList();
                AggregationAnalyzer.verifySourceAggregations((List<Expression>)distinctGroupingColumns, sourceScope, outputExpressions, StatementAnalyzer.this.analysis);
                if (!orderByExpressions.isEmpty()) {
                    AggregationAnalyzer.verifyOrderByAggregations((List<Expression>)distinctGroupingColumns, sourceScope, orderByScope.orElseThrow(() -> new NoSuchElementException("No value present")), orderByExpressions, StatementAnalyzer.this.analysis);
                }
            }
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, StatementAnalyzer.this.correlationSupport);
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.metadata, StatementAnalyzer.this.queryContext, StatementAnalyzer.this.sessionContext, StatementAnalyzer.this.statementAnalyzerFactory, StatementAnalyzer.this.accessControl, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector, correlationSupport);
        }

        private List<Node> findReferences(Node node, Identifier name) {
            Stream<Node> allReferences = AstUtil.preOrder(node).filter(this.isTableWithName(name));
            Set shadowedReferences = (Set)AstUtil.preOrder(node).filter(this.isQueryWithNameShadowed(name)).flatMap(query -> AstUtil.preOrder(query).filter(this.isTableWithName(name))).collect(ImmutableSet.toImmutableSet());
            return (List)allReferences.filter(reference -> !shadowedReferences.contains(reference)).collect(ImmutableList.toImmutableList());
        }

        private Predicate<Node> isTableWithName(Identifier name) {
            return node -> {
                if (!(node instanceof Table)) {
                    return false;
                }
                Table table = (Table)node;
                QualifiedName tableName = table.getName();
                return !tableName.getPrefix().isPresent() && tableName.hasSuffix(QualifiedName.of(name.getValue()));
            };
        }

        private Predicate<Node> isQueryWithNameShadowed(Identifier name) {
            return node -> {
                if (!(node instanceof Query)) {
                    return false;
                }
                Query query = (Query)node;
                if (!query.getWith().isPresent()) {
                    return false;
                }
                return query.getWith().get().getQueries().stream().map(WithQuery::getName).map(Identifier::getValue).anyMatch(withQueryName -> withQueryName.equalsIgnoreCase(name.getValue()));
            };
        }

        private void validateFromClauseOfRecursiveTerm(Relation from, Identifier name) {
            AstUtil.preOrder(from).filter(Join.class::isInstance).forEach(node -> {
                Join join = (Join)node;
                Join.Type type = join.getType();
                if (type == Join.Type.LEFT || type == Join.Type.RIGHT || type == Join.Type.FULL) {
                    List<Node> leftRecursiveReferences = this.findReferences(join.getLeft(), name);
                    List<Node> rightRecursiveReferences = this.findReferences(join.getRight(), name);
                    if (!(leftRecursiveReferences.isEmpty() || type != Join.Type.RIGHT && type != Join.Type.FULL)) {
                        throw new SemanticException(String.format("recursive reference in left source of %s join", new Object[]{type}));
                    }
                    if (!(rightRecursiveReferences.isEmpty() || type != Join.Type.LEFT && type != Join.Type.FULL)) {
                        throw new SemanticException(String.format("recursive reference in right source of %s join", new Object[]{type}));
                    }
                }
            });
            AstUtil.preOrder(from).filter(node -> node instanceof Intersect && !((Intersect)node).isDistinct()).forEach(node -> {
                Intersect intersect = (Intersect)node;
                intersect.getRelations().stream().flatMap(relation -> this.findReferences((Node)relation, name).stream()).findFirst().ifPresent(reference -> {
                    throw new SemanticException("recursive reference in INTERSECT ALL");
                });
            });
            AstUtil.preOrder(from).filter(Except.class::isInstance).forEach(node -> {
                List<Node> leftRecursiveReferences;
                Except except = (Except)node;
                List<Node> rightRecursiveReferences = this.findReferences(except.getRight(), name);
                if (!rightRecursiveReferences.isEmpty()) {
                    throw new SemanticException(String.format("recursive reference in right relation of EXCEPT %s", except.isDistinct() ? "DISTINCT" : "ALL"));
                }
                if (!except.isDistinct() && !(leftRecursiveReferences = this.findReferences(except.getLeft(), name)).isEmpty()) {
                    throw new SemanticException("recursive reference in left relation of EXCEPT ALL");
                }
            });
        }

        private Scope setAliases(Scope scope, Identifier tableName, List<Identifier> columnNames) {
            RelationType oldDescriptor = scope.getRelationType();
            this.validateColumnAliases(columnNames, oldDescriptor.getVisibleFieldCount());
            RelationType newDescriptor = oldDescriptor.withAlias(tableName.getValue(), (List)columnNames.stream().map(Identifier::getValue).collect(ImmutableList.toImmutableList()));
            Streams.forEachPair(oldDescriptor.getAllFields().stream(), newDescriptor.getAllFields().stream(), (newField, field) -> StatementAnalyzer.this.analysis.addSourceColumns((Field)newField, StatementAnalyzer.this.analysis.getSourceColumns((Field)field)));
            return scope.withRelationType(newDescriptor);
        }

        private void verifySelectDistinct(QuerySpecification node, List<Expression> orderByExpressions, List<Expression> outputExpressions, Scope sourceScope, Scope orderByScope) {
            Set<CanonicalizationAware<Identifier>> aliases = this.getAliases(node.getSelect());
            Set expressions = outputExpressions.stream().map(e -> ScopeAware.scopeAwareKey(e, StatementAnalyzer.this.analysis, sourceScope)).collect(Collectors.toSet());
            for (Expression expression : orderByExpressions) {
                if (expression instanceof FieldReference || expression instanceof Identifier && aliases.contains(CanonicalizationAware.canonicalizationAwareKey(expression)) || expressions.contains(ScopeAware.scopeAwareKey(expression, StatementAnalyzer.this.analysis, orderByScope))) continue;
                throw new SemanticException("For SELECT DISTINCT, ORDER BY expressions must appear in select list");
            }
        }

        private Set<CanonicalizationAware<Identifier>> getAliases(Select node) {
            ImmutableSet.Builder aliases = ImmutableSet.builder();
            for (SelectItem item : node.getSelectItems()) {
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    Optional<Identifier> alias = column.getAlias();
                    if (alias.isPresent()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey(alias.get()));
                        continue;
                    }
                    if (column.getExpression() instanceof Identifier) {
                        Identifier identifier = (Identifier)column.getExpression();
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey(identifier));
                        continue;
                    }
                    if (!(column.getExpression() instanceof DereferenceExpression)) continue;
                    DereferenceExpression dereferenceExpression = (DereferenceExpression)column.getExpression();
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey(dereferenceExpression.getField().orElseThrow(() -> new NoSuchElementException("No value present"))));
                    continue;
                }
                if (!(item instanceof AllColumns)) continue;
                AllColumns allColumns = (AllColumns)item;
                List<Field> fields = StatementAnalyzer.this.analysis.getSelectAllResultFields(allColumns);
                Preconditions.checkNotNull(fields, (String)"output fields is null for select item %s", (Object)item);
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = fields.get(i);
                    if (!allColumns.getAliases().isEmpty()) {
                        aliases.add(CanonicalizationAware.canonicalizationAwareKey(allColumns.getAliases().get(i)));
                        continue;
                    }
                    if (!field.getName().isPresent()) continue;
                    aliases.add(CanonicalizationAware.canonicalizationAwareKey(new Identifier(field.getName().get())));
                }
            }
            return aliases.build();
        }

        private void validateProperties(List<Property> properties, Optional<Scope> scope) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Property property : properties) {
                Expression value;
                String key = property.getName().getValue().toLowerCase(Locale.ENGLISH);
                if (!TsTable.TABLE_ALLOWED_PROPERTIES.contains(key)) {
                    throw new SemanticException("Table property " + key + " is currently not allowed.");
                }
                if (!propertyNames.add(key)) {
                    throw new SemanticException(String.format("Duplicate property: %s", property.getName().getValue()));
                }
                if (property.isSetToDefault() || (value = property.getNonDefaultValue()) instanceof LongLiteral) continue;
                throw new SemanticException("TTL' value must be a LongLiteral, but now is: " + value.toString());
            }
            for (Property property : properties) {
                this.process((Node)property, scope);
            }
        }

        private void validateColumns(Statement node, RelationType descriptor) {
            HashSet<String> names = new HashSet<String>();
            for (Field field : descriptor.getVisibleFields()) {
                String fieldName = field.getName().orElseThrow(() -> new SemanticException(String.format("Column name not specified at position %s", descriptor.indexOf(field) + 1)));
                if (names.add(fieldName)) continue;
                throw new SemanticException(String.format("Column name '%s' specified more than once", fieldName));
            }
        }

        private void validateColumnAliases(List<Identifier> columnAliases, int sourceColumnSize) {
            this.validateColumnAliasesCount(columnAliases, sourceColumnSize);
            HashSet<String> names = new HashSet<String>();
            for (Identifier identifier : columnAliases) {
                if (names.contains(identifier.getValue().toLowerCase(Locale.ENGLISH))) {
                    throw new SemanticException(String.format("Column name '%s' specified more than once", identifier.getValue()));
                }
                names.add(identifier.getValue().toLowerCase(Locale.ENGLISH));
            }
        }

        private void validateColumnAliasesCount(List<Identifier> columnAliases, int sourceColumnSize) {
            if (columnAliases.size() != sourceColumnSize) {
                throw new SemanticException(String.format("Column alias list has %s entries but relation has %s columns", columnAliases.size(), sourceColumnSize));
            }
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope) {
            return this.createAndAssignScope(node, parentScope, Collections.emptyList());
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, Field ... fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, List<Field> fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, RelationType relationType) {
            Scope scope = this.scopeBuilder(parentScope).withRelationType(RelationId.of(node), relationType).build();
            StatementAnalyzer.this.analysis.setScope(node, scope);
            return scope;
        }

        private Scope createScope(Optional<Scope> parentScope) {
            return this.scopeBuilder(parentScope).build();
        }

        private Scope.Builder scopeBuilder(Optional<Scope> parentScope) {
            Scope.Builder scopeBuilder = Scope.builder();
            if (parentScope.isPresent()) {
                scopeBuilder.withParent(parentScope.get());
            } else {
                this.outerQueryScope.ifPresent(scopeBuilder::withOuterQueryParent);
            }
            return scopeBuilder;
        }

        @Override
        protected Scope visitCreateOrUpdateDevice(CreateOrUpdateDevice node, Optional<Scope> context) {
            StatementAnalyzer.this.queryContext.setQueryType(QueryType.WRITE);
            DataNodeSchemaLockManager.getInstance().takeReadLock(StatementAnalyzer.this.queryContext, SchemaLockType.VALIDATE_VS_DELETION_TABLE);
            if (Objects.isNull(DataNodeTableCache.getInstance().getTable(node.getDatabase(), node.getTable()))) {
                TableMetadataImpl.throwTableNotExistsException(node.getDatabase(), node.getTable());
            }
            return null;
        }

        @Override
        protected Scope visitFetchDevice(FetchDevice node, Optional<Scope> context) {
            return null;
        }

        @Override
        protected Scope visitShowDevice(ShowDevice node, Optional<Scope> context) {
            this.analyzeQueryDevice(node, context);
            if (Objects.nonNull(node.getOffset())) {
                this.analyzeOffset(node.getOffset(), null);
            }
            if (Objects.nonNull(node.getLimit())) {
                this.analyzeLimit(node.getLimit(), null);
            }
            return null;
        }

        @Override
        protected Scope visitCountDevice(CountDevice node, Optional<Scope> context) {
            this.analyzeQueryDevice(node, context);
            return null;
        }

        private void analyzeQueryDevice(AbstractQueryDeviceWithCache node, Optional<Scope> context) {
            node.parseTable(StatementAnalyzer.this.sessionContext);
            StatementAnalyzer.this.accessControl.checkCanSelectFromTable(StatementAnalyzer.this.sessionContext.getUserName(), new QualifiedObjectName(node.getDatabase(), node.getTableName()));
            this.analyzeTraverseDevice(node, context, node.getWhere().isPresent());
            TsTable table = DataNodeTableCache.getInstance().getTable(node.getDatabase(), node.getTableName());
            if (!node.parseRawExpression(table, table.getColumnList().stream().filter(columnSchema -> columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)).map(TsTableColumnSchema::getColumnName).collect(Collectors.toList()), StatementAnalyzer.this.queryContext)) {
                StatementAnalyzer.this.analysis.setFinishQueryAfterAnalyze();
            }
        }

        private TranslationMap analyzeTraverseDevice(AbstractTraverseDevice node, Optional<Scope> context, boolean shallCreateTranslationMap) {
            String database = node.getDatabase();
            String tableName = node.getTableName();
            if (Objects.isNull(database)) {
                throw new SemanticException("The database must be set before show devices.");
            }
            if (!StatementAnalyzer.this.metadata.tableExists(new QualifiedObjectName(database, tableName))) {
                TableMetadataImpl.throwTableNotExistsException(database, tableName);
            }
            node.setColumnHeaderList();
            TranslationMap translationMap = null;
            if (shallCreateTranslationMap) {
                QualifiedObjectName name = new QualifiedObjectName(database, tableName);
                Optional<TableSchema> tableSchema = StatementAnalyzer.this.metadata.getTableSchema(StatementAnalyzer.this.sessionContext, name);
                if (!tableSchema.isPresent()) {
                    TableMetadataImpl.throwTableNotExistsException(database, tableName);
                }
                TableSchema originalSchema = tableSchema.get();
                ImmutableList.Builder fields = ImmutableList.builder();
                fields.addAll(this.analyzeTableOutputFields(node.getTable(), name, new TableSchema(originalSchema.getTableName(), originalSchema.getColumns())));
                ImmutableList fieldList = fields.build();
                Scope scope = this.createAndAssignScope((Node)node, context, (List<Field>)fieldList);
                translationMap = new TranslationMap(Optional.empty(), scope, StatementAnalyzer.this.analysis, fieldList.stream().map(field -> Symbol.of(field.getName().orElse(null))).collect(Collectors.toList()), new PlannerContext(StatementAnalyzer.this.metadata, null));
                if (node.getWhere().isPresent()) {
                    this.analyzeWhere(node, translationMap.getScope(), node.getWhere().get());
                    node.setWhere(translationMap.rewrite(StatementAnalyzer.this.analysis.getWhere(node)));
                }
            }
            return translationMap;
        }

        private Expression analyzeAndRewriteExpression(TranslationMap translationMap, Scope scope, Expression expression) {
            this.analyzeExpression(expression, scope);
            scope.getRelationType().getAllFields();
            return translationMap.rewrite(expression);
        }

        @Override
        protected Scope visitCreatePipe(CreatePipe node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitAlterPipe(AlterPipe node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDropPipe(DropPipe node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitStartPipe(StartPipe node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitStopPipe(StopPipe node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitShowPipes(ShowPipes node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitCreatePipePlugin(CreatePipePlugin node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDropPipePlugin(DropPipePlugin node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitShowPipePlugins(ShowPipePlugins node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitCreateTopic(CreateTopic node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitDropTopic(DropTopic node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitShowTopics(ShowTopics node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        protected Scope visitShowSubscriptions(ShowSubscriptions node, Optional<Scope> context) {
            return this.createAndAssignScope(node, context);
        }

        @Override
        public Scope visitTableFunctionInvocation(TableFunctionInvocation node, Optional<Scope> scope) {
            TableFunctionAnalysis functionAnalysis;
            TableFunction function = StatementAnalyzer.this.metadata.getTableFunction(node.getName().toString());
            Node errorLocation = node;
            if (!node.getArguments().isEmpty()) {
                errorLocation = node.getArguments().get(0);
            }
            ArgumentsAnalysis argumentsAnalysis = this.analyzeArguments(function.getArgumentsSpecifications(), node.getArguments(), scope, errorLocation);
            try {
                functionAnalysis = function.analyze(argumentsAnalysis.getPassedArguments());
            }
            catch (UDFException e) {
                throw new SemanticException(e.getMessage());
            }
            if (argumentsAnalysis.getTableArgumentAnalyses().size() > 1) {
                throw new SemanticException("At most one table argument can be passed to a table function");
            }
            Map requiredColumns = functionAnalysis.getRequiredColumns();
            Map tableArgumentsByName = (Map)argumentsAnalysis.getTableArgumentAnalyses().stream().collect(ImmutableMap.toImmutableMap(TableArgumentAnalysis::getArgumentName, Function.identity()));
            ImmutableSet tableArgumentNameSet = ImmutableSet.copyOf(tableArgumentsByName.keySet());
            requiredColumns.forEach((arg_0, arg_1) -> this.lambda$visitTableFunctionInvocation$58((Set)tableArgumentNameSet, node, tableArgumentsByName, arg_0, arg_1));
            ImmutableSet requiredInputs = ImmutableSet.copyOf(requiredColumns.keySet());
            tableArgumentNameSet.stream().filter(arg_0 -> Visitor.lambda$visitTableFunctionInvocation$59((Set)requiredInputs, arg_0)).findFirst().ifPresent(input -> {
                throw new SemanticException(String.format("Table function %s does not specify required input columns from table argument %s", node.getName(), input));
            });
            ImmutableList.Builder fields = ImmutableList.builder();
            Optional properSchema = functionAnalysis.getProperColumnSchema();
            properSchema.ifPresent(i -> i.getFields().stream().map(f -> Field.newUnqualified(f.getName(), UDFDataTypeTransformer.transformUDFDataTypeToReadType((Type)f.getType()), TsTableColumnCategory.FIELD)).forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0)));
            List tableArgumentNames = (List)function.getArgumentsSpecifications().stream().filter(TableParameterSpecification.class::isInstance).map(ParameterSpecification::getName).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder orderedTableArguments = ImmutableList.builder();
            for (String name : tableArgumentNames) {
                TableArgumentAnalysis argument = (TableArgumentAnalysis)tableArgumentsByName.get(name);
                Preconditions.checkArgument((argument != null ? 1 : 0) != 0, (String)"Missing table argument: %s", (Object)name);
                orderedTableArguments.add((Object)argument);
                Scope argumentScope = StatementAnalyzer.this.analysis.getScope(argument.getRelation());
                if (argument.isPassThroughColumns()) {
                    argumentScope.getRelationType().getAllFields().forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0));
                    continue;
                }
                if (!argument.getPartitionBy().isPresent()) continue;
                argument.getPartitionBy().get().stream().map(expression -> this.validateAndGetInputField((Expression)expression, argumentScope)).forEach(arg_0 -> ((ImmutableList.Builder)fields).add(arg_0));
            }
            StatementAnalyzer.this.analysis.setTableFunctionAnalysis(node, new TableFunctionInvocationAnalysis(node.getName().toString(), argumentsAnalysis.getPassedArguments(), (ImmutableList<TableArgumentAnalysis>)orderedTableArguments.build(), requiredColumns, properSchema.map(describedSchema -> describedSchema.getFields().size()).orElse(0), functionAnalysis.isRequireRecordSnapshot()));
            return this.createAndAssignScope((Node)node, scope, (List<Field>)fields.build());
        }

        private ArgumentsAnalysis analyzeArguments(List<ParameterSpecification> parameterSpecifications, List<TableFunctionArgument> arguments, Optional<Scope> scope, Node errorLocation) {
            if (parameterSpecifications.size() < arguments.size()) {
                throw new SemanticException(String.format("Too many arguments. Expected at most %s arguments, got %s arguments", parameterSpecifications.size(), arguments.size()));
            }
            if (parameterSpecifications.isEmpty()) {
                return new ArgumentsAnalysis((Map<String, Argument>)ImmutableMap.of(), (List<TableArgumentAnalysis>)ImmutableList.of());
            }
            boolean argumentsPassedByName = !arguments.isEmpty() && arguments.stream().allMatch(argument -> argument.getName().isPresent());
            boolean argumentsPassedByPosition = arguments.stream().noneMatch(argument -> argument.getName().isPresent());
            if (!argumentsPassedByName && !argumentsPassedByPosition) {
                throw new SemanticException("All arguments must be passed by name or all must be passed positionally");
            }
            ImmutableMap.Builder passedArguments = ImmutableMap.builder();
            ImmutableList.Builder tableArgumentAnalyses = ImmutableList.builder();
            if (argumentsPassedByName) {
                HashMap<String, ParameterSpecification> argumentSpecificationsByName = new HashMap<String, ParameterSpecification>();
                for (ParameterSpecification parameterSpecification : parameterSpecifications) {
                    if (argumentSpecificationsByName.put(parameterSpecification.getName(), parameterSpecification) == null) continue;
                    throw new IllegalStateException("Duplicate argument specification for name: " + parameterSpecification.getName());
                }
                HashSet<String> uniqueArgumentNames = new HashSet<String>();
                for (TableFunctionArgument tableFunctionArgument : arguments) {
                    String argumentName = tableFunctionArgument.getName().get().getCanonicalValue();
                    if (!uniqueArgumentNames.add(argumentName)) {
                        throw new SemanticException(String.format("Duplicate argument name: %s", argumentName));
                    }
                    ParameterSpecification parameterSpecification = (ParameterSpecification)argumentSpecificationsByName.remove(argumentName);
                    if (parameterSpecification == null) {
                        throw new SemanticException(String.format("Unexpected argument name: %s", argumentName));
                    }
                    ArgumentAnalysis argumentAnalysis = this.analyzeArgument(parameterSpecification, tableFunctionArgument, scope);
                    passedArguments.put((Object)argumentName, (Object)argumentAnalysis.getArgument());
                    argumentAnalysis.getTableArgumentAnalysis().ifPresent(arg_0 -> ((ImmutableList.Builder)tableArgumentAnalyses).add(arg_0));
                }
                for (Map.Entry entry : argumentSpecificationsByName.entrySet()) {
                    ParameterSpecification parameterSpecification = (ParameterSpecification)entry.getValue();
                    passedArguments.put((Object)parameterSpecification.getName(), (Object)this.analyzeDefault(parameterSpecification, errorLocation));
                }
            } else {
                int i;
                for (i = 0; i < arguments.size(); ++i) {
                    TableFunctionArgument argument3 = arguments.get(i);
                    ParameterSpecification parameterSpecification = parameterSpecifications.get(i);
                    ArgumentAnalysis argumentAnalysis = this.analyzeArgument(parameterSpecification, argument3, scope);
                    passedArguments.put((Object)parameterSpecification.getName(), (Object)argumentAnalysis.getArgument());
                    argumentAnalysis.getTableArgumentAnalysis().ifPresent(arg_0 -> ((ImmutableList.Builder)tableArgumentAnalyses).add(arg_0));
                }
                for (i = arguments.size(); i < parameterSpecifications.size(); ++i) {
                    ParameterSpecification parameterSpecification = parameterSpecifications.get(i);
                    passedArguments.put((Object)parameterSpecification.getName(), (Object)this.analyzeDefault(parameterSpecification, errorLocation));
                }
            }
            return new ArgumentsAnalysis((Map<String, Argument>)passedArguments.buildOrThrow(), (List<TableArgumentAnalysis>)tableArgumentAnalyses.build());
        }

        private ArgumentAnalysis analyzeArgument(ParameterSpecification parameterSpecification, TableFunctionArgument argument, Optional<Scope> scope) {
            String actualType;
            if (argument.getValue() instanceof TableFunctionTableArgument) {
                actualType = "table";
            } else if (argument.getValue() instanceof Expression) {
                actualType = "expression";
            } else {
                throw new SemanticException(String.format("Unexpected table function argument type: %s", argument.getClass().getSimpleName()));
            }
            if (parameterSpecification instanceof TableParameterSpecification) {
                if (!(argument.getValue() instanceof TableFunctionTableArgument)) {
                    throw new SemanticException(String.format("Invalid argument %s. Expected table argument, got %s", parameterSpecification.getName(), actualType));
                }
                return this.analyzeTableArgument((TableFunctionTableArgument)argument.getValue(), (TableParameterSpecification)parameterSpecification, scope);
            }
            if (parameterSpecification instanceof ScalarParameterSpecification) {
                if (!(argument.getValue() instanceof Expression)) {
                    throw new SemanticException(String.format("Invalid argument %s. Expected scalar argument, got %s", parameterSpecification.getName(), actualType));
                }
                return this.analyzeScalarArgument((Expression)argument.getValue(), (ScalarParameterSpecification)parameterSpecification);
            }
            throw new IllegalStateException("Unexpected argument specification: " + parameterSpecification.getClass().getSimpleName());
        }

        private ArgumentAnalysis analyzeTableArgument(TableFunctionTableArgument tableArgument, TableParameterSpecification argumentSpecification, Optional<Scope> scope) {
            List partitionBy = Collections.emptyList();
            List orderBy = Collections.emptyList();
            TableArgumentAnalysis.Builder analysisBuilder = TableArgumentAnalysis.builder();
            analysisBuilder.withArgumentName(argumentSpecification.getName());
            Relation relation = tableArgument.getTable();
            analysisBuilder.withRelation(relation);
            Scope argumentScope = this.process((Node)relation, scope);
            QualifiedName relationName = StatementAnalyzer.this.analysis.getRelationName(relation);
            if (relationName != null) {
                analysisBuilder.withName(relationName);
            }
            Collection<Field> fields = argumentScope.getRelationType().getVisibleFields();
            List fieldNames = (List)fields.stream().map(Field::getName).collect(ImmutableList.toImmutableList());
            List fieldTypes = (List)fields.stream().map(Field::getType).map(UDFDataTypeTransformer::transformReadTypeToUDFDataType).collect(ImmutableList.toImmutableList());
            if (tableArgument.getPartitionBy().isPresent()) {
                if (argumentSpecification.isRowSemantics()) {
                    throw new SemanticException(String.format("Invalid argument %s. Partitioning can not be specified for table argument with row semantics", argumentSpecification.getName()));
                }
                List<Expression> partitionByExpression = tableArgument.getPartitionBy().get();
                analysisBuilder.withPartitionBy(partitionByExpression);
                partitionByExpression.forEach(partitioningColumn -> {
                    this.validateAndGetInputField((Expression)partitioningColumn, argumentScope);
                    org.apache.tsfile.read.common.type.Type type = this.analyzeExpression((Expression)partitioningColumn, argumentScope).getType((Expression)partitioningColumn);
                    if (!type.isComparable()) {
                        throw new SemanticException(String.format("%s is not comparable, and therefore cannot be used in PARTITION BY", type));
                    }
                });
                partitionBy = (List)partitionByExpression.stream().map(expression -> {
                    if (expression instanceof Identifier) {
                        return ((Identifier)expression).getValue();
                    }
                    if (expression instanceof DereferenceExpression) {
                        return expression.toString();
                    }
                    throw new IllegalStateException("Unexpected partitionBy expression: " + expression);
                }).collect(ImmutableList.toImmutableList());
            }
            if (tableArgument.getOrderBy().isPresent()) {
                if (argumentSpecification.isRowSemantics()) {
                    throw new SemanticException(String.format("Invalid argument %s. Ordering can not be specified for table argument with row semantics", argumentSpecification.getName()));
                }
                OrderBy orderByExpression = tableArgument.getOrderBy().get();
                analysisBuilder.withOrderBy(orderByExpression);
                orderByExpression.getSortItems().stream().map(SortItem::getSortKey).forEach(orderingColumn -> {
                    this.validateAndGetInputField((Expression)orderingColumn, argumentScope);
                    org.apache.tsfile.read.common.type.Type type = this.analyzeExpression((Expression)orderingColumn, argumentScope).getType((Expression)orderingColumn);
                    if (!type.isOrderable()) {
                        throw new SemanticException(String.format("%s is not orderable, and therefore cannot be used in ORDER BY", type));
                    }
                });
                orderBy = (List)orderByExpression.getSortItems().stream().map(SortItem::getSortKey).map(expression -> {
                    if (expression instanceof Identifier) {
                        return ((Identifier)expression).getValue();
                    }
                    if (expression instanceof DereferenceExpression) {
                        return expression.toString();
                    }
                    throw new IllegalStateException("Unexpected orderBy expression: " + expression);
                }).collect(ImmutableList.toImmutableList());
            }
            analysisBuilder.withRowSemantics(argumentSpecification.isRowSemantics());
            analysisBuilder.withPassThroughColumns(argumentSpecification.isPassThroughColumns());
            return new ArgumentAnalysis((Argument)new TableArgument(fieldNames, fieldTypes, partitionBy, orderBy, argumentSpecification.isRowSemantics()), Optional.of(analysisBuilder.build()));
        }

        private ArgumentAnalysis analyzeScalarArgument(Expression expression, ScalarParameterSpecification argumentSpecification) {
            Object constantValue = IrExpressionInterpreter.evaluateConstantExpression(expression, new PlannerContext(StatementAnalyzer.this.metadata, StatementAnalyzer.this.typeManager), StatementAnalyzer.this.sessionContext);
            if (!argumentSpecification.getType().checkObjectType(constantValue)) {
                if ((argumentSpecification.getType().equals((Object)Type.STRING) || argumentSpecification.getType().equals((Object)Type.TEXT)) && constantValue instanceof Binary) {
                    constantValue = ((Binary)constantValue).getStringValue(TSFileConfig.STRING_CHARSET);
                } else if (argumentSpecification.getType().equals((Object)Type.INT32) && constantValue instanceof Long) {
                    constantValue = ((Long)constantValue).intValue();
                } else {
                    throw new SemanticException(String.format("Invalid scalar argument value. Expected type %s, got %s", argumentSpecification.getType(), constantValue.getClass().getSimpleName()));
                }
            }
            return new ArgumentAnalysis((Argument)new ScalarArgument(argumentSpecification.getType(), constantValue), Optional.empty());
        }

        private Argument analyzeDefault(ParameterSpecification parameterSpecification, Node errorLocation) {
            if (parameterSpecification.isRequired()) {
                throw new SemanticException(String.format("Missing required argument: %s", parameterSpecification.getName()));
            }
            Preconditions.checkArgument((!(parameterSpecification instanceof TableParameterSpecification) ? 1 : 0) != 0, (Object)"Table argument specification cannot have a default value.");
            if (parameterSpecification instanceof ScalarParameterSpecification) {
                Preconditions.checkArgument((boolean)parameterSpecification.getDefaultValue().isPresent(), (Object)String.format("Missing default value for scalar argument: %s", parameterSpecification.getName()));
                return new ScalarArgument(((ScalarParameterSpecification)parameterSpecification).getType(), parameterSpecification.getDefaultValue().get());
            }
            throw new IllegalStateException("Unexpected argument specification: " + parameterSpecification.getClass().getSimpleName());
        }

        private Field validateAndGetInputField(Expression expression, Scope inputScope) {
            QualifiedName qualifiedName;
            if (expression instanceof Identifier) {
                qualifiedName = QualifiedName.of((Iterable<Identifier>)ImmutableList.of((Object)((Identifier)expression)));
            } else if (expression instanceof DereferenceExpression) {
                qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)expression);
            } else {
                throw new SemanticException(String.format("Expected column reference. Actual: %s", expression));
            }
            Optional<ResolvedField> field = inputScope.tryResolveField(expression, qualifiedName);
            if (!field.isPresent() || !field.get().isLocal()) {
                throw new SemanticException(String.format("Column %s is not present in the input relation", expression));
            }
            return field.get().getField();
        }

        private static /* synthetic */ boolean lambda$visitTableFunctionInvocation$59(Set requiredInputs, String input) {
            return !requiredInputs.contains(input);
        }

        private /* synthetic */ void lambda$visitTableFunctionInvocation$58(Set tableArgumentNameSet, TableFunctionInvocation node, Map tableArgumentsByName, String name, List columns) {
            if (!tableArgumentNameSet.contains(name)) {
                throw new SemanticException(String.format("Table function %s specifies required columns from table argument %s which cannot be found", node.getName(), name));
            }
            if (columns.isEmpty()) {
                throw new SemanticException(String.format("Table function %s specifies empty list of required columns from table argument %s", node.getName(), name));
            }
            if (columns.stream().anyMatch(column -> column < 0)) {
                throw new SemanticException(String.format("Table function %s specifies negative index of required column from table argument %s", node.getName(), name));
            }
            Scope inputScope = StatementAnalyzer.this.analysis.getScope(((TableArgumentAnalysis)tableArgumentsByName.get(name)).getRelation());
            columns.stream().filter(column -> column >= inputScope.getRelationType().getVisibleFieldCount()).findFirst().ifPresent(column -> {
                throw new SemanticException(String.format("Index %s of required column from table argument %s is out of bounds for table with %s columns", column, name, inputScope.getRelationType().getAllFieldCount()));
            });
            columns.stream().map(inputScope.getRelationType()::getFieldByIndex).forEach(this::recordColumnAccess);
        }

        private static /* synthetic */ void lambda$filterInaccessibleFields$21(ListMultimap tableFieldsMap, ImmutableSet.Builder accessibleFields, Field field) {
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            if (originTable.isPresent()) {
                tableFieldsMap.put((Object)originTable.get(), (Object)field);
            } else {
                accessibleFields.add((Object)field);
            }
        }

        private class ExpandColumnsVisitor
        extends AstVisitor<List<Expression>, Scope> {
            private final Identifier alias;
            private List<Expression> expandedExpressions;
            private List<String> accordingColumnNames;

            private ExpandColumnsVisitor(Identifier alias) {
                this.alias = alias;
            }

            public List<String> getAccordingColumnNames() {
                return this.accordingColumnNames;
            }

            @Override
            protected List<Expression> visitNode(Node node, Scope scope) {
                throw new UnsupportedOperationException("This Visitor only supported process of Expression");
            }

            @Override
            protected List<Expression> visitExpression(Expression node, Scope scope) {
                if (node.getChildren().isEmpty()) {
                    return Collections.singletonList(node);
                }
                throw new UnsupportedOperationException("UnSupported Expression: " + node);
            }

            @Override
            public List<Expression> visitColumns(Columns node, Scope context) {
                ImmutableList result;
                if (this.expandedExpressions != null) {
                    return this.expandedExpressions;
                }
                List requestedFields = (List)context.getRelationType().getVisibleFields();
                List fields = Visitor.this.filterInaccessibleFields(requestedFields);
                if (fields.isEmpty()) {
                    if (!requestedFields.isEmpty()) {
                        throw new SemanticException("Relation not found or not allowed");
                    }
                    throw new SemanticException("COLUMNS not allowed for relation that has no columns");
                }
                ImmutableList.Builder matchedColumns = ImmutableList.builder();
                ImmutableList.Builder outputColumnNames = ImmutableList.builder();
                if (node.isColumnsAsterisk()) {
                    for (Field field : fields) {
                        String columnName = field.getName().orElse(null);
                        if (columnName == null) {
                            throw new SemanticException("Unknown ColumnName: " + field);
                        }
                        matchedColumns.add((Object)new Identifier(columnName));
                        outputColumnNames.add((Object)(this.alias == null ? columnName : this.alias.getValue()));
                    }
                } else {
                    Pattern pattern;
                    try {
                        pattern = Pattern.compile(node.getPattern());
                    }
                    catch (PatternSyntaxException e) {
                        throw new SemanticException(String.format("Invalid regex '%s'", node.getPattern()));
                    }
                    Matcher matcher = pattern.matcher("");
                    for (Field field : fields) {
                        String columnName = field.getName().orElse(null);
                        if (columnName == null) {
                            throw new SemanticException("Unknown ColumnName: " + field);
                        }
                        matcher.reset(columnName);
                        if (!matcher.matches()) continue;
                        matchedColumns.add((Object)new Identifier(columnName));
                        if (this.alias != null) {
                            try {
                                outputColumnNames.add((Object)matcher.replaceAll(this.alias.getValue()));
                                continue;
                            }
                            catch (Exception e) {
                                throw new SemanticException(e.getMessage());
                            }
                        }
                        outputColumnNames.add((Object)columnName);
                    }
                }
                if ((result = matchedColumns.build()).isEmpty()) {
                    throw new SemanticException(String.format("No matching columns found that match regex '%s'", node.getPattern()));
                }
                this.expandedExpressions = result;
                this.accordingColumnNames = outputColumnNames.build();
                return result;
            }

            @Override
            protected List<Expression> visitArithmeticBinary(ArithmeticBinaryExpression node, Scope context) {
                List leftResult = (List)this.process(node.getLeft(), context);
                List rightResult = (List)this.process(node.getRight(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int leftSize = leftResult.size();
                int rightSize = rightResult.size();
                int maxSize = Math.max(leftSize, rightSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger leftIndex = leftSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger rightIndex = rightSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new ArithmeticBinaryExpression(node.getOperator(), (Expression)leftResult.get(leftIndex.get()), (Expression)rightResult.get(rightIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitArithmeticUnary(ArithmeticUnaryExpression node, Scope context) {
                List childResult = (List)this.process(node.getValue(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new ArithmeticUnaryExpression(node.getSign(), expression));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitBetweenPredicate(BetweenPredicate node, Scope context) {
                List valueResult = (List)this.process(node.getValue(), context);
                List minResult = (List)this.process(node.getMin(), context);
                List maxResult = (List)this.process(node.getMax(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int valueResultSize = valueResult.size();
                int minResultSize = minResult.size();
                int maxResultSize = maxResult.size();
                int maxSize = Math.max(valueResultSize, Math.max(minResultSize, maxResultSize));
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger valueIndex = valueResultSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger minIndex = minResultSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger maxIndex = maxResultSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new BetweenPredicate((Expression)valueResult.get(valueIndex.get()), (Expression)minResult.get(minIndex.get()), (Expression)maxResult.get(maxIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitCast(Cast node, Scope context) {
                List childResult = (List)this.process(node.getExpression(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new Cast(expression, node.getType()));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitCoalesceExpression(CoalesceExpression node, Scope context) {
                int i;
                ImmutableList.Builder childrenResultListBuilder = new ImmutableList.Builder();
                node.getOperands().forEach(operand -> childrenResultListBuilder.add((Object)((List)this.process((Node)operand, context))));
                ImmutableList childrenResultList = childrenResultListBuilder.build();
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int maxSize = childrenResultList.stream().mapToInt(List::size).max().orElse(0);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[childrenResultList.size()];
                for (i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)childrenResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                for (i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((Expression)((List)childrenResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new CoalesceExpression((List<Expression>)operandListBuilder.build()));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitComparisonExpression(ComparisonExpression node, Scope context) {
                List leftResult = (List)this.process(node.getLeft(), context);
                List rightResult = (List)this.process(node.getRight(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int leftSize = leftResult.size();
                int rightSize = rightResult.size();
                int maxSize = Math.max(leftSize, rightSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger leftIndex = leftSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger rightIndex = rightSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new ComparisonExpression(node.getOperator(), (Expression)leftResult.get(leftIndex.get()), (Expression)rightResult.get(rightIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitDereferenceExpression(DereferenceExpression node, Scope context) {
                this.process(node.getBase(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                throw new SemanticException("Columns are not supported in DereferenceExpression");
            }

            @Override
            protected List<Expression> visitExists(ExistsPredicate node, Scope context) {
                return Collections.singletonList(node);
            }

            @Override
            protected List<Expression> visitFunctionCall(FunctionCall node, Scope context) {
                int i;
                ImmutableList.Builder childrenResultListBuilder = new ImmutableList.Builder();
                node.getArguments().forEach(operand -> childrenResultListBuilder.add((Object)((List)this.process((Node)operand, context))));
                ImmutableList childrenResultList = childrenResultListBuilder.build();
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int maxSize = childrenResultList.stream().mapToInt(List::size).max().orElse(0);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[childrenResultList.size()];
                for (i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)childrenResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                for (i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((Expression)((List)childrenResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new FunctionCall(node.getName(), (List<Expression>)operandListBuilder.build()));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitIdentifier(Identifier node, Scope context) {
                return Collections.singletonList(node);
            }

            @Override
            protected List<Expression> visitIfExpression(IfExpression node, Scope context) {
                List thirdResult;
                List firstResult = (List)this.process(node.getCondition(), context);
                List secondResult = (List)this.process(node.getTrueValue(), context);
                List list = thirdResult = node.getFalseValue().isPresent() ? (List)this.process(node.getFalseValue().get(), context) : null;
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int firstSize = firstResult.size();
                int secondSize = secondResult.size();
                int thirdSize = thirdResult == null ? 0 : thirdResult.size();
                int maxSize = Math.max(thirdSize, Math.max(firstSize, secondSize));
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger firstIndex = firstSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger secondIndex = secondSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger thirdIndex = thirdSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new IfExpression((Expression)firstResult.get(firstIndex.get()), (Expression)secondResult.get(secondIndex.get()), thirdResult == null ? null : (Expression)thirdResult.get(thirdIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitInListExpression(InListExpression node, Scope context) {
                int i;
                ImmutableList.Builder childrenResultListBuilder = new ImmutableList.Builder();
                node.getValues().forEach(operand -> childrenResultListBuilder.add((Object)((List)this.process((Node)operand, context))));
                ImmutableList childrenResultList = childrenResultListBuilder.build();
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int maxSize = childrenResultList.stream().mapToInt(List::size).max().orElse(0);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[childrenResultList.size()];
                for (i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)childrenResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                for (i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((Expression)((List)childrenResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new InListExpression((List<Expression>)operandListBuilder.build()));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitInPredicate(InPredicate node, Scope context) {
                List leftResult = (List)this.process(node.getValue(), context);
                List rightResult = (List)this.process(node.getValueList(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int leftSize = leftResult.size();
                int rightSize = rightResult.size();
                int maxSize = Math.max(leftSize, rightSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger leftIndex = leftSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger rightIndex = rightSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new InPredicate((Expression)leftResult.get(leftIndex.get()), (Expression)rightResult.get(rightIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitIsNotNullPredicate(IsNotNullPredicate node, Scope context) {
                List childResult = (List)this.process(node.getValue(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new IsNotNullPredicate(expression));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitIsNullPredicate(IsNullPredicate node, Scope context) {
                List childResult = (List)this.process(node.getValue(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new IsNullPredicate(expression));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitLikePredicate(LikePredicate node, Scope context) {
                List thirdResult;
                List firstResult = (List)this.process(node.getValue(), context);
                List secondResult = (List)this.process(node.getPattern(), context);
                List list = thirdResult = node.getEscape().isPresent() ? (List)this.process(node.getEscape().get(), context) : null;
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int firstSize = firstResult.size();
                int secondSize = secondResult.size();
                int thirdSize = thirdResult == null ? 0 : thirdResult.size();
                int maxSize = Math.max(thirdSize, Math.max(firstSize, secondSize));
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger firstIndex = firstSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger secondIndex = secondSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger thirdIndex = thirdSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new LikePredicate((Expression)firstResult.get(firstIndex.get()), (Expression)secondResult.get(secondIndex.get()), thirdResult == null ? null : (Expression)thirdResult.get(thirdIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitLiteral(Literal node, Scope context) {
                return Collections.singletonList(node);
            }

            @Override
            protected List<Expression> visitLogicalExpression(LogicalExpression node, Scope context) {
                int i;
                ImmutableList.Builder childrenResultListBuilder = new ImmutableList.Builder();
                node.getTerms().forEach(operand -> childrenResultListBuilder.add((Object)((List)this.process((Node)operand, context))));
                ImmutableList childrenResultList = childrenResultListBuilder.build();
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int maxSize = childrenResultList.stream().mapToInt(List::size).max().orElse(0);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[childrenResultList.size()];
                for (i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)childrenResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                for (i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((Expression)((List)childrenResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new LogicalExpression(node.getOperator(), (List<Expression>)operandListBuilder.build()));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitNotExpression(NotExpression node, Scope context) {
                List childResult = (List)this.process(node.getValue(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new NotExpression(expression));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitNullIfExpression(NullIfExpression node, Scope context) {
                throw new SemanticException(String.format("%s are not supported now", node.getClass().getSimpleName()));
            }

            @Override
            protected List<Expression> visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Scope context) {
                List childResult = (List)this.process(node.getValue(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                for (Expression expression : childResult) {
                    resultBuilder.add((Object)new QuantifiedComparisonExpression(node.getOperator(), node.getQuantifier(), expression, node.getSubquery()));
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitRow(Row node, Scope context) {
                throw new SemanticException(String.format("%s are not supported now", node.getClass().getSimpleName()));
            }

            @Override
            protected List<Expression> visitSearchedCaseExpression(SearchedCaseExpression node, Scope context) {
                List secondResult;
                ImmutableList.Builder firstChildResultListBuilder = new ImmutableList.Builder();
                node.getWhenClauses().forEach(when -> firstChildResultListBuilder.add((Object)((List)this.process((Node)when, context))));
                ImmutableList firstChildResultList = firstChildResultListBuilder.build();
                List list = secondResult = node.getDefaultValue().isPresent() ? (List)this.process(node.getDefaultValue().get(), context) : null;
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int secondSize = secondResult == null ? 0 : secondResult.size();
                int maxSize = firstChildResultList.stream().mapToInt(List::size).max().orElse(0);
                maxSize = Math.max(maxSize, secondSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[firstChildResultList.size()];
                for (int i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)firstChildResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                AtomicInteger secondIndex = secondSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((WhenClause)((List)firstChildResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new SearchedCaseExpression((List<WhenClause>)operandListBuilder.build(), secondResult == null ? null : (Expression)secondResult.get(secondIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitSimpleCaseExpression(SimpleCaseExpression node, Scope context) {
                List secondResult;
                List firstResult = (List)this.process(node.getOperand(), context);
                ImmutableList.Builder whenResultListBuilder = new ImmutableList.Builder();
                node.getWhenClauses().forEach(when -> whenResultListBuilder.add((Object)((List)this.process((Node)when, context))));
                ImmutableList whenResultList = whenResultListBuilder.build();
                List list = secondResult = node.getDefaultValue().isPresent() ? (List)this.process(node.getDefaultValue().get(), context) : null;
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int firstSize = firstResult.size();
                int secondSize = secondResult == null ? 0 : secondResult.size();
                int maxSize = whenResultList.stream().mapToInt(List::size).max().orElse(0);
                maxSize = Math.max(Math.max(firstSize, maxSize), secondSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger[] childrenIndexes = new AtomicInteger[whenResultList.size()];
                AtomicInteger firstIndex = firstSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < childrenIndexes.length; ++i) {
                    childrenIndexes[i] = ((List)whenResultList.get(i)).size() == maxSize ? baseIndex : new AtomicInteger(0);
                }
                AtomicInteger secondIndex = secondSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    ImmutableList.Builder operandListBuilder = new ImmutableList.Builder();
                    for (int j = 0; j < childrenIndexes.length; ++j) {
                        int operandIndexInResult = childrenIndexes[j].get();
                        operandListBuilder.add((Object)((WhenClause)((List)whenResultList.get(j)).get(operandIndexInResult)));
                    }
                    resultBuilder.add((Object)new SimpleCaseExpression((Expression)firstResult.get(firstIndex.get()), (List<WhenClause>)operandListBuilder.build(), secondResult == null ? null : (Expression)secondResult.get(secondIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitSubqueryExpression(SubqueryExpression node, Scope context) {
                return Collections.singletonList(node);
            }

            @Override
            protected List<Expression> visitTrim(Trim node, Scope context) {
                List secondResult;
                List firstResult = (List)this.process(node.getTrimSource(), context);
                List list = secondResult = node.getTrimCharacter().isPresent() ? (List)this.process(node.getTrimCharacter().get(), context) : null;
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int firstSize = firstResult.size();
                int secondSize = secondResult == null ? 0 : secondResult.size();
                int maxSize = Math.max(secondSize, firstSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger firstIndex = firstSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger secondIndex = secondSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new Trim(node.getSpecification(), (Expression)firstResult.get(firstIndex.get()), secondResult == null ? null : (Expression)secondResult.get(secondIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }

            @Override
            protected List<Expression> visitWhenClause(WhenClause node, Scope context) {
                List leftResult = (List)this.process(node.getOperand(), context);
                List rightResult = (List)this.process(node.getResult(), context);
                if (this.expandedExpressions == null) {
                    return Collections.singletonList(node);
                }
                ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
                int leftSize = leftResult.size();
                int rightSize = rightResult.size();
                int maxSize = Math.max(leftSize, rightSize);
                AtomicInteger baseIndex = new AtomicInteger(0);
                AtomicInteger leftIndex = leftSize == maxSize ? baseIndex : new AtomicInteger(0);
                AtomicInteger rightIndex = rightSize == maxSize ? baseIndex : new AtomicInteger(0);
                for (int i = 0; i < maxSize; ++i) {
                    resultBuilder.add((Object)new WhenClause((Expression)leftResult.get(leftIndex.get()), (Expression)rightResult.get(rightIndex.get())));
                    baseIndex.getAndIncrement();
                }
                return resultBuilder.build();
            }
        }
    }

    private static enum UpdateKind {
        DELETE,
        UPDATE,
        MERGE;

    }
}

