/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.read.common.block.TsBlock;

public abstract class AbstractQueryDeviceWithCache
extends AbstractTraverseDevice {
    protected List<ShowDevicesResult> results = new ArrayList<ShowDevicesResult>();

    protected AbstractQueryDeviceWithCache(NodeLocation location, Table table, Expression rawExpression) {
        super(location, table, rawExpression);
    }

    protected AbstractQueryDeviceWithCache(String database, String tableName) {
        super(database, tableName);
    }

    public boolean parseRawExpression(TsTable tableInstance, List<String> attributeColumns, MPPQueryContext context) {
        if (Objects.isNull(this.where)) {
            return true;
        }
        ArrayList<DeviceEntry> entries = new ArrayList<DeviceEntry>();
        boolean needFetch = super.parseRawExpression(entries, tableInstance, attributeColumns, context);
        if (!needFetch) {
            context.reserveMemoryForFrontEnd(entries.stream().map(DeviceEntry::ramBytesUsed).reduce(0L, Long::sum));
            this.results = entries.stream().map(deviceEntry -> ShowDevicesResult.convertDeviceEntry2ShowDeviceResult(deviceEntry, attributeColumns)).collect(Collectors.toList());
        }
        return needFetch;
    }

    public static List<ColumnHeader> getDeviceColumnHeaderList(String database, String tableName, List<String> attributeColumns) {
        TsTable table = DataNodeTableCache.getInstance().getTable(database, tableName);
        return Objects.isNull(attributeColumns) ? table.getColumnList().stream().filter(columnSchema -> columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG) || columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)).map(columnSchema -> new ColumnHeader(columnSchema.getColumnName(), columnSchema.getDataType())).collect(Collectors.toList()) : Stream.concat(table.getColumnList().stream().filter(columnSchema -> columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)), attributeColumns.stream().map(arg_0 -> ((TsTable)table).getColumnSchema(arg_0))).map(columnSchema -> new ColumnHeader(columnSchema.getColumnName(), columnSchema.getDataType())).collect(Collectors.toList());
    }

    public abstract DatasetHeader getDataSetHeader();

    public abstract TsBlock getTsBlock(Analysis var1);
}

