/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;

public class InternalBatchActivateTemplateStatement
extends Statement {
    private final Map<PartialPath, Pair<Template, PartialPath>> deviceMap;

    public InternalBatchActivateTemplateStatement(Map<PartialPath, Pair<Template, PartialPath>> deviceMap) {
        this.setType(StatementType.INTERNAL_BATCH_ACTIVATE_TEMPLATE);
        this.deviceMap = deviceMap;
    }

    public Map<PartialPath, Pair<Template, PartialPath>> getDeviceMap() {
        return this.deviceMap;
    }

    public List<PartialPath> getPaths() {
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        ArrayList<String> templatePaths = new ArrayList<String>();
        for (PartialPath path2 : this.deviceMap.keySet()) {
            Pair<Template, PartialPath> templateSetInfo = clusterTemplateManager.checkTemplateSetInfo(path2);
            if (templateSetInfo == null) continue;
            templatePaths.addAll(((Template)templateSetInfo.left).getSchemaMap().keySet());
        }
        return this.deviceMap.keySet().stream().flatMap(path -> templatePaths.stream().map(arg_0 -> ((PartialPath)path).concatAsMeasurementPath(arg_0))).collect(Collectors.toList());
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInternalBatchActivateTemplate(this, context);
    }
}

