/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.DictionaryId;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;

public final class DictionaryColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(DictionaryColumn.class) + (int)RamUsageEstimator.shallowSizeOfInstance(DictionaryId.class);
    private int positionCount;
    private final Column dictionary;
    private final int idsOffset;
    private final int[] ids;
    private final long retainedSizeInBytes;
    private volatile int uniqueIds = -1;
    private volatile boolean isSequentialIds;
    private final DictionaryId dictionarySourceId;
    private final boolean mayHaveNull;

    public static Column create(int positionCount, Column dictionary, int[] ids) {
        return DictionaryColumn.createInternal(0, positionCount, dictionary, ids, DictionaryId.randomDictionaryId());
    }

    public static Column createProjectedDictionaryColumn(int positionCount, Column dictionary, int[] ids, DictionaryId dictionarySourceId) {
        return DictionaryColumn.createInternal(0, positionCount, dictionary, ids, dictionarySourceId);
    }

    static Column createInternal(int idsOffset, int positionCount, Column dictionary, int[] ids, DictionaryId dictionarySourceId) {
        if (positionCount == 0) {
            return dictionary.getRegionCopy(0, 0);
        }
        if (positionCount == 1) {
            return dictionary.getRegion(ids[idsOffset], 1);
        }
        if (dictionary instanceof RunLengthEncodedColumn) {
            RunLengthEncodedColumn rle = (RunLengthEncodedColumn)dictionary;
            return new RunLengthEncodedColumn(rle.getValue(), positionCount);
        }
        if (dictionary instanceof DictionaryColumn) {
            DictionaryColumn dictionaryColumn = (DictionaryColumn)dictionary;
            int[] newIds = new int[positionCount];
            for (int position = 0; position < positionCount; ++position) {
                newIds[position] = dictionaryColumn.getId(ids[idsOffset + position]);
            }
            return new DictionaryColumn(0, positionCount, dictionaryColumn.getDictionary(), newIds, false, false, DictionaryId.randomDictionaryId());
        }
        return new DictionaryColumn(idsOffset, positionCount, dictionary, ids, false, false, dictionarySourceId);
    }

    DictionaryColumn(int idsOffset, int positionCount, Column dictionary, int[] ids, boolean dictionaryIsCompacted, boolean isSequentialIds, DictionaryId dictionarySourceId) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.idsOffset = idsOffset;
        if (ids.length - idsOffset < positionCount) {
            throw new IllegalArgumentException("ids length is less than positionCount");
        }
        this.positionCount = positionCount;
        this.dictionary = dictionary;
        this.ids = ids;
        this.dictionarySourceId = Objects.requireNonNull(dictionarySourceId, "dictionarySourceId is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOf((int[])ids);
        boolean bl = this.mayHaveNull = positionCount > 0 && dictionary.mayHaveNull();
        if (dictionaryIsCompacted) {
            this.uniqueIds = dictionary.getPositionCount();
        }
        if (isSequentialIds && !dictionaryIsCompacted) {
            throw new IllegalArgumentException("sequential ids flag is only valid for compacted dictionary");
        }
        this.isSequentialIds = isSequentialIds;
    }

    public int[] getRawIds() {
        return this.ids;
    }

    public int getRawIdsOffset() {
        return this.idsOffset;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    private void calculateCompactSize() {
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        boolean isSequentialIds = true;
        int previousPosition = -1;
        for (int i = 0; i < this.positionCount; ++i) {
            int position = this.ids[this.idsOffset + i];
            uniqueIds += used[position] ? 0 : 1;
            used[position] = true;
            if (!isSequentialIds) continue;
            isSequentialIds = previousPosition < position;
            previousPosition = position;
        }
        this.uniqueIds = uniqueIds;
        this.isSequentialIds = isSequentialIds;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.dictionary.getRetainedSizeInBytes();
    }

    public long getSizeInBytes() {
        return this.ids.length > 0 ? this.getRetainedSizeInBytes() * (long)this.positionCount / (long)this.ids.length : 0L;
    }

    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.positionCount, positionOffset, length);
        if (length == this.positionCount) {
            return this;
        }
        return new DictionaryColumn(this.idsOffset + positionOffset, length, this.dictionary, this.ids, false, false, this.dictionarySourceId);
    }

    public Column getRegionCopy(int position, int length) {
        ColumnUtil.checkValidRegion(this.positionCount, position, length);
        if (length == 0) {
            return this.dictionary.getRegionCopy(0, 0);
        }
        int uniqueIds = this.uniqueIds;
        if (length <= 1 || uniqueIds == this.dictionary.getPositionCount() && this.isSequentialIds) {
            return this.dictionary.getRegionCopy(this.getId(position), length);
        }
        if (uniqueIds == this.positionCount) {
            return this.dictionary.copyPositions(this.ids, this.idsOffset + position, length);
        }
        int[] newIds = ColumnUtil.compactArray(this.ids, this.idsOffset + position, length);
        if (newIds == this.ids) {
            return this;
        }
        return new DictionaryColumn(0, length, this.dictionary, newIds, false, false, DictionaryId.randomDictionaryId()).compact();
    }

    public Column subColumn(int fromIndex) {
        return this.getRegion(fromIndex, this.positionCount - fromIndex);
    }

    public Column subColumnCopy(int fromIndex) {
        return this.getRegionCopy(fromIndex, this.positionCount - fromIndex);
    }

    public TSDataType getDataType() {
        return this.dictionary.getDataType();
    }

    public ColumnEncoding getEncoding() {
        return ColumnEncoding.DICTIONARY;
    }

    public boolean mayHaveNull() {
        return this.mayHaveNull && this.dictionary.mayHaveNull();
    }

    public boolean isNull(int position) {
        if (!this.mayHaveNull) {
            return false;
        }
        ColumnUtil.checkValidPosition(position, this.positionCount);
        return this.dictionary.isNull(this.getIdUnchecked(position));
    }

    public boolean[] isNull() {
        boolean[] original = this.dictionary.isNull();
        boolean[] res = new boolean[this.positionCount];
        if (original == null) {
            Arrays.fill(res, false);
            return res;
        }
        for (int i = 0; i < this.positionCount; ++i) {
            int position = this.ids[this.idsOffset + i];
            res[i] = this.dictionary.isNull(position);
        }
        return res;
    }

    public void setNull(int start, int end) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        int[] newIds = new int[length];
        boolean isCompact = length >= this.dictionary.getPositionCount() && this.isCompact();
        boolean[] usedIds = isCompact ? new boolean[this.dictionary.getPositionCount()] : null;
        int uniqueIds = 0;
        for (int i = 0; i < length; ++i) {
            int id;
            newIds[i] = id = this.getId(positions[offset + i]);
            if (usedIds == null) continue;
            uniqueIds += usedIds[id] ? 0 : 1;
            usedIds[id] = true;
        }
        DictionaryColumn result = new DictionaryColumn(0, newIds.length, this.dictionary, newIds, isCompact &= usedIds != null && usedIds.length == uniqueIds, false, this.getDictionarySourceId());
        if (usedIds != null && !isCompact) {
            result.uniqueIds = uniqueIds;
        }
        return result;
    }

    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        if (length <= 1 || this.uniqueIds == this.positionCount) {
            int[] positionsToCopy = new int[length];
            for (int i = 0; i < length; ++i) {
                positionsToCopy[i] = this.getId(positions[offset + i]);
            }
            return this.dictionary.copyPositions(positionsToCopy, 0, length);
        }
        ArrayList<Integer> positionsToCopy = new ArrayList<Integer>();
        HashMap<Integer, Integer> oldIndexToNewIndex = new HashMap<Integer, Integer>(Math.min(length, this.dictionary.getPositionCount()));
        int[] newIds = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            int oldIndex = this.getId(position);
            Integer newId = oldIndexToNewIndex.putIfAbsent(oldIndex, positionsToCopy.size());
            if (newId == null) {
                newId = positionsToCopy.size();
                positionsToCopy.add(oldIndex);
            }
            newIds[i] = newId;
        }
        Column compactDictionary = this.dictionary.copyPositions(ArrayUtils.toPrimitive((Integer[])positionsToCopy.toArray(new Integer[0])), 0, positionsToCopy.size());
        if (positionsToCopy.size() == length) {
            return compactDictionary;
        }
        return new DictionaryColumn(0, length, compactDictionary, newIds, true, false, DictionaryId.randomDictionaryId());
    }

    public void reverse() {
        int currIndex = this.idsOffset;
        for (int endIndex = this.ids.length - 1; currIndex < endIndex; ++currIndex, --endIndex) {
            int temp = this.ids[currIndex];
            this.ids[currIndex] = this.ids[endIndex];
            this.ids[endIndex] = temp;
        }
    }

    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    public boolean getBoolean(int position) {
        return this.dictionary.getBoolean(this.getId(position));
    }

    public int getInt(int position) {
        return this.dictionary.getInt(this.getId(position));
    }

    public long getLong(int position) {
        return this.dictionary.getLong(this.getId(position));
    }

    public float getFloat(int position) {
        return this.dictionary.getFloat(this.getId(position));
    }

    public double getDouble(int position) {
        return this.dictionary.getDouble(this.getId(position));
    }

    public Binary getBinary(int position) {
        return this.dictionary.getBinary(this.getId(position));
    }

    public Object getObject(int position) {
        return this.dictionary.getObject(this.getId(position));
    }

    public TsPrimitiveType getTsPrimitiveType(int position) {
        return this.dictionary.getTsPrimitiveType(position);
    }

    public void reset() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DictionaryColumn{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private Column getUnderlyingColumn() {
        return this.dictionary;
    }

    private int getUnderlyingValuePosition(int position) {
        return this.getId(position);
    }

    public Column getDictionary() {
        return this.dictionary;
    }

    public int getId(int position) {
        ColumnUtil.checkValidPosition(position, this.positionCount);
        return this.getIdUnchecked(position);
    }

    private int getIdUnchecked(int position) {
        return this.ids[position + this.idsOffset];
    }

    public DictionaryId getDictionarySourceId() {
        return this.dictionarySourceId;
    }

    public boolean isCompact() {
        if (this.uniqueIds == -1) {
            this.calculateCompactSize();
        }
        return this.uniqueIds == this.dictionary.getPositionCount();
    }

    public DictionaryColumn compact() {
        if (this.isCompact()) {
            return this;
        }
        int dictionarySize = this.dictionary.getPositionCount();
        ArrayList<Integer> dictionaryPositionsToCopy = new ArrayList<Integer>(Math.min(dictionarySize, this.positionCount));
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < this.positionCount; ++i) {
            int dictionaryIndex = this.getId(i);
            if (remapIndex[dictionaryIndex] != -1) continue;
            dictionaryPositionsToCopy.add(dictionaryIndex);
            remapIndex[dictionaryIndex] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return this;
        }
        int[] newIds = new int[this.positionCount];
        for (int i = 0; i < this.positionCount; ++i) {
            int newId = remapIndex[this.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        try {
            Column compactDictionary = this.dictionary.copyPositions(ArrayUtils.toPrimitive((Integer[])dictionaryPositionsToCopy.toArray(new Integer[0])), 0, dictionaryPositionsToCopy.size());
            return new DictionaryColumn(0, this.positionCount, compactDictionary, newIds, true, this.uniqueIds == this.positionCount, DictionaryId.randomDictionaryId());
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
    }

    public static List<DictionaryColumn> compactRelatedColumns(List<DictionaryColumn> Columns) {
        DictionaryColumn firstDictionaryColumn = Columns.get(0);
        Column dictionary = firstDictionaryColumn.getDictionary();
        int positionCount = firstDictionaryColumn.getPositionCount();
        int dictionarySize = dictionary.getPositionCount();
        int[] dictionaryPositionsToCopy = new int[Math.min(dictionarySize, positionCount)];
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int numberOfIndexes = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = firstDictionaryColumn.getId(i);
            if (remapIndex[position] != -1) continue;
            dictionaryPositionsToCopy[numberOfIndexes] = position;
            remapIndex[position] = numberOfIndexes++;
        }
        if (numberOfIndexes == dictionarySize) {
            return Columns;
        }
        int[] newIds = DictionaryColumn.getNewIds(positionCount, firstDictionaryColumn, remapIndex);
        ArrayList<DictionaryColumn> outputDictionaryColumns = new ArrayList<DictionaryColumn>(Columns.size());
        DictionaryId newDictionaryId = DictionaryId.randomDictionaryId();
        for (DictionaryColumn dictionaryColumn : Columns) {
            if (!firstDictionaryColumn.getDictionarySourceId().equals(dictionaryColumn.getDictionarySourceId())) {
                throw new IllegalArgumentException("dictionarySourceIds must be the same");
            }
            try {
                Column compactDictionary = dictionaryColumn.getDictionary().copyPositions(dictionaryPositionsToCopy, 0, numberOfIndexes);
                outputDictionaryColumns.add(new DictionaryColumn(0, positionCount, compactDictionary, newIds, true, false, newDictionaryId));
            }
            catch (UnsupportedOperationException e) {
                outputDictionaryColumns.add(dictionaryColumn);
            }
        }
        return outputDictionaryColumns;
    }

    private static int[] getNewIds(int positionCount, DictionaryColumn dictionaryColumn, int[] remapIndex) {
        int[] newIds = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int newId = remapIndex[dictionaryColumn.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        return newIds;
    }
}

