/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.ConfigurationFileUtils;
import org.apache.iotdb.commons.conf.TrimProperties;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.partition.RegionGroupExtensionPolicy;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final ConfigNodeConfig conf = new ConfigNodeConfig();

    private ConfigNodeDescriptor() {
        this.loadProps();
    }

    public ConfigNodeConfig getConf() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URL getPropsUrl(String configFileName) {
        String urlString = System.getProperty("CONFIGNODE_CONF", null);
        if (urlString == null) {
            urlString = System.getProperty("CONFIGNODE_HOME", null);
            if (urlString == null) return null;
            urlString = urlString + File.separatorChar + "conf" + File.separatorChar + configFileName;
        } else if (!urlString.endsWith(".properties")) {
            urlString = urlString + File.separatorChar + configFileName;
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOGGER.warn("get url failed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        TrimProperties trimProperties = new TrimProperties();
        URL url = ConfigNodeDescriptor.getPropsUrl("iotdb-system.properties");
        if (url != null) {
            try (InputStream inputStream = url.openStream();){
                LOGGER.info("start reading ConfigNode conf file: {}", (Object)url);
                trimProperties.load((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                this.loadProperties(trimProperties);
            }
            catch (IOException | BadNodeUrlException e) {
                LOGGER.error("Couldn't load ConfigNode conf file, reject ConfigNode startup.", e);
                System.exit(-1);
            }
            finally {
                this.conf.updatePath();
                this.commonDescriptor.getConfig().updatePath(System.getProperty("CONFIGNODE_HOME", null));
                MetricConfigDescriptor.getInstance().loadProps((Properties)trimProperties, true);
                MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(NodeType.CONFIGNODE, "root.__system");
            }
        } else {
            LOGGER.warn("Couldn't load the configuration {} from any of the known sources.", (Object)"iotdb-system.properties");
        }
    }

    private void loadProperties(TrimProperties properties) throws BadNodeUrlException, IOException {
        this.conf.setClusterName(properties.getProperty("cluster_name", this.conf.getClusterName()));
        this.conf.setInternalAddress(properties.getProperty("cn_internal_address", this.conf.getInternalAddress()));
        this.conf.setInternalPort(Integer.parseInt(properties.getProperty("cn_internal_port", String.valueOf(this.conf.getInternalPort()))));
        this.conf.setConsensusPort(Integer.parseInt(properties.getProperty("cn_consensus_port", String.valueOf(this.conf.getConsensusPort()))));
        String seedConfigNode = properties.getProperty("cn_seed_config_node", null);
        if (seedConfigNode == null) {
            seedConfigNode = properties.getProperty("cn_target_config_node_list", null);
            LOGGER.warn("The parameter cn_target_config_node_list has been abandoned, only the first ConfigNode address will be used to join in the cluster. Please use cn_seed_config_node instead.");
        }
        if (seedConfigNode != null) {
            this.conf.setSeedConfigNode((TEndPoint)NodeUrlUtils.parseTEndPointUrls((String)seedConfigNode).get(0));
        }
        this.conf.setSeriesSlotNum(Integer.parseInt(properties.getProperty("series_slot_num", String.valueOf(this.conf.getSeriesSlotNum()))));
        this.conf.setSeriesPartitionExecutorClass(properties.getProperty("series_partition_executor_class", this.conf.getSeriesPartitionExecutorClass()));
        this.conf.setConfigNodeConsensusProtocolClass(properties.getProperty("config_node_consensus_protocol_class", this.conf.getConfigNodeConsensusProtocolClass()));
        this.conf.setSchemaRegionConsensusProtocolClass(properties.getProperty("schema_region_consensus_protocol_class", this.conf.getSchemaRegionConsensusProtocolClass()));
        this.conf.setSchemaReplicationFactor(Integer.parseInt(properties.getProperty("schema_replication_factor", String.valueOf(this.conf.getSchemaReplicationFactor()))));
        this.conf.setDataRegionConsensusProtocolClass(properties.getProperty("data_region_consensus_protocol_class", this.conf.getDataRegionConsensusProtocolClass()));
        this.conf.setDataReplicationFactor(Integer.parseInt(properties.getProperty("data_replication_factor", String.valueOf(this.conf.getDataReplicationFactor()))));
        this.conf.setSchemaRegionGroupExtensionPolicy(RegionGroupExtensionPolicy.parse(properties.getProperty("schema_region_group_extension_policy", this.conf.getSchemaRegionGroupExtensionPolicy().getPolicy())));
        this.conf.setDefaultSchemaRegionGroupNumPerDatabase(Integer.parseInt(properties.getProperty("default_schema_region_group_num_per_database", String.valueOf(this.conf.getDefaultSchemaRegionGroupNumPerDatabase()))));
        this.conf.setSchemaRegionPerDataNode((int)Double.parseDouble(properties.getProperty("schema_region_per_data_node", String.valueOf(this.conf.getSchemaRegionPerDataNode()))));
        this.conf.setDataRegionGroupExtensionPolicy(RegionGroupExtensionPolicy.parse(properties.getProperty("data_region_group_extension_policy", this.conf.getDataRegionGroupExtensionPolicy().getPolicy())));
        this.conf.setDefaultDataRegionGroupNumPerDatabase(Integer.parseInt(properties.getProperty("default_data_region_group_num_per_database", String.valueOf(this.conf.getDefaultDataRegionGroupNumPerDatabase()))));
        this.conf.setDataRegionPerDataNode((int)Double.parseDouble(properties.getProperty("data_region_per_data_node", String.valueOf(this.conf.getDataRegionPerDataNode()))));
        try {
            this.conf.setRegionAllocateStrategy(RegionBalancer.RegionGroupAllocatePolicy.valueOf(properties.getProperty("region_group_allocate_policy", this.conf.getRegionGroupAllocatePolicy().name())));
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        this.conf.setCnRpcMaxConcurrentClientNum(Integer.parseInt(properties.getProperty("cn_rpc_max_concurrent_client_num", String.valueOf(this.conf.getCnRpcMaxConcurrentClientNum()))));
        this.conf.setMaxClientNumForEachNode(Integer.parseInt(properties.getProperty("cn_max_client_count_for_each_node_in_client_manager", String.valueOf(this.conf.getMaxClientNumForEachNode()))));
        this.conf.setSystemDir(properties.getProperty("cn_system_dir", this.conf.getSystemDir()));
        this.conf.setConsensusDir(properties.getProperty("cn_consensus_dir", this.conf.getConsensusDir()));
        this.conf.setUdfDir(properties.getProperty("udf_lib_dir", this.conf.getUdfDir()));
        this.conf.setTriggerDir(properties.getProperty("trigger_lib_dir", this.conf.getTriggerDir()));
        this.conf.setPipeDir(properties.getProperty("pipe_lib_dir", this.conf.getPipeDir()));
        this.conf.setPipeReceiverFileDir(Optional.ofNullable(properties.getProperty("cn_pipe_receiver_file_dir")).orElse(properties.getProperty("pipe_receiver_file_dir", this.conf.getSystemDir() + File.separator + "pipe" + File.separator + "receiver")));
        this.conf.setHeartbeatIntervalInMs(Long.parseLong(properties.getProperty("heartbeat_interval_in_ms", String.valueOf(this.conf.getHeartbeatIntervalInMs()))));
        String failureDetector = properties.getProperty("failure_detector", this.conf.getFailureDetector());
        if (!"fixed".equals(failureDetector) && !"phi_accrual".equals(failureDetector)) {
            throw new IOException(String.format("Unknown failure_detector: %s, please set to \"fixed\" or \"phi_accrual\"", failureDetector));
        }
        this.conf.setFailureDetector(failureDetector);
        this.conf.setFailureDetectorFixedThresholdInMs(Long.parseLong(properties.getProperty("failure_detector_fixed_threshold_in_ms", String.valueOf(this.conf.getFailureDetectorFixedThresholdInMs()))));
        this.conf.setFailureDetectorPhiThreshold(Long.parseLong(properties.getProperty("failure_detector_phi_threshold", String.valueOf(this.conf.getFailureDetectorPhiThreshold()))));
        this.conf.setFailureDetectorPhiAcceptablePauseInMs(Long.parseLong(properties.getProperty("failure_detector_phi_acceptable_pause_in_ms", String.valueOf(this.conf.getFailureDetectorPhiAcceptablePauseInMs()))));
        String leaderDistributionPolicy = properties.getProperty("leader_distribution_policy", this.conf.getLeaderDistributionPolicy());
        if (!"GREEDY".equals(leaderDistributionPolicy) && !"CFD".equals(leaderDistributionPolicy)) {
            throw new IOException(String.format("Unknown leader_distribution_policy: %s, please set to \"GREEDY\" or \"CFD\"", leaderDistributionPolicy));
        }
        this.conf.setLeaderDistributionPolicy(leaderDistributionPolicy);
        this.conf.setEnableAutoLeaderBalanceForRatisConsensus(Boolean.parseBoolean(properties.getProperty("enable_auto_leader_balance_for_ratis_consensus", String.valueOf(this.conf.isEnableAutoLeaderBalanceForRatisConsensus()))));
        this.conf.setEnableAutoLeaderBalanceForIoTConsensus(Boolean.parseBoolean(properties.getProperty("enable_auto_leader_balance_for_iot_consensus", String.valueOf(this.conf.isEnableAutoLeaderBalanceForIoTConsensus()))));
        String routePriorityPolicy = properties.getProperty("route_priority_policy", this.conf.getRoutePriorityPolicy());
        if (!"GREEDY".equals(routePriorityPolicy) && !"LEADER".equals(routePriorityPolicy)) {
            throw new IOException(String.format("Unknown route_priority_policy: %s, please set to \"LEADER\" or \"GREEDY\"", routePriorityPolicy));
        }
        this.conf.setRoutePriorityPolicy(routePriorityPolicy);
        String readConsistencyLevel = properties.getProperty("read_consistency_level", this.conf.getReadConsistencyLevel());
        if (!readConsistencyLevel.equals("strong") && !readConsistencyLevel.equals("weak")) {
            throw new IOException(String.format("Unknown read_consistency_level: %s, please set to \"strong\" or \"weak\"", readConsistencyLevel));
        }
        this.conf.setReadConsistencyLevel(readConsistencyLevel);
        this.commonDescriptor.loadCommonProps(properties);
        this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
        this.conf.setProcedureCompletedEvictTTL(Integer.parseInt(properties.getProperty("procedure_completed_evict_ttl", String.valueOf(this.conf.getProcedureCompletedEvictTTL()))));
        this.conf.setProcedureCompletedCleanInterval(Integer.parseInt(properties.getProperty("procedure_completed_clean_interval", String.valueOf(this.conf.getProcedureCompletedCleanInterval()))));
        this.conf.setProcedureCoreWorkerThreadsCount(Integer.parseInt(properties.getProperty("procedure_core_worker_thread_count", String.valueOf(this.conf.getProcedureCoreWorkerThreadsCount()))));
        this.loadRatisConsensusConfig(properties);
        this.loadCQConfig(properties);
    }

    private void loadRatisConsensusConfig(TrimProperties properties) {
        this.conf.setDataRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("data_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getDataRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setConfigNodeRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("config_node_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getConfigNodeRatisConsensusLogAppenderBufferSize()))));
        this.conf.setSchemaRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("schema_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getSchemaRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setDataRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("data_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getDataRegionRatisSnapshotTriggerThreshold()))));
        this.conf.setConfigNodeRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("config_node_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getConfigNodeRatisSnapshotTriggerThreshold()))));
        this.conf.setSchemaRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("schema_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getSchemaRegionRatisSnapshotTriggerThreshold()))));
        this.conf.setDataRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("data_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isDataRegionRatisLogUnsafeFlushEnable()))));
        this.conf.setConfigNodeRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("config_node_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isConfigNodeRatisLogUnsafeFlushEnable()))));
        this.conf.setSchemaRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("schema_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isSchemaRegionRatisLogUnsafeFlushEnable()))));
        this.conf.setDataRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("data_region_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getDataRegionRatisLogSegmentSizeMax()))));
        this.conf.setConfigNodeRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("config_node_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getConfigNodeRatisLogSegmentSizeMax()))));
        this.conf.setSchemaRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("schema_region_ratis_log_segment_size_max_in_byte", String.valueOf(this.conf.getSchemaRegionRatisLogSegmentSizeMax()))));
        this.conf.setConfigNodeSimpleConsensusLogSegmentSizeMax(Long.parseLong(properties.getProperty("config_node_simple_consensus_log_segment_size_max_in_byte", String.valueOf(this.conf.getConfigNodeSimpleConsensusLogSegmentSizeMax()))));
        this.conf.setDataRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("data_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getDataRegionRatisGrpcFlowControlWindow()))));
        this.conf.setConfigNodeRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("config_node_ratis_grpc_flow_control_window", String.valueOf(this.conf.getConfigNodeRatisGrpcFlowControlWindow()))));
        this.conf.setSchemaRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("schema_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getSchemaRegionRatisGrpcFlowControlWindow()))));
        this.conf.setDataRegionRatisGrpcLeaderOutstandingAppendsMax(Integer.parseInt(properties.getProperty("data_region_ratis_grpc_leader_outstanding_appends_max", String.valueOf(this.conf.getDataRegionRatisGrpcLeaderOutstandingAppendsMax()))));
        this.conf.setConfigNodeRatisGrpcLeaderOutstandingAppendsMax(Integer.parseInt(properties.getProperty("config_node_ratis_grpc_leader_outstanding_appends_max", String.valueOf(this.conf.getConfigNodeRatisGrpcLeaderOutstandingAppendsMax()))));
        this.conf.setSchemaRegionRatisGrpcLeaderOutstandingAppendsMax(Integer.parseInt(properties.getProperty("schema_region_ratis_grpc_leader_outstanding_appends_max", String.valueOf(this.conf.getSchemaRegionRatisGrpcLeaderOutstandingAppendsMax()))));
        this.conf.setDataRegionRatisLogForceSyncNum(Integer.parseInt(properties.getProperty("data_region_ratis_log_force_sync_num", String.valueOf(this.conf.getDataRegionRatisLogForceSyncNum()))));
        this.conf.setConfigNodeRatisLogForceSyncNum(Integer.parseInt(properties.getProperty("config_node_ratis_log_force_sync_num", String.valueOf(this.conf.getConfigNodeRatisLogForceSyncNum()))));
        this.conf.setSchemaRegionRatisLogForceSyncNum(Integer.parseInt(properties.getProperty("schema_region_ratis_log_force_sync_num", String.valueOf(this.conf.getSchemaRegionRatisLogForceSyncNum()))));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setConfigNodeRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("config_node_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getConfigNodeRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMaxMs()))));
        this.conf.setConfigNodeRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("config_node_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getConfigNodeRatisRpcLeaderElectionTimeoutMaxMs()))));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs()))));
        this.conf.setConfigNodeRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("config_node_ratis_request_timeout_ms", String.valueOf(this.conf.getConfigNodeRatisRequestTimeoutMs()))));
        this.conf.setSchemaRegionRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("schema_region_ratis_request_timeout_ms", String.valueOf(this.conf.getSchemaRegionRatisRequestTimeoutMs()))));
        this.conf.setDataRegionRatisRequestTimeoutMs(Long.parseLong(properties.getProperty("data_region_ratis_request_timeout_ms", String.valueOf(this.conf.getDataRegionRatisRequestTimeoutMs()))));
        this.conf.setConfigNodeRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("config_node_ratis_max_retry_attempts", String.valueOf(this.conf.getConfigNodeRatisMaxRetryAttempts()))));
        this.conf.setConfigNodeRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("config_node_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getConfigNodeRatisInitialSleepTimeMs()))));
        this.conf.setConfigNodeRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("config_node_ratis_max_sleep_time_ms", String.valueOf(this.conf.getConfigNodeRatisMaxSleepTimeMs()))));
        this.conf.setDataRegionRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("data_region_ratis_max_retry_attempts", String.valueOf(this.conf.getDataRegionRatisMaxRetryAttempts()))));
        this.conf.setDataRegionRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("data_region_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getDataRegionRatisInitialSleepTimeMs()))));
        this.conf.setDataRegionRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("data_region_ratis_max_sleep_time_ms", String.valueOf(this.conf.getDataRegionRatisMaxSleepTimeMs()))));
        this.conf.setSchemaRegionRatisMaxRetryAttempts(Integer.parseInt(properties.getProperty("schema_region_ratis_max_retry_attempts", String.valueOf(this.conf.getSchemaRegionRatisMaxRetryAttempts()))));
        this.conf.setSchemaRegionRatisInitialSleepTimeMs(Long.parseLong(properties.getProperty("schema_region_ratis_initial_sleep_time_ms", String.valueOf(this.conf.getSchemaRegionRatisInitialSleepTimeMs()))));
        this.conf.setSchemaRegionRatisMaxSleepTimeMs(Long.parseLong(properties.getProperty("schema_region_ratis_max_sleep_time_ms", String.valueOf(this.conf.getSchemaRegionRatisMaxSleepTimeMs()))));
        this.conf.setConfigNodeRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("config_node_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getConfigNodeRatisPreserveLogsWhenPurge()))));
        this.conf.setSchemaRegionRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("schema_region_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getSchemaRegionRatisPreserveLogsWhenPurge()))));
        this.conf.setDataRegionRatisPreserveLogsWhenPurge(Long.parseLong(properties.getProperty("data_region_ratis_preserve_logs_num_when_purge", String.valueOf(this.conf.getDataRegionRatisPreserveLogsWhenPurge()))));
        this.conf.setRatisFirstElectionTimeoutMinMs(Long.parseLong(properties.getProperty("ratis_first_election_timeout_min_ms", String.valueOf(this.conf.getRatisFirstElectionTimeoutMinMs()))));
        this.conf.setRatisFirstElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("ratis_first_election_timeout_max_ms", String.valueOf(this.conf.getRatisFirstElectionTimeoutMaxMs()))));
        this.conf.setConfigNodeRatisLogMax(Long.parseLong(properties.getProperty("config_node_ratis_log_max_size", String.valueOf(this.conf.getConfigNodeRatisLogMax()))));
        this.conf.setSchemaRegionRatisLogMax(Long.parseLong(properties.getProperty("schema_region_ratis_log_max_size", String.valueOf(this.conf.getSchemaRegionRatisLogMax()))));
        this.conf.setDataRegionRatisLogMax(Long.parseLong(properties.getProperty("data_region_ratis_log_max_size", String.valueOf(this.conf.getDataRegionRatisLogMax()))));
        this.conf.setConfigNodeRatisPeriodicSnapshotInterval(Long.parseLong(properties.getProperty("config_node_ratis_periodic_snapshot_interval", String.valueOf(this.conf.getConfigNodeRatisPeriodicSnapshotInterval()))));
        this.conf.setSchemaRegionRatisPeriodicSnapshotInterval(Long.parseLong(properties.getProperty("schema_region_ratis_periodic_snapshot_interval", String.valueOf(this.conf.getSchemaRegionRatisPeriodicSnapshotInterval()))));
        this.conf.setDataRegionRatisPeriodicSnapshotInterval(Long.parseLong(properties.getProperty("data_region_ratis_periodic_snapshot_interval", String.valueOf(this.conf.getDataRegionRatisPeriodicSnapshotInterval()))));
        this.conf.setEnablePrintingNewlyCreatedPartition(Boolean.parseBoolean(properties.getProperty("enable_printing_newly_created_partition", String.valueOf(this.conf.isEnablePrintingNewlyCreatedPartition()))));
        this.conf.setForceWalPeriodForConfigNodeSimpleInMs(Long.parseLong(properties.getProperty("force_wal_period_for_confignode_simple_in_ms", String.valueOf(this.conf.getForceWalPeriodForConfigNodeSimpleInMs()))));
    }

    private void loadCQConfig(TrimProperties properties) {
        int cqSubmitThread = Integer.parseInt(properties.getProperty("continuous_query_submit_thread_count", String.valueOf(this.conf.getCqSubmitThread())));
        if (cqSubmitThread <= 0) {
            LOGGER.warn("continuous_query_submit_thread should be greater than 0, but current value is {}, ignore that and use the default value {}", (Object)cqSubmitThread, (Object)this.conf.getCqSubmitThread());
            cqSubmitThread = this.conf.getCqSubmitThread();
        }
        this.conf.setCqSubmitThread(cqSubmitThread);
        long cqMinEveryIntervalInMs = Long.parseLong(properties.getProperty("continuous_query_min_every_interval_in_ms", String.valueOf(this.conf.getCqMinEveryIntervalInMs())));
        if (cqMinEveryIntervalInMs <= 0L) {
            LOGGER.warn("continuous_query_min_every_interval_in_ms should be greater than 0, but current value is {}, ignore that and use the default value {}", (Object)cqMinEveryIntervalInMs, (Object)this.conf.getCqMinEveryIntervalInMs());
            cqMinEveryIntervalInMs = this.conf.getCqMinEveryIntervalInMs();
        }
        this.conf.setCqMinEveryIntervalInMs(cqMinEveryIntervalInMs);
    }

    public boolean isSeedConfigNode() {
        try {
            return (this.conf.getInternalAddress().equals(this.conf.getSeedConfigNode().getIp()) || NodeUrlUtils.containsLocalAddress(Collections.singletonList(this.conf.getInternalAddress())) && NodeUrlUtils.containsLocalAddress(Collections.singletonList(this.conf.getSeedConfigNode().getIp()))) && this.conf.getInternalPort() == this.conf.getSeedConfigNode().getPort();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unknown host when checking seed configNode IP {}", (Object)this.conf.getInternalAddress(), (Object)e);
            return false;
        }
    }

    public void loadHotModifiedProps(TrimProperties properties) {
        Optional.ofNullable(properties.getProperty("cluster_name")).ifPresent(this.conf::setClusterName);
    }

    public static ConfigNodeDescriptor getInstance() {
        return ConfigNodeDescriptorHolder.INSTANCE;
    }

    static {
        URL systemConfigUrl = ConfigNodeDescriptor.getPropsUrl("iotdb-system.properties");
        URL configNodeUrl = ConfigNodeDescriptor.getPropsUrl("iotdb-confignode.properties");
        URL dataNodeUrl = ConfigNodeDescriptor.getPropsUrl("iotdb-datanode.properties");
        URL commonConfigUrl = ConfigNodeDescriptor.getPropsUrl("iotdb-common.properties");
        try {
            ConfigurationFileUtils.checkAndMayUpdate((URL)systemConfigUrl, (URL)configNodeUrl, (URL)dataNodeUrl, (URL)commonConfigUrl);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Failed to update config file", (Throwable)e);
        }
    }

    private static class ConfigNodeDescriptorHolder {
        private static final ConfigNodeDescriptor INSTANCE = new ConfigNodeDescriptor();

        private ConfigNodeDescriptorHolder() {
        }
    }
}

