/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.auth;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AuthorRelationalPlan
extends AuthorPlan {
    protected Set<Integer> permissions;
    protected String databaseName;
    protected String tableName;

    public AuthorRelationalPlan(ConfigPhysicalPlanType authorType) {
        super(authorType);
    }

    public AuthorRelationalPlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String databaseName, String tableName, Set<Integer> permissions, boolean grantOpt, String password) {
        super(authorType, userName, roleName, password, "", grantOpt);
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.permissions = permissions;
    }

    public AuthorRelationalPlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String databaseName, String tableName, int permission, boolean grantOpt) {
        super(authorType, userName, roleName, "", "", grantOpt);
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.permissions = Collections.singleton(permission);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AuthorRelationalPlan) {
            AuthorRelationalPlan that = (AuthorRelationalPlan)o;
            return super.equals(o) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.permissions, that.permissions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.databaseName, this.tableName, this.permissions);
    }

    @Override
    public String toString() {
        return "[type:" + (Object)((Object)super.getType()) + ", name:" + this.userName + ", role:" + this.roleName + ", permissions:" + PrivilegeType.toPriType(this.permissions) + ", grant option:" + this.grantOpt + ", DB:" + this.databaseName + ", TABLE:" + this.tableName + "]";
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((short)this.getType().getPlanType(), (OutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.userName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.roleName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.password, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.databaseName, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((String)this.tableName, (DataOutputStream)stream);
        stream.writeInt(this.permissions.size());
        for (Integer permission : this.permissions) {
            stream.writeInt(permission);
        }
        stream.write(this.grantOpt ? 1 : 0);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.newPassword = "";
        this.userName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.roleName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.password = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.databaseName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.tableName = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.permissions = new HashSet<Integer>();
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            this.permissions.add(buffer.getInt());
        }
        this.grantOpt = buffer.get() == 1;
    }
}

