/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.DescTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.FetchTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.ShowTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RollbackCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableColumnCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.partition.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.table.DescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.consensus.response.table.DescTableResp;
import org.apache.iotdb.confignode.consensus.response.table.FetchTableResp;
import org.apache.iotdb.confignode.consensus.response.table.ShowTable4InformationSchemaResp;
import org.apache.iotdb.confignode.consensus.response.table.ShowTableResp;
import org.apache.iotdb.confignode.consensus.response.template.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateSetInfoResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.persistence.schema.ConfigMTree;
import org.apache.iotdb.confignode.persistence.schema.TemplatePreSetTable;
import org.apache.iotdb.confignode.persistence.schema.TemplateTable;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TTableColumnInfo;
import org.apache.iotdb.confignode.rpc.thrift.TTableInfo;
import org.apache.iotdb.db.exception.metadata.DatabaseNotSetException;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUtil;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.annotations.TableModel;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaInfo.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private final ReentrantReadWriteLock databaseReadWriteLock = new ReentrantReadWriteLock();
    private final ConfigMTree treeModelMTree;
    private final ConfigMTree tableModelMTree;
    private static final String TREE_SNAPSHOT_FILENAME = "cluster_schema.bin";
    private static final String TABLE_SNAPSHOT_FILENAME = "table_cluster_schema.bin";
    private final String ERROR_NAME = "Error Database name";
    private final TemplateTable templateTable;
    private final TemplatePreSetTable templatePreSetTable;

    public ClusterSchemaInfo() throws IOException {
        try {
            this.treeModelMTree = new ConfigMTree(false);
            this.tableModelMTree = new ConfigMTree(true);
            this.templateTable = new TemplateTable();
            this.templatePreSetTable = new TemplatePreSetTable();
        }
        catch (MetadataException e) {
            LOGGER.error("Can't construct ClusterSchemaInfo", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createDatabase(DatabaseSchemaPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            TDatabaseSchema databaseSchema = plan.getSchema();
            PartialPath partialPathName = PartialPath.getQualifiedDatabasePartialPath((String)databaseSchema.getName());
            ConfigMTree mTree = plan.getSchema().isIsTableModel() ? this.tableModelMTree : this.treeModelMTree;
            mTree.setStorageGroup(partialPathName);
            ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(partialPathName).getAsMNode()).setDatabaseSchema(databaseSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterDatabase(DatabaseSchemaPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            TDatabaseSchema alterSchema = plan.getSchema();
            PartialPath partialPathName = PartialPath.getQualifiedDatabasePartialPath((String)alterSchema.getName());
            ConfigMTree mTree = plan.getSchema().isIsTableModel() ? this.tableModelMTree : this.treeModelMTree;
            TDatabaseSchema currentSchema = ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(partialPathName).getAsMNode()).getDatabaseSchema();
            if (alterSchema.isSetMinSchemaRegionGroupNum()) {
                currentSchema.setMinSchemaRegionGroupNum(alterSchema.getMinSchemaRegionGroupNum());
                currentSchema.setMaxSchemaRegionGroupNum(Math.max(currentSchema.getMinSchemaRegionGroupNum(), currentSchema.getMaxSchemaRegionGroupNum()));
                LOGGER.info("[AdjustRegionGroupNum] The minimum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMinSchemaRegionGroupNum());
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMaxSchemaRegionGroupNum());
            }
            if (alterSchema.isSetMinDataRegionGroupNum()) {
                currentSchema.setMinDataRegionGroupNum(alterSchema.getMinDataRegionGroupNum());
                currentSchema.setMaxDataRegionGroupNum(Math.max(currentSchema.getMinDataRegionGroupNum(), currentSchema.getMaxDataRegionGroupNum()));
                LOGGER.info("[AdjustRegionGroupNum] The minimum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMinDataRegionGroupNum());
                LOGGER.info("[AdjustRegionGroupNum] The maximum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getMaxDataRegionGroupNum());
            }
            if (alterSchema.isSetTTL()) {
                currentSchema.setTTL(alterSchema.getTTL());
                LOGGER.info("[SetTTL] The ttl of Database: {} is adjusted to: {}", (Object)currentSchema.getName(), (Object)currentSchema.getTTL());
            }
            ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(partialPathName).getAsMNode()).setDatabaseSchema(currentSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteDatabase(DeleteDatabasePlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            (PathUtils.isTableModelDatabase((String)plan.getName()) ? this.tableModelMTree : this.treeModelMTree).deleteDatabase(PartialPath.getQualifiedDatabasePartialPath((String)plan.getName()));
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.warn("Database not exist", (Throwable)e);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Database not exist: " + e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    public void checkDatabaseLimit() throws MetadataException {
        int limit = COMMON_CONFIG.getDatabaseLimitThreshold();
        if (limit > 0) {
            this.databaseReadWriteLock.readLock().lock();
            try {
                int count = this.treeModelMTree.getDatabaseNum(SchemaConstant.ALL_MATCH_PATTERN, SchemaConstant.ALL_MATCH_SCOPE, false) - this.treeModelMTree.getDatabaseNum(SchemaConstant.SYSTEM_DATABASE_PATTERN, SchemaConstant.ALL_MATCH_SCOPE, false) + this.tableModelMTree.getDatabaseNum(SchemaConstant.ALL_MATCH_PATTERN, SchemaConstant.ALL_MATCH_SCOPE, false);
                if (count >= limit) {
                    throw new SchemaQuotaExceededException((long)limit);
                }
            }
            finally {
                this.databaseReadWriteLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountDatabaseResp countMatchedDatabases(CountDatabasePlan plan) {
        CountDatabaseResp result = new CountDatabaseResp();
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(plan.getDatabasePattern());
            result.setCount((plan.isTableModel() ? this.tableModelMTree : this.treeModelMTree).getDatabaseNum(patternPath, plan.getScope(), false));
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name: " + e.getMessage()));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSchemaResp getMatchedDatabaseSchemas(GetDatabasePlan plan) {
        DatabaseSchemaResp result = new DatabaseSchemaResp();
        this.databaseReadWriteLock.readLock().lock();
        try {
            HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
            PartialPath patternPath = new PartialPath(plan.getDatabasePattern());
            ConfigMTree mTree = plan.isTableModel() ? this.tableModelMTree : this.treeModelMTree;
            List<PartialPath> matchedPaths = mTree.getMatchedDatabases(patternPath, plan.getScope(), false);
            for (PartialPath path : matchedPaths) {
                TDatabaseSchema schema = ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(path).getAsMNode()).getDatabaseSchema();
                schemaMap.put(schema.getName(), schema);
            }
            result.setSchemaMap(schemaMap);
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name: " + e.getMessage()));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            ConfigMTree mTree = PathUtils.isTableModelDatabase((String)plan.getDatabase()) ? this.tableModelMTree : this.treeModelMTree;
            PartialPath path = PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase());
            if (mTree.isDatabaseAlreadySet(path)) {
                ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(path).getAsMNode()).getDatabaseSchema().setSchemaReplicationFactor(plan.getSchemaReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            ConfigMTree mTree = PathUtils.isTableModelDatabase((String)plan.getDatabase()) ? this.tableModelMTree : this.treeModelMTree;
            PartialPath path = PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase());
            if (mTree.isDatabaseAlreadySet(path)) {
                ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(path).getAsMNode()).getDatabaseSchema().setDataReplicationFactor(plan.getDataReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            ConfigMTree mTree = PathUtils.isTableModelDatabase((String)plan.getDatabase()) ? this.tableModelMTree : this.treeModelMTree;
            PartialPath path = PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase());
            if (mTree.isDatabaseAlreadySet(path)) {
                ((IConfigMNode)mTree.getDatabaseNodeByDatabasePath(path).getAsMNode()).getDatabaseSchema().setTimePartitionInterval(plan.getTimePartitionInterval());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error Database name", (Throwable)e);
            result.setCode(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()).setMessage("Error Database name");
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus adjustMaxRegionGroupCount(AdjustMaxRegionGroupNumPlan plan) {
        TSStatus result = new TSStatus();
        this.databaseReadWriteLock.writeLock().lock();
        try {
            for (Map.Entry<String, Pair<Integer, Integer>> entry : plan.getMaxRegionGroupNumMap().entrySet()) {
                TDatabaseSchema databaseSchema = ((IConfigMNode)(PathUtils.isTableModelDatabase((String)entry.getKey()) ? this.tableModelMTree : this.treeModelMTree).getDatabaseNodeByDatabasePath(PartialPath.getQualifiedDatabasePartialPath((String)entry.getKey())).getAsMNode()).getDatabaseSchema();
                databaseSchema.setMaxSchemaRegionGroupNum(((Integer)entry.getValue().getLeft()).intValue());
                databaseSchema.setMaxDataRegionGroupNum(((Integer)entry.getValue().getRight()).intValue());
            }
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.info("Database inconsistency detected when adjusting max region group count, message: {}, will be corrected by the following adjusting plans", (Object)e.getMessage());
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDatabaseNames(Boolean isTableModel) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            ArrayList<String> results = new ArrayList<String>();
            if (!Boolean.TRUE.equals(isTableModel)) {
                this.treeModelMTree.getAllDatabasePaths(isTableModel).stream().map(PartialPath::getFullPath).forEach(results::add);
            }
            if (!Boolean.FALSE.equals(isTableModel)) {
                this.tableModelMTree.getAllDatabasePaths(isTableModel).stream().map(path -> path.getNodes()[1]).forEach(results::add);
            }
            ArrayList<String> arrayList = results;
            return arrayList;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public void isDatabaseNameValid(String databaseName, boolean isTableModel) throws MetadataException {
        this.databaseReadWriteLock.readLock().lock();
        try {
            (isTableModel ? this.tableModelMTree : this.treeModelMTree).checkDatabaseAlreadySet(PartialPath.getQualifiedDatabasePartialPath((String)databaseName));
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public TDatabaseSchema getMatchedDatabaseSchemaByName(String database) throws DatabaseNotExistsException {
        this.databaseReadWriteLock.readLock().lock();
        try {
            TDatabaseSchema tDatabaseSchema = ((IConfigMNode)(PathUtils.isTableModelDatabase((String)database) ? this.tableModelMTree : this.treeModelMTree).getDatabaseNodeByDatabasePath(PartialPath.getQualifiedDatabasePartialPath((String)database)).getAsMNode()).getDatabaseSchema();
            return tDatabaseSchema;
        }
        catch (MetadataException e) {
            throw new DatabaseNotExistsException(database);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByName(List<String> rawPathList, Boolean isTableModel) {
        HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
        this.databaseReadWriteLock.readLock().lock();
        try {
            if (!Boolean.FALSE.equals(isTableModel)) {
                this.enrichSchemaMap(rawPathList, this.tableModelMTree, schemaMap);
            }
            if (!Boolean.TRUE.equals(isTableModel)) {
                this.enrichSchemaMap(rawPathList, this.treeModelMTree, schemaMap);
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    private void enrichSchemaMap(List<String> rawPathList, ConfigMTree mTree, Map<String, TDatabaseSchema> schemaMap) throws MetadataException {
        for (String rawPath : rawPathList) {
            PartialPath patternPath = PartialPath.getQualifiedDatabasePartialPath((String)rawPath);
            List<PartialPath> matchedPaths = mTree.getMatchedDatabases(patternPath, SchemaConstant.ALL_MATCH_SCOPE, false);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), ((IConfigMNode)mTree.getDatabaseNodeByPath(path).getAsMNode()).getDatabaseSchema());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByPrefix(PartialPath prefix) {
        HashMap<String, TDatabaseSchema> schemaMap = new HashMap<String, TDatabaseSchema>();
        this.databaseReadWriteLock.readLock().lock();
        try {
            List<PartialPath> matchedPaths = this.treeModelMTree.getMatchedDatabases(prefix, SchemaConstant.ALL_MATCH_SCOPE, true);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), ((IConfigMNode)this.treeModelMTree.getDatabaseNodeByPath(path).getAsMNode()).getDatabaseSchema());
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TableModel
    public long getDatabaseMaxTTL(String database) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            long l = this.tableModelMTree.getAllTablesUnderSpecificDatabase(PartialPath.getQualifiedDatabasePartialPath((String)database)).stream().map(pair -> ((TsTable)pair.getLeft()).getTableTTL()).reduce(Long::max).orElse(Long.MAX_VALUE);
            return l;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name when trying to get max ttl under one database, use Long.MAX_VALUE.", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            TDatabaseSchema storageGroupSchema = ((IConfigMNode)(PathUtils.isTableModelDatabase((String)database) ? this.tableModelMTree : this.treeModelMTree).getDatabaseNodeByDatabasePath(PartialPath.getQualifiedDatabasePartialPath((String)database)).getAsMNode()).getDatabaseSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMinSchemaRegionGroupNum();
                    return n;
                }
            }
            int n = storageGroupSchema.getMinDataRegionGroupNum();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            TDatabaseSchema storageGroupSchema = ((IConfigMNode)(PathUtils.isTableModelDatabase((String)database) ? this.tableModelMTree : this.treeModelMTree).getDatabaseNodeByDatabasePath(PartialPath.getQualifiedDatabasePartialPath((String)database)).getAsMNode()).getDatabaseSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMaxSchemaRegionGroupNum();
                    return n;
                }
            }
            int n = storageGroupSchema.getMaxDataRegionGroupNum();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error Database name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return this.processMTreeTakeSnapshot(snapshotDir, TREE_SNAPSHOT_FILENAME, this.treeModelMTree) && this.processMTreeTakeSnapshot(snapshotDir, TABLE_SNAPSHOT_FILENAME, this.tableModelMTree) && this.templateTable.processTakeSnapshot(snapshotDir) && this.templatePreSetTable.processTakeSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processMTreeTakeSnapshot(File snapshotDir, String snapshotFileName, ConfigMTree mTree) throws IOException {
        File snapshotFile = new File(snapshotDir, snapshotFileName);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        this.databaseReadWriteLock.readLock().lock();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
            try {
                mTree.serialize(outputStream);
                outputStream.flush();
            }
            finally {
                outputStream.flush();
                fileOutputStream.getFD().sync();
                outputStream.close();
            }
            boolean bl = tmpFile.renameTo(snapshotFile);
            return bl;
        }
        finally {
            for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.processMTreeLoadSnapshot(snapshotDir, TREE_SNAPSHOT_FILENAME, this.treeModelMTree);
        this.processMTreeLoadSnapshot(snapshotDir, TABLE_SNAPSHOT_FILENAME, this.tableModelMTree);
        this.templateTable.processLoadSnapshot(snapshotDir);
        this.templatePreSetTable.processLoadSnapshot(snapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMTreeLoadSnapshot(File snapshotDir, String snapshotFileName, ConfigMTree mTree) throws IOException {
        File snapshotFile = new File(snapshotDir, snapshotFileName);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.databaseReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            mTree.clear();
            mTree.deserialize(bufferedInputStream);
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath partialPath, int level, PathPatternTree scope) {
        Pair<List<PartialPath>, Set<PartialPath>> matchedPathsInNextLevel = new Pair<List<PartialPath>, Set<PartialPath>>(new HashSet(), new HashSet());
        this.databaseReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.treeModelMTree.getNodesListInGivenLevel(partialPath, level, true, scope);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in given level.", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath partialPath, PathPatternTree scope) {
        Pair<Set<TSchemaNode>, Set<PartialPath>> matchedPathsInNextLevel = new Pair<Set<TSchemaNode>, Set<PartialPath>>(new HashSet(), new HashSet());
        this.databaseReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.treeModelMTree.getChildNodePathInNextLevel(partialPath, scope);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in next level.", (Throwable)e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    public TSStatus createSchemaTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        try {
            Template template = createSchemaTemplatePlan.getTemplate();
            this.templateTable.createTemplate(template);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TemplateInfoResp getAllTemplates() {
        TemplateInfoResp result = new TemplateInfoResp();
        List<Template> resp = this.templateTable.getAllTemplate();
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTemplateList(resp);
        return result;
    }

    public TemplateInfoResp getTemplate(GetSchemaTemplatePlan getSchemaTemplatePlan) {
        TemplateInfoResp result = new TemplateInfoResp();
        ArrayList<Template> list = new ArrayList<Template>();
        try {
            String templateName = getSchemaTemplatePlan.getTemplateName();
            if (templateName.equals("*")) {
                list.addAll(this.templateTable.getAllTemplate());
            } else {
                list.add(this.templateTable.getTemplate(templateName));
            }
            result.setTemplateList(list);
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return result;
    }

    public Template getTemplate(int id) throws MetadataException {
        return this.templateTable.getTemplate(id);
    }

    public synchronized TemplateInfoResp checkTemplateSettable(CheckTemplateSettablePlan checkTemplateSettablePlan) {
        PartialPath path;
        TemplateInfoResp resp = new TemplateInfoResp();
        try {
            path = new PartialPath(checkTemplateSettablePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            return resp;
        }
        try {
            this.treeModelMTree.checkTemplateOnPath(path);
            resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
            resp.setTemplateList(Collections.singletonList(this.templateTable.getTemplate(checkTemplateSettablePlan.getName())));
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return resp;
    }

    public synchronized TSStatus setSchemaTemplate(SetSchemaTemplatePlan setSchemaTemplatePlan) {
        PartialPath path;
        try {
            path = new PartialPath(setSchemaTemplatePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        try {
            int templateId = this.templateTable.getTemplate(setSchemaTemplatePlan.getName()).getId();
            this.treeModelMTree.setTemplate(templateId, path);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public synchronized TSStatus preSetSchemaTemplate(PreSetSchemaTemplatePlan preSetSchemaTemplatePlan) {
        PartialPath path;
        try {
            path = new PartialPath(preSetSchemaTemplatePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        try {
            int templateId = this.templateTable.getTemplate(preSetSchemaTemplatePlan.getName()).getId();
            if (preSetSchemaTemplatePlan.isRollback()) {
                this.rollbackPreSetSchemaTemplate(templateId, path);
            } else {
                this.preSetSchemaTemplate(templateId, path);
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    private void preSetSchemaTemplate(int templateId, PartialPath templateSetPath) throws MetadataException {
        this.templatePreSetTable.preSetTemplate(templateId, templateSetPath);
        this.treeModelMTree.setTemplate(templateId, templateSetPath);
    }

    private void rollbackPreSetSchemaTemplate(int templateId, PartialPath templateSetPath) throws MetadataException {
        try {
            this.treeModelMTree.unsetTemplate(templateId, templateSetPath);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        this.templatePreSetTable.removeSetTemplate(templateId, templateSetPath);
    }

    public synchronized TSStatus commitSetSchemaTemplate(CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan) {
        PartialPath path;
        try {
            path = new PartialPath(commitSetSchemaTemplatePlan.getPath());
        }
        catch (IllegalPathException e) {
            LOGGER.error(e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        try {
            int templateId = this.templateTable.getTemplate(commitSetSchemaTemplatePlan.getName()).getId();
            if (commitSetSchemaTemplatePlan.isRollback()) {
                this.rollbackCommitSetSchemaTemplate(templateId, path);
            } else {
                this.commitSetSchemaTemplate(templateId, path);
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    private void commitSetSchemaTemplate(int templateId, PartialPath templateSetPath) {
        this.templatePreSetTable.removeSetTemplate(templateId, templateSetPath);
    }

    private void rollbackCommitSetSchemaTemplate(int templateId, PartialPath templateSetPath) throws MetadataException {
        this.treeModelMTree.unsetTemplate(templateId, templateSetPath);
    }

    public PathInfoResp getPathsSetTemplate(GetPathsSetTemplatePlan getPathsSetTemplatePlan) {
        TSStatus status;
        PathInfoResp pathInfoResp = new PathInfoResp();
        try {
            String templateName = getPathsSetTemplatePlan.getName();
            PathPatternTree scope = getPathsSetTemplatePlan.getScope();
            int templateId = templateName.equals("*") ? -2 : this.templateTable.getTemplate(templateName).getId();
            pathInfoResp.setPathList(this.treeModelMTree.getPathsSetOnTemplate(templateId, scope, false));
            status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            status = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        pathInfoResp.setStatus(status);
        return pathInfoResp;
    }

    public AllTemplateSetInfoResp getAllTemplateSetInfo() {
        List<Template> templateList = this.templateTable.getAllTemplate();
        HashMap templateSetInfo = new HashMap();
        for (Template template : templateList) {
            int id = template.getId();
            try {
                List<String> pathList = this.treeModelMTree.getPathsSetOnTemplate(id, SchemaConstant.ALL_MATCH_SCOPE, true);
                if (pathList.isEmpty()) continue;
                ArrayList<Pair> pathSetInfoList = new ArrayList<Pair>();
                for (String path : pathList) {
                    pathSetInfoList.add(new Pair((Object)path, (Object)this.templatePreSetTable.isPreSet(id, new PartialPath(path))));
                }
                templateSetInfo.put(id, pathSetInfoList);
            }
            catch (MetadataException e) {
                LOGGER.error("Error occurred when get paths set on template {}", (Object)id, (Object)e);
            }
        }
        HashMap<Template, List> templateSetInfoMap = new HashMap<Template, List>();
        for (Template template : templateList) {
            if (!templateSetInfo.containsKey(template.getId())) continue;
            templateSetInfoMap.put(template, (List)templateSetInfo.get(template.getId()));
        }
        return new AllTemplateSetInfoResp(TemplateInternalRPCUtil.generateAddAllTemplateSetInfoBytes(templateSetInfoMap));
    }

    public TemplateSetInfoResp getTemplateSetInfo(GetTemplateSetInfoPlan plan) {
        TemplateSetInfoResp resp = new TemplateSetInfoResp();
        try {
            HashMap allTemplateSetInfo = new HashMap();
            for (PartialPath pattern : plan.getPatternList()) {
                Map<Integer, Set<PartialPath>> templateSetInfo = this.treeModelMTree.getTemplateSetInfo(pattern);
                if (templateSetInfo.isEmpty()) continue;
                templateSetInfo.forEach((templateId, templateSetPathList) -> {
                    for (PartialPath templateSetPath : templateSetPathList) {
                        pattern.alterPrefixPath(templateSetPath).forEach(path -> allTemplateSetInfo.computeIfAbsent(path, k -> new HashSet()).add(templateId));
                    }
                });
            }
            HashMap<PartialPath, List<Template>> result = new HashMap<PartialPath, List<Template>>();
            for (Map.Entry entry : allTemplateSetInfo.entrySet()) {
                ArrayList<Template> templateList = new ArrayList<Template>(((Set)entry.getValue()).size());
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int templateId2 = (Integer)iterator.next();
                    templateList.add(this.templateTable.getTemplate(templateId2));
                }
                result.put((PartialPath)entry.getKey(), templateList);
            }
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            resp.setPatternTemplateMap(result);
            return resp;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            resp.setStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            return resp;
        }
    }

    public TSStatus preUnsetSchemaTemplate(PreUnsetSchemaTemplatePlan plan) {
        try {
            this.treeModelMTree.preUnsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus rollbackUnsetSchemaTemplate(RollbackPreUnsetSchemaTemplatePlan plan) {
        try {
            this.treeModelMTree.rollbackUnsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus unsetSchemaTemplate(UnsetSchemaTemplatePlan plan) {
        try {
            this.treeModelMTree.unsetTemplate(plan.getTemplateId(), plan.getPath());
            return StatusUtils.OK;
        }
        catch (MetadataException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus dropSchemaTemplate(DropSchemaTemplatePlan dropSchemaTemplatePlan) {
        try {
            this.templateTable.dropTemplate(dropSchemaTemplatePlan.getTemplateName());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    public TSStatus extendSchemaTemplate(ExtendSchemaTemplatePlan extendSchemaTemplatePlan) {
        TemplateExtendInfo templateExtendInfo = extendSchemaTemplatePlan.getTemplateExtendInfo();
        try {
            this.templateTable.extendTemplate(templateExtendInfo);
            return RpcUtils.SUCCESS_STATUS;
        }
        catch (MetadataException e) {
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus preCreateTable(PreCreateTablePlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.preCreateTable(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTable());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus rollbackCreateTable(RollbackCreateTablePlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.rollbackCreateTable(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus commitCreateTable(CommitCreateTablePlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.commitCreateTable(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus preDeleteTable(PreDeleteTablePlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.preDeleteTable(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus dropTable(CommitDeleteTablePlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.dropTable(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTableComment(SetTableCommentPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.setTableComment(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getComment());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTableColumnComment(SetTableColumnCommentPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.setTableColumnComment(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getColumnName(), plan.getComment());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShowTableResp showTables(ShowTablePlan plan) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            ShowTableResp showTableResp = new ShowTableResp(StatusUtils.OK, plan.isDetails() ? this.tableModelMTree.getAllTablesUnderSpecificDatabase(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase())).stream().map(pair -> {
                TTableInfo info = new TTableInfo(((TsTable)pair.getLeft()).getTableName(), ((TsTable)pair.getLeft()).getPropValue("ttl").orElse("INF"));
                info.setState(((TableNodeStatus)pair.getRight()).ordinal());
                ((TsTable)pair.getLeft()).getPropValue("__comment").ifPresent(arg_0 -> ((TTableInfo)info).setComment(arg_0));
                return info;
            }).collect(Collectors.toList()) : this.tableModelMTree.getAllUsingTablesUnderSpecificDatabase(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase())).stream().map(tsTable -> new TTableInfo(tsTable.getTableName(), tsTable.getPropValue("ttl").orElse("INF"))).collect(Collectors.toList()));
            return showTableResp;
        }
        catch (MetadataException e) {
            ShowTableResp showTableResp = new ShowTableResp(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()), Collections.emptyList());
            return showTableResp;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public ShowTable4InformationSchemaResp showTables4InformationSchema() {
        this.databaseReadWriteLock.readLock().lock();
        try {
            ShowTable4InformationSchemaResp showTable4InformationSchemaResp = new ShowTable4InformationSchemaResp(StatusUtils.OK, this.tableModelMTree.getAllTables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(pair -> {
                TTableInfo info = new TTableInfo(((TsTable)pair.getLeft()).getTableName(), ((TsTable)pair.getLeft()).getPropValue("ttl").orElse("INF"));
                info.setState(((TableNodeStatus)pair.getRight()).ordinal());
                ((TsTable)pair.getLeft()).getPropValue("__comment").ifPresent(arg_0 -> ((TTableInfo)info).setComment(arg_0));
                return info;
            }).collect(Collectors.toList()))));
            return showTable4InformationSchemaResp;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchTableResp fetchTables(FetchTablePlan plan) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            HashMap<String, Map<String, TsTable>> result = new HashMap<String, Map<String, TsTable>>();
            for (Map.Entry<String, Set<String>> database2Tables : plan.getFetchTableMap().entrySet()) {
                try {
                    result.put(database2Tables.getKey(), this.tableModelMTree.getSpecificTablesUnderSpecificDatabase(PartialPath.getQualifiedDatabasePartialPath((String)database2Tables.getKey()), database2Tables.getValue()));
                }
                catch (DatabaseNotSetException databaseNotSetException) {}
            }
            FetchTableResp fetchTableResp = new FetchTableResp(StatusUtils.OK, result);
            return fetchTableResp;
        }
        catch (MetadataException e) {
            FetchTableResp fetchTableResp = new FetchTableResp(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()), Collections.emptyMap());
            return fetchTableResp;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescTableResp descTable(DescTablePlan plan) {
        this.databaseReadWriteLock.readLock().lock();
        try {
            PartialPath databasePath = PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase());
            if (plan.isDetails()) {
                Pair<TsTable, Set<String>> pair = this.tableModelMTree.getTableSchemaDetails(databasePath, plan.getTableName());
                DescTableResp descTableResp = new DescTableResp(StatusUtils.OK, (TsTable)pair.getLeft(), (Set)pair.getRight());
                return descTableResp;
            }
            DescTableResp descTableResp = new DescTableResp(StatusUtils.OK, this.tableModelMTree.getUsingTableSchema(databasePath, plan.getTableName()), null);
            return descTableResp;
        }
        catch (MetadataException e) {
            DescTableResp descTableResp = new DescTableResp(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()), null, null);
            return descTableResp;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public DescTable4InformationSchemaResp descTable4InformationSchema() {
        this.databaseReadWriteLock.readLock().lock();
        try {
            DescTable4InformationSchemaResp descTable4InformationSchemaResp = new DescTable4InformationSchemaResp(StatusUtils.OK, this.tableModelMTree.getAllDatabasePaths(true).stream().collect(Collectors.toMap(databasePath -> PathUtils.unQualifyDatabaseName((String)databasePath.getFullPath()), databasePath -> {
                try {
                    return this.tableModelMTree.getAllTablesUnderSpecificDatabase((PartialPath)databasePath).stream().map(pair -> {
                        try {
                            return this.tableModelMTree.getTableSchemaDetails((PartialPath)databasePath, ((TsTable)pair.getLeft()).getTableName());
                        }
                        catch (MetadataException metadataException) {
                            return new Pair(null, null);
                        }
                    }).collect(Collectors.toMap(pair -> ((TsTable)pair.getLeft()).getTableName(), pair -> new TTableColumnInfo().setTableInfo(TsTableInternalRPCUtil.serializeSingleTsTable((TsTable)((TsTable)pair.getLeft()))).setPreDeletedColumns((Set)pair.getRight())));
                }
                catch (MetadataException metadataException) {
                    return Collections.emptyMap();
                }
            })));
            return descTable4InformationSchemaResp;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public Map<String, List<TsTable>> getAllUsingTables() {
        this.databaseReadWriteLock.readLock().lock();
        try {
            Map<String, List<TsTable>> map = this.tableModelMTree.getAllUsingTables();
            return map;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    public Map<String, List<TsTable>> getAllPreCreateTables() {
        this.databaseReadWriteLock.readLock().lock();
        try {
            Map<String, List<TsTable>> map = this.tableModelMTree.getAllPreCreateTables();
            return map;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TsTable> getTsTableIfExists(String database, String tableName) throws MetadataException {
        this.databaseReadWriteLock.readLock().lock();
        try {
            Optional<TsTable> optional = this.tableModelMTree.getTableIfExists(PartialPath.getQualifiedDatabasePartialPath((String)database), tableName);
            return optional;
        }
        finally {
            this.databaseReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus addTableColumn(AddTableColumnPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            if (plan.isRollback()) {
                this.tableModelMTree.rollbackAddTableColumn(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getColumnSchemaList());
            } else {
                this.tableModelMTree.addTableColumn(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getColumnSchemaList());
            }
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus renameTableColumn(RenameTableColumnPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.renameTableColumn(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getOldName(), plan.getNewName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTableProperties(SetTablePropertiesPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.setTableProperties(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getProperties());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus preDeleteColumn(PreDeleteColumnPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            if (this.tableModelMTree.preDeleteColumn(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getColumnName())) {
                status.setMessage("");
            }
            TSStatus tSStatus = status;
            return tSStatus;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        catch (SemanticException e) {
            TSStatus tSStatus = RpcUtils.getStatus((int)TSStatusCode.SEMANTIC_ERROR.getStatusCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus commitDeleteColumn(CommitDeleteColumnPlan plan) {
        this.databaseReadWriteLock.writeLock().lock();
        try {
            this.tableModelMTree.commitDeleteColumn(PartialPath.getQualifiedDatabasePartialPath((String)plan.getDatabase()), plan.getTableName(), plan.getColumnName());
            TSStatus tSStatus = RpcUtils.SUCCESS_STATUS;
            return tSStatus;
        }
        catch (MetadataException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            TSStatus tSStatus = RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            return tSStatus;
        }
        finally {
            this.databaseReadWriteLock.writeLock().unlock();
        }
    }

    @TestOnly
    public void clear() {
        this.treeModelMTree.clear();
        this.tableModelMTree.clear();
    }
}

