/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetricsBase;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReferenceCountedObject;

public class MemoryRaftLog
extends RaftLogBase {
    private final EntryList entries = new EntryList();
    private final AtomicReference<RaftStorageMetadata> metadata = new AtomicReference<RaftStorageMetadata>(RaftStorageMetadata.getDefault());
    private final RaftLogMetricsBase metrics;

    public MemoryRaftLog(RaftGroupMemberId memberId, LongSupplier commitIndexSupplier, RaftProperties properties) {
        super(memberId, commitIndexSupplier, properties);
        this.metrics = new RaftLogMetricsBase(memberId);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.metrics.unregister();
    }

    public RaftLogMetricsBase getRaftLogMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProtos.LogEntryProto get(long index) throws RaftLogIOException {
        ReferenceCountedObject<RaftProtos.LogEntryProto> ref = this.retainLog(index);
        try {
            RaftProtos.LogEntryProto logEntryProto = LogProtoUtils.copy((RaftProtos.LogEntryProto)ref.get());
            return logEntryProto;
        }
        finally {
            ref.release();
        }
    }

    public ReferenceCountedObject<RaftProtos.LogEntryProto> retainLog(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            RaftProtos.LogEntryProto entry = this.entries.get(Math.toIntExact(index));
            ReferenceCountedObject ref = ReferenceCountedObject.wrap((Object)entry);
            ref.retain();
            ReferenceCountedObject referenceCountedObject = ref;
            return referenceCountedObject;
        }
    }

    public RaftLog.EntryWithData getEntryWithData(long index) throws RaftLogIOException {
        throw new UnsupportedOperationException("Use retainEntryWithData(" + index + ") instead.");
    }

    public ReferenceCountedObject<RaftLog.EntryWithData> retainEntryWithData(long index) {
        ReferenceCountedObject<RaftProtos.LogEntryProto> ref = this.retainLog(index);
        return this.newEntryWithData(ref);
    }

    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(Math.toIntExact(index));
            return termIndex;
        }
    }

    public LogEntryHeader[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            if (startIndex >= (long)this.entries.size()) {
                LogEntryHeader[] logEntryHeaderArray = null;
                return logEntryHeaderArray;
            }
            int from = Math.toIntExact(startIndex);
            int to = Math.toIntExact(Math.min((long)this.entries.size(), endIndex));
            LogEntryHeader[] headers = new LogEntryHeader[to - from];
            for (int i = 0; i < headers.length; ++i) {
                headers[i] = this.entries.getLogEntryHeader(i);
            }
            LogEntryHeader[] logEntryHeaderArray = headers;
            return logEntryHeaderArray;
        }
    }

    @Override
    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            this.entries.truncate(Math.toIntExact(index));
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            this.entries.purge(Math.toIntExact(index));
        }
        return CompletableFuture.completedFuture(index);
    }

    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.entries.getTermIndex(this.entries.size() - 1);
            return termIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Long> appendEntryImpl(ReferenceCountedObject<RaftProtos.LogEntryProto> entryRef, TransactionContext context) {
        this.checkLogState();
        RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)entryRef.retain();
        try (AutoCloseableLock writeLock = this.writeLock();){
            this.validateLogEntry(entry);
            this.entries.add(entry);
        }
        finally {
            entryRef.release();
        }
        return CompletableFuture.completedFuture(entry.getIndex());
    }

    public long getStartIndex() {
        return this.entries.size() == 0 ? -1L : this.entries.getTermIndex(0).getIndex();
    }

    /*
     * Loose catch block
     */
    @Override
    public List<CompletableFuture<Long>> appendImpl(ReferenceCountedObject<List<RaftProtos.LogEntryProto>> entriesRef) {
        this.checkLogState();
        List logEntryProtos = (List)entriesRef.retain();
        if (logEntryProtos == null || logEntryProtos.isEmpty()) {
            entriesRef.release();
            return Collections.emptyList();
        }
        try {
            try (AutoCloseableLock writeLock = this.writeLock();){
                ArrayList<CompletableFuture<Long>> futures;
                boolean toTruncate = false;
                int truncateIndex = (int)((RaftProtos.LogEntryProto)logEntryProtos.get(0)).getIndex();
                int index = 0;
                while ((long)truncateIndex < this.getNextIndex() && index < logEntryProtos.size()) {
                    if (this.entries.get(truncateIndex).getTerm() != ((RaftProtos.LogEntryProto)logEntryProtos.get(index)).getTerm()) {
                        toTruncate = true;
                        break;
                    }
                    ++index;
                    ++truncateIndex;
                }
                if (toTruncate) {
                    futures = new ArrayList(logEntryProtos.size() - index + 1);
                    futures.add(this.truncate(truncateIndex));
                } else {
                    futures = new ArrayList<CompletableFuture<Long>>(logEntryProtos.size() - index);
                }
                for (int i = index; i < logEntryProtos.size(); ++i) {
                    RaftProtos.LogEntryProto logEntryProto = (RaftProtos.LogEntryProto)logEntryProtos.get(i);
                    this.entries.add(LogProtoUtils.copy(logEntryProto));
                    futures.add(CompletableFuture.completedFuture(logEntryProto.getIndex()));
                }
                ArrayList<CompletableFuture<Long>> arrayList = futures;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            entriesRef.release();
        }
    }

    public String getEntryString() {
        return "entries=" + this.entries;
    }

    public long getFlushIndex() {
        return this.getNextIndex() - 1L;
    }

    public void persistMetadata(RaftStorageMetadata newMetadata) {
        this.metadata.set(newMetadata);
    }

    public RaftStorageMetadata loadMetadata() {
        return this.metadata.get();
    }

    public CompletableFuture<Long> onSnapshotInstalled(long lastSnapshotIndex) {
        return CompletableFuture.completedFuture(lastSnapshotIndex);
    }

    static class EntryList {
        private final List<RaftProtos.LogEntryProto> entries = new ArrayList<RaftProtos.LogEntryProto>();

        EntryList() {
        }

        RaftProtos.LogEntryProto get(int i) {
            return i >= 0 && i < this.entries.size() ? this.entries.get(i) : null;
        }

        TermIndex getTermIndex(int i) {
            return TermIndex.valueOf((RaftProtos.LogEntryProto)this.get(i));
        }

        private LogEntryHeader getLogEntryHeader(int i) {
            return LogEntryHeader.valueOf((RaftProtos.LogEntryProto)this.get(i));
        }

        int size() {
            return this.entries.size();
        }

        void truncate(int index) {
            if (this.entries.size() > index) {
                this.clear(index, this.entries.size());
            }
        }

        void purge(int index) {
            if (this.entries.size() > index) {
                this.clear(0, index);
            }
        }

        void clear(int from, int to) {
            this.entries.subList(from, to).clear();
        }

        void add(RaftProtos.LogEntryProto entryRef) {
            this.entries.add(entryRef);
        }
    }
}

