/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.metric;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeConnector;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;

public class PipeConsensusSyncLagManager {
    long syncLag = Long.MIN_VALUE;
    ReentrantLock lock = new ReentrantLock();
    Map<ConsensusPipeName, ConsensusPipeConnector> consensusPipe2ConnectorMap = new ConcurrentHashMap<ConsensusPipeName, ConsensusPipeConnector>();

    public long getSyncLagForRegionMigration(ConsensusPipeName consensusPipeName, long pinnedCommitIndex) {
        return Optional.ofNullable(this.consensusPipe2ConnectorMap.get(consensusPipeName)).map(consensusPipeConnector -> Math.max(pinnedCommitIndex - consensusPipeConnector.getConsensusPipeReplicateProgress(), 0L)).orElse(0L);
    }

    public long getSyncLagForSpecificConsensusPipe(ConsensusPipeName consensusPipeName) {
        return Optional.ofNullable(this.consensusPipe2ConnectorMap.get(consensusPipeName)).map(consensusPipeConnector -> {
            long userWriteProgress = consensusPipeConnector.getConsensusPipeCommitProgress();
            long replicateProgress = consensusPipeConnector.getConsensusPipeReplicateProgress();
            return Math.max(userWriteProgress - replicateProgress, 0L);
        }).orElse(0L);
    }

    public long getCurrentCommitIndex(ConsensusPipeName consensusPipeName) {
        return Optional.ofNullable(this.consensusPipe2ConnectorMap.get(consensusPipeName)).map(ConsensusPipeConnector::getConsensusPipeCommitProgress).orElse(0L);
    }

    public void addConsensusPipeConnector(ConsensusPipeName consensusPipeName, ConsensusPipeConnector consensusPipeConnector) {
        this.lock.lock();
        try {
            this.consensusPipe2ConnectorMap.put(consensusPipeName, consensusPipeConnector);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeConsensusPipeConnector(ConsensusPipeName consensusPipeName) {
        this.lock.lock();
        try {
            this.consensusPipe2ConnectorMap.remove(consensusPipeName);
        }
        finally {
            this.lock.unlock();
        }
    }

    public long calculateSyncLag() {
        this.lock.lock();
        try {
            if (this.consensusPipe2ConnectorMap.isEmpty()) {
                long l = 0L;
                return l;
            }
            this.syncLag = Long.MIN_VALUE;
            this.consensusPipe2ConnectorMap.keySet().forEach(consensusPipeName -> {
                this.syncLag = Math.max(this.syncLag, this.getSyncLagForSpecificConsensusPipe((ConsensusPipeName)consensusPipeName));
            });
            long l = this.syncLag;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.consensusPipe2ConnectorMap.clear();
    }

    private PipeConsensusSyncLagManager() {
    }

    public static PipeConsensusSyncLagManager getInstance(String groupId) {
        return PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.computeIfAbsent(groupId, key -> new PipeConsensusSyncLagManager());
    }

    public static void release(String groupId) {
        PipeConsensusSyncLagManager.getInstance(groupId).clear();
        PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.remove(groupId);
    }

    public static void build() {
        PipeConsensusSyncLagManagerHolder.build();
    }

    private static class PipeConsensusSyncLagManagerHolder {
        private static Map<String, PipeConsensusSyncLagManager> CONSENSU_GROUP_ID_2_INSTANCE_MAP;

        private PipeConsensusSyncLagManagerHolder() {
        }

        private static void build() {
            if (CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
                CONSENSU_GROUP_ID_2_INSTANCE_MAP = new ConcurrentHashMap<String, PipeConsensusSyncLagManager>();
            }
        }
    }
}

