/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.models;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import opennlp.tools.models.ClassPathModel;
import opennlp.tools.models.ClassPathModelEntry;

public class ClassPathModelLoader {
    public ClassPathModel load(ClassPathModelEntry entry) throws IOException {
        byte[] model;
        Objects.requireNonNull(entry, "entry must not be null");
        Objects.requireNonNull(entry.properties(), "entry.properties() must not be null");
        Objects.requireNonNull(entry.model(), "entry.model() must not be null");
        Properties properties = new Properties();
        if (entry.properties().isPresent()) {
            try (InputStream inputStream = entry.properties().get().toURL().openStream();){
                properties.load(inputStream);
            }
        }
        try (InputStream inputStream = entry.model().toURL().openStream();){
            model = inputStream.readAllBytes();
        }
        return new ClassPathModel(properties, model);
    }
}

