/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;

public class EntryAndMetadata
implements Entry {
    private final Entry entry;
    @Nullable
    private final MessageMetadata metadata;

    private EntryAndMetadata(Entry entry, @Nullable MessageMetadata metadata) {
        this.entry = entry;
        this.metadata = metadata;
    }

    public static EntryAndMetadata create(Entry entry, MessageMetadata metadata) {
        return new EntryAndMetadata(entry, metadata);
    }

    @VisibleForTesting
    static EntryAndMetadata create(Entry entry) {
        return EntryAndMetadata.create(entry, Commands.peekAndCopyMessageMetadata((ByteBuf)entry.getDataBuffer(), (String)"", (long)-1L));
    }

    public byte[] getStickyKey() {
        if (this.metadata != null) {
            if (this.metadata.hasOrderingKey()) {
                return this.metadata.getOrderingKey();
            }
            if (this.metadata.hasPartitionKey()) {
                return this.metadata.getPartitionKey().getBytes(StandardCharsets.UTF_8);
            }
        }
        return "NONE_KEY".getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        String s = this.entry.getLedgerId() + ":" + this.entry.getEntryId();
        if (this.metadata != null) {
            s = s + "@" + this.metadata.getProducerName() + "-" + this.metadata.getSequenceId();
            if (this.metadata.hasChunkId() && this.metadata.hasNumChunksFromMsg()) {
                s = s + "-" + this.metadata.getChunkId() + "-" + this.metadata.getNumChunksFromMsg();
            }
        }
        return s;
    }

    public byte[] getData() {
        return this.entry.getData();
    }

    public byte[] getDataAndRelease() {
        return this.entry.getDataAndRelease();
    }

    public int getLength() {
        return this.entry.getLength();
    }

    public ByteBuf getDataBuffer() {
        return this.entry.getDataBuffer();
    }

    public Position getPosition() {
        return this.entry.getPosition();
    }

    public long getLedgerId() {
        return this.entry.getLedgerId();
    }

    public long getEntryId() {
        return this.entry.getEntryId();
    }

    public boolean release() {
        return this.entry.release();
    }

    @Nullable
    @Generated
    public MessageMetadata getMetadata() {
        return this.metadata;
    }
}

