/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.testclient.CmdBase;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PositiveNumberParameterConvert;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="managed-ledger", description={"Write directly on managed-ledgers"})
public class ManagedLedgerWriter
extends CmdBase {
    private static final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("pulsar-perf-managed-ledger-exec"));
    private static final LongAdder messagesSent = new LongAdder();
    private static final LongAdder bytesSent = new LongAdder();
    private static final LongAdder totalMessagesSent = new LongAdder();
    private static final LongAdder totalBytesSent = new LongAdder();
    private static Recorder recorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    private static Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    @CommandLine.Option(names={"-r", "--rate"}, description={"Write rate msg/s across managed ledgers"})
    public int msgRate = 100;
    @CommandLine.Option(names={"-s", "--size"}, description={"Message size"})
    public int msgSize = 1024;
    @CommandLine.Option(names={"-t", "--num-topic"}, description={"Number of managed ledgers"}, converter={PositiveNumberParameterConvert.class})
    public int numManagedLedgers = 1;
    @CommandLine.Option(names={"--threads"}, description={"Number of threads writing"}, converter={PositiveNumberParameterConvert.class})
    public int numThreads = 1;
    @Deprecated
    @CommandLine.Option(names={"-zk", "--zookeeperServers"}, description={"ZooKeeper connection string"}, hidden=true)
    public String zookeeperServers;
    @CommandLine.Option(names={"-md", "--metadata-store"}, description={"Metadata store service URL. For example: zk:my-zk:2181"})
    private String metadataStoreUrl;
    @CommandLine.Option(names={"-o", "--max-outstanding"}, description={"Max number of outstanding requests"})
    public int maxOutstanding = 1000;
    @CommandLine.Option(names={"-c", "--max-connections"}, description={"Max number of TCP connections to a single bookie"})
    public int maxConnections = 1;
    @CommandLine.Option(names={"-m", "--num-messages"}, description={"Number of messages to publish in total. If <= 0, it will keep publishing"})
    public long numMessages = 0L;
    @CommandLine.Option(names={"-e", "--ensemble-size"}, description={"Ledger ensemble size"})
    public int ensembleSize = 1;
    @CommandLine.Option(names={"-w", "--write-quorum"}, description={"Ledger write quorum"})
    public int writeQuorum = 1;
    @CommandLine.Option(names={"-a", "--ack-quorum"}, description={"Ledger ack quorum"})
    public int ackQuorum = 1;
    @CommandLine.Option(names={"-dt", "--digest-type"}, description={"BookKeeper digest type"})
    public DigestType digestType = DigestType.CRC32C;
    @CommandLine.Option(names={"-time", "--test-duration"}, description={"Test duration in secs. If <= 0, it will keep publishing"})
    public long testTime = 0L;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    static final DecimalFormat THROUGHPUTFORMAT = new PaddingDecimalFormat("0.0", 8);
    static final DecimalFormat DEC = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat TOTALFORMAT = new DecimalFormat("0.000");
    static final DecimalFormat INTFORMAT = new PaddingDecimalFormat("0", 7);
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerWriter.class);

    public ManagedLedgerWriter() {
        super("managed-ledger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        CommandLine commander = this.spec.commandLine();
        if (this.metadataStoreUrl == null && this.zookeeperServers == null) {
            System.err.println("Metadata store address argument is required (--metadata-store)");
            commander.usage(commander.getOut());
            PerfClientUtils.exit(1);
        }
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar managed-ledger perf writer with config: {}", (Object)w.writeValueAsString((Object)this));
        final byte[] payloadData = new byte[this.msgSize];
        ByteBuf payloadBuffer = PulsarByteBufAllocator.DEFAULT.directBuffer(this.msgSize);
        payloadBuffer.writerIndex(this.msgSize);
        String managedLedgerPrefix = "test-" + DigestUtils.sha1Hex((String)UUID.randomUUID().toString()).substring(0, 5);
        if (this.metadataStoreUrl == null) {
            this.metadataStoreUrl = this.zookeeperServers;
        }
        ClientConfiguration bkConf = new ClientConfiguration();
        bkConf.setUseV2WireProtocol(true);
        bkConf.setAddEntryTimeout(30);
        bkConf.setReadEntryTimeout(30);
        bkConf.setThrottleValue(0);
        bkConf.setNumChannelsPerBookie(this.maxConnections);
        bkConf.setMetadataServiceUri(this.metadataStoreUrl);
        ManagedLedgerFactoryConfig mlFactoryConf = new ManagedLedgerFactoryConfig();
        mlFactoryConf.setMaxCacheSize(0L);
        MetadataStoreExtended metadataStore = MetadataStoreExtended.create((String)this.metadataStoreUrl, (MetadataStoreConfig)MetadataStoreConfig.builder().metadataStoreName("metadata-store").build());
        try {
            ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl(metadataStore, bkConf, mlFactoryConf);
            ManagedLedgerConfig mlConf = new ManagedLedgerConfig();
            mlConf.setEnsembleSize(this.ensembleSize);
            mlConf.setWriteQuorumSize(this.writeQuorum);
            mlConf.setAckQuorumSize(this.ackQuorum);
            mlConf.setMinimumRolloverTime(10, TimeUnit.MINUTES);
            mlConf.setMetadataEnsembleSize(this.ensembleSize);
            mlConf.setMetadataWriteQuorumSize(this.writeQuorum);
            mlConf.setMetadataAckQuorumSize(this.ackQuorum);
            mlConf.setDigestType(this.digestType);
            mlConf.setMaxSizePerLedgerMb(2048);
            ArrayList futures = new ArrayList();
            for (int i = 0; i < this.numManagedLedgers; ++i) {
                String name = String.format("%s-%03d", managedLedgerPrefix, i);
                final CompletableFuture future = new CompletableFuture();
                futures.add(future);
                factory.asyncOpen(name, mlConf, new AsyncCallbacks.OpenLedgerCallback(){

                    public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                        future.complete(ledger);
                    }

                    public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                        future.completeExceptionally((Throwable)exception);
                    }
                }, null, null);
            }
            List managedLedgers = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
            log.info("Created {} managed ledgers", (Object)managedLedgers.size());
            long start = System.nanoTime();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                ManagedLedgerWriter.printAggregatedThroughput(start);
                ManagedLedgerWriter.printAggregatedStats();
            }));
            Collections.shuffle(managedLedgers);
            AtomicBoolean isDone = new AtomicBoolean();
            Map managedLedgersPerThread = ManagedLedgerWriter.allocateToThreads(managedLedgers, this.numThreads);
            for (int i = 0; i < this.numThreads; ++i) {
                List managedLedgersForThisThread = managedLedgersPerThread.get(i);
                int nunManagedLedgersForThisThread = managedLedgersForThisThread.size();
                long numMessagesForThisThread = this.numMessages / (long)this.numThreads;
                int maxOutstandingForThisThread = this.maxOutstanding;
                executor.submit(() -> {
                    try {
                        double msgRate = (double)this.msgRate / (double)this.numThreads;
                        RateLimiter rateLimiter = RateLimiter.create((double)msgRate);
                        rateLimiter.acquire((int)msgRate);
                        long startTime = System.nanoTime();
                        long testEndTime = startTime + (long)((double)this.testTime * 1.0E9);
                        final Semaphore semaphore = new Semaphore(maxOutstandingForThisThread);
                        AsyncCallbacks.AddEntryCallback addEntryCallback = new AsyncCallbacks.AddEntryCallback(){

                            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                                long sendTime = (Long)ctx;
                                messagesSent.increment();
                                bytesSent.add(payloadData.length);
                                totalMessagesSent.increment();
                                totalBytesSent.add(payloadData.length);
                                long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                                recorder.recordValue(latencyMicros);
                                cumulativeRecorder.recordValue(latencyMicros);
                                semaphore.release();
                            }

                            public void addFailed(ManagedLedgerException exception, Object ctx) {
                                log.warn("Write error on message", (Throwable)exception);
                                PerfClientUtils.exit(1);
                            }
                        };
                        long totalSent = 0L;
                        block2: while (true) {
                            int j = 0;
                            while (true) {
                                if (j >= nunManagedLedgersForThisThread) continue block2;
                                if (this.testTime > 0L && System.nanoTime() > testEndTime) {
                                    log.info("------------- DONE (reached the maximum duration: [{} seconds] of production) --------------", (Object)this.testTime);
                                    isDone.set(true);
                                    Thread.sleep(5000L);
                                    PerfClientUtils.exit(0);
                                }
                                if (numMessagesForThisThread > 0L && totalSent++ >= numMessagesForThisThread) {
                                    log.info("------------- DONE (reached the maximum number: [{}] of production) --------------", (Object)numMessagesForThisThread);
                                    isDone.set(true);
                                    Thread.sleep(5000L);
                                    PerfClientUtils.exit(0);
                                }
                                semaphore.acquire();
                                rateLimiter.acquire();
                                long sendTime = System.nanoTime();
                                ((ManagedLedger)managedLedgersForThisThread.get(j)).asyncAddEntry(payloadBuffer, addEntryCallback, (Object)sendTime);
                                ++j;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        log.error("Got error", t);
                        return;
                    }
                });
            }
            long oldTime = System.nanoTime();
            Histogram reportHistogram = null;
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (isDone.get()) break;
                long now = System.nanoTime();
                double elapsed = (double)(now - oldTime) / 1.0E9;
                long total = totalMessagesSent.sum();
                double rate = (double)messagesSent.sumThenReset() / elapsed;
                double throughput = (double)bytesSent.sumThenReset() / elapsed / 1024.0 / 1024.0 * 8.0;
                reportHistogram = recorder.getIntervalHistogram(reportHistogram);
                log.info("Throughput produced: {} msg --- {}  msg/s --- {} Mbit/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{INTFORMAT.format(total), THROUGHPUTFORMAT.format(rate), THROUGHPUTFORMAT.format(throughput), DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
                reportHistogram.reset();
                oldTime = now;
            }
            factory.shutdown();
        }
        finally {
            if (Collections.singletonList(metadataStore).get(0) != null) {
                metadataStore.close();
            }
        }
    }

    public static <T> Map<Integer, List<T>> allocateToThreads(List<T> managedLedgers, int numThreads) {
        HashMap<Integer, List<T>> map = new HashMap<Integer, List<T>>();
        if (managedLedgers.size() >= numThreads) {
            int threadIndex = 0;
            for (T managedLedger : managedLedgers) {
                List ledgerList = map.getOrDefault(threadIndex, new ArrayList());
                ledgerList.add(managedLedger);
                map.put(threadIndex, ledgerList);
                if (++threadIndex < numThreads) continue;
                threadIndex %= numThreads;
            }
        } else {
            int ledgerIndex = 0;
            for (int threadIndex = 0; threadIndex < numThreads; ++threadIndex) {
                List ledgerList = map.getOrDefault(threadIndex, new ArrayList());
                ledgerList.add(managedLedgers.get(ledgerIndex));
                map.put(threadIndex, ledgerList);
                if (++ledgerIndex < managedLedgers.size()) continue;
                ledgerIndex %= managedLedgers.size();
            }
        }
        return map;
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesSent.sum() / elapsed;
        double throughput = (double)totalBytesSent.sum() / elapsed / 1024.0 / 1024.0 * 8.0;
        log.info("Aggregated throughput stats --- {} records sent --- {} msg/s --- {} Mbit/s", new Object[]{totalMessagesSent, TOTALFORMAT.format(rate), TOTALFORMAT.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
    }
}

