/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Range;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.testclient.IMessageFormatter;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceTopicListArguments;
import org.apache.pulsar.testclient.PositiveNumberParameterConvert;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="produce", description={"Test pulsar producer performance."})
public class PerformanceProducer
extends PerformanceTopicListArguments {
    private static final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("pulsar-perf-producer-exec"));
    private static final LongAdder messagesSent = new LongAdder();
    private static final LongAdder messagesFailed = new LongAdder();
    private static final LongAdder bytesSent = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnSuccess = new LongAdder();
    private static final LongAdder totalMessagesSent = new LongAdder();
    private static final LongAdder totalBytesSent = new LongAdder();
    private static final Recorder recorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final LongAdder totalEndTxnOpSuccessNum = new LongAdder();
    private static final LongAdder totalEndTxnOpFailNum = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static IMessageFormatter messageFormatter = null;
    @CommandLine.Option(names={"-threads", "--num-test-threads"}, description={"Number of test threads"}, converter={PositiveNumberParameterConvert.class})
    public int numTestThreads = 1;
    @CommandLine.Option(names={"-r", "--rate"}, description={"Publish rate msg/s across topics"})
    public int msgRate = 100;
    @CommandLine.Option(names={"-s", "--size"}, description={"Message size (bytes)"})
    public int msgSize = 1024;
    @CommandLine.Option(names={"-n", "--num-producers"}, description={"Number of producers (per topic)"}, converter={PositiveNumberParameterConvert.class})
    public int numProducers = 1;
    @CommandLine.Option(names={"--separator"}, description={"Separator between the topic and topic number"})
    public String separator = "-";
    @CommandLine.Option(names={"--send-timeout"}, description={"Set the sendTimeout value default 0 to keep compatibility with previous version of pulsar-perf"})
    public int sendTimeout = 0;
    @CommandLine.Option(names={"-pn", "--producer-name"}, description={"Producer Name"})
    public String producerName = null;
    @CommandLine.Option(names={"-au", "--admin-url"}, description={"Pulsar Admin URL"}, descriptionKey="webServiceUrl")
    public String adminURL;
    @CommandLine.Option(names={"-ch", "--chunking"}, description={"Should split the message and publish in chunks if message size is larger than allowed max size"})
    private boolean chunkingAllowed = false;
    @CommandLine.Option(names={"-o", "--max-outstanding"}, description={"Max number of outstanding messages"})
    public int maxOutstanding = 0;
    @CommandLine.Option(names={"-p", "--max-outstanding-across-partitions"}, description={"Max number of outstanding messages across partitions"})
    public int maxPendingMessagesAcrossPartitions = 0;
    @CommandLine.Option(names={"-np", "--partitions"}, description={"Create partitioned topics with the given number of partitions, set 0 to not try to create the topic"})
    public Integer partitions = null;
    @CommandLine.Option(names={"-m", "--num-messages"}, description={"Number of messages to publish in total. If <= 0, it will keep publishing"})
    public long numMessages = 0L;
    @CommandLine.Option(names={"-z", "--compression"}, description={"Compress messages payload"})
    public CompressionType compression = CompressionType.NONE;
    @CommandLine.Option(names={"-f", "--payload-file"}, description={"Use payload from an UTF-8 encoded text file and a payload will be randomly selected when publishing messages"})
    public String payloadFilename = null;
    @CommandLine.Option(names={"-e", "--payload-delimiter"}, description={"The delimiter used to split lines when using payload from a file"})
    public String payloadDelimiter = "\\n";
    @CommandLine.Option(names={"-b", "--batch-time-window"}, description={"Batch messages in 'x' ms window (Default: 1ms)"})
    public double batchTimeMillis = 1.0;
    @CommandLine.Option(names={"-db", "--disable-batching"}, description={"Disable batching if true"})
    public boolean disableBatching;
    @CommandLine.Option(names={"-bm", "--batch-max-messages"}, description={"Maximum number of messages per batch"})
    public int batchMaxMessages = 1000;
    @CommandLine.Option(names={"-bb", "--batch-max-bytes"}, description={"Maximum number of bytes per batch"})
    public int batchMaxBytes = 0x400000;
    @CommandLine.Option(names={"-time", "--test-duration"}, description={"Test duration in secs. If <= 0, it will keep publishing"})
    public long testTime = 0L;
    @CommandLine.Option(names={"--warmup-time"}, description={"Warm-up time in seconds (Default: 1 sec)"})
    public double warmupTimeSeconds = 1.0;
    @CommandLine.Option(names={"-k", "--encryption-key-name"}, description={"The public key name to encrypt payload"})
    public String encKeyName = null;
    @CommandLine.Option(names={"-v", "--encryption-key-value-file"}, description={"The file which contains the public key to encrypt payload"})
    public String encKeyFile = null;
    @CommandLine.Option(names={"-d", "--delay"}, description={"Mark messages with a given delay in seconds"})
    public long delay = 0L;
    @CommandLine.Option(names={"-dr", "--delay-range"}, description={"Mark messages with a given delay by a random number of seconds. this value between the specified origin (inclusive) and the specified bound (exclusive). e.g. 1,300"}, converter={RangeConvert.class})
    public Range<Long> delayRange = null;
    @CommandLine.Option(names={"-set", "--set-event-time"}, description={"Set the eventTime on messages"})
    public boolean setEventTime = false;
    @CommandLine.Option(names={"-ef", "--exit-on-failure"}, description={"Exit from the process on publish failure (default: disable)"})
    public boolean exitOnFailure = false;
    @CommandLine.Option(names={"-mk", "--message-key-generation-mode"}, description={"The generation mode of message key, valid options are: [autoIncrement, random]"}, descriptionKey="messageKeyGenerationMode")
    public String messageKeyGenerationMode = null;
    @CommandLine.Option(names={"-am", "--access-mode"}, description={"Producer access mode"})
    public ProducerAccessMode producerAccessMode = ProducerAccessMode.Shared;
    @CommandLine.Option(names={"-fp", "--format-payload"}, description={"Format %%i as a message index in the stream from producer and/or %%t as the timestamp nanoseconds."})
    public boolean formatPayload = false;
    @CommandLine.Option(names={"-fc", "--format-class"}, description={"Custom Formatter class name"})
    public String formatterClass = "org.apache.pulsar.testclient.DefaultMessageFormatter";
    @CommandLine.Option(names={"-tto", "--txn-timeout"}, description={"Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)"})
    public long transactionTimeout = 10L;
    @CommandLine.Option(names={"-nmt", "--numMessage-perTransaction"}, description={"The number of messages sent by a transaction. (After --txn-enable setting to true, -nmt takes effect)"})
    public int numMessagesPerTransaction = 50;
    @CommandLine.Option(names={"-txn", "--txn-enable"}, description={"Enable or disable the transaction"})
    public boolean isEnableTransaction = false;
    @CommandLine.Option(names={"-abort"}, description={"Abort the transaction. (After --txn-enable setting to true, -abort takes effect)"})
    public boolean isAbortTransaction = false;
    @CommandLine.Option(names={"--histogram-file"}, description={"HdrHistogram output file"})
    public String histogramFile = null;
    static final DecimalFormat THROUGHPUTFORMAT = new PaddingDecimalFormat("0.0", 8);
    static final DecimalFormat DEC = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat INTFORMAT = new PaddingDecimalFormat("0", 7);
    static final DecimalFormat TOTALFORMAT = new DecimalFormat("0.000");
    private static final Logger log = LoggerFactory.getLogger(PerformanceProducer.class);

    @Override
    public void run() throws Exception {
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar perf producer with config: {}", (Object)w.writeValueAsString((Object)this));
        byte[] payloadBytes = new byte[this.msgSize];
        Random random = new Random(0L);
        ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
        if (this.payloadFilename != null) {
            Path payloadFilePath = Paths.get(this.payloadFilename, new String[0]);
            if (Files.notExists(payloadFilePath, new LinkOption[0]) || Files.size(payloadFilePath) == 0L) {
                throw new IllegalArgumentException("Payload file doesn't exist or it is empty.");
            }
            String delimiter = this.payloadDelimiter.equals("\\n") ? "\n" : this.payloadDelimiter;
            String[] payloadList = new String(Files.readAllBytes(payloadFilePath), StandardCharsets.UTF_8).split(delimiter);
            log.info("Reading payloads from {} and {} records read", (Object)payloadFilePath.toAbsolutePath(), (Object)payloadList.length);
            for (String payload : payloadList) {
                payloadByteList.add(payload.getBytes(StandardCharsets.UTF_8));
            }
            if (this.formatPayload) {
                messageFormatter = PerformanceProducer.getMessageFormatter(this.formatterClass);
            }
        } else {
            for (int i = 0; i < payloadBytes.length; ++i) {
                payloadBytes[i] = (byte)(random.nextInt(26) + 65);
            }
        }
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceProducer.executorShutdownNow();
            this.printAggregatedThroughput(start);
            PerformanceProducer.printAggregatedStats();
        }));
        if (this.partitions != null) {
            PulsarAdminBuilder adminBuilder = PerfClientUtils.createAdminBuilderFromArguments(this, this.adminURL);
            try (PulsarAdmin adminClient = adminBuilder.build();){
                for (String topic : this.topics) {
                    log.info("Creating partitioned topic {} with {} partitions", (Object)topic, (Object)this.partitions);
                    try {
                        adminClient.topics().createPartitionedTopic(topic, this.partitions.intValue());
                    }
                    catch (PulsarAdminException.ConflictException alreadyExists) {
                        if (log.isDebugEnabled()) {
                            log.debug("Topic {} already exists: {}", (Object)topic, (Object)alreadyExists);
                        }
                        PartitionedTopicMetadata partitionedTopicMetadata = adminClient.topics().getPartitionedTopicMetadata(topic);
                        if (partitionedTopicMetadata.partitions == this.partitions) continue;
                        log.error("Topic {} already exists but it has a wrong number of partitions: {}, expecting {}", new Object[]{topic, partitionedTopicMetadata.partitions, this.partitions});
                        PerfClientUtils.exit(1);
                    }
                }
            }
        }
        CountDownLatch doneLatch = new CountDownLatch(this.numTestThreads);
        long numMessagesPerThread = this.numMessages / (long)this.numTestThreads;
        int msgRatePerThread = this.msgRate / this.numTestThreads;
        int i = 0;
        while (i < this.numTestThreads) {
            int threadIdx = i++;
            executor.submit(() -> {
                log.info("Started performance test thread {}", (Object)threadIdx);
                this.runProducer(threadIdx, this, numMessagesPerThread, msgRatePerThread, payloadByteList, payloadBytes, doneLatch);
            });
        }
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        HistogramLogWriter histogramLogWriter = null;
        if (this.histogramFile != null) {
            String statsFileName = this.histogramFile;
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
        }
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (doneLatch.getCount() <= 0L) break;
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesSent.sum();
            long totalTxnOpSuccess = 0L;
            long totalTxnOpFail = 0L;
            double rateOpenTxn = 0.0;
            double rate = (double)messagesSent.sumThenReset() / elapsed;
            double failureRate = (double)messagesFailed.sumThenReset() / elapsed;
            double throughput = (double)bytesSent.sumThenReset() / elapsed / 1024.0 / 1024.0 * 8.0;
            reportHistogram = recorder.getIntervalHistogram(reportHistogram);
            if (this.isEnableTransaction) {
                totalTxnOpSuccess = totalEndTxnOpSuccessNum.sum();
                totalTxnOpFail = totalEndTxnOpFailNum.sum();
                rateOpenTxn = (double)numTxnOpSuccess.sumThenReset() / elapsed;
                log.info("--- Transaction : {} transaction end successfully --- {} transaction end failed --- {} Txn/s", new Object[]{totalTxnOpSuccess, totalTxnOpFail, TOTALFORMAT.format(rateOpenTxn)});
            }
            log.info("Throughput produced: {} msg --- {} msg/s --- {} Mbit/s  --- failure {} msg/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{INTFORMAT.format(total), THROUGHPUTFORMAT.format(rate), THROUGHPUTFORMAT.format(throughput), THROUGHPUTFORMAT.format(failureRate), DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
            if (histogramLogWriter != null) {
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            }
            reportHistogram.reset();
            oldTime = now;
        }
    }

    public PerformanceProducer() {
        super("produce");
    }

    private static void executorShutdownNow() {
        executor.shutdownNow();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.warn("Failed to terminate executor within timeout. The following are stack traces of still running threads.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Shutdown of thread pool was interrupted");
        }
    }

    static IMessageFormatter getMessageFormatter(String formatterClass) {
        try {
            ClassLoader classLoader = PerformanceProducer.class.getClassLoader();
            Class<?> clz = classLoader.loadClass(formatterClass);
            return (IMessageFormatter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    ProducerBuilder<byte[]> createProducerBuilder(PulsarClient client, int producerId) {
        ProducerBuilder producerBuilder = client.newProducer().sendTimeout(this.sendTimeout, TimeUnit.SECONDS).compressionType(this.compression).maxPendingMessages(this.maxOutstanding).accessMode(this.producerAccessMode).messageRoutingMode(MessageRoutingMode.RoundRobinPartition);
        if (this.maxPendingMessagesAcrossPartitions > 0) {
            producerBuilder.maxPendingMessagesAcrossPartitions(this.maxPendingMessagesAcrossPartitions);
        }
        if (this.producerName != null) {
            String producerName = String.format("%s%s%d", this.producerName, this.separator, producerId);
            producerBuilder.producerName(producerName);
        }
        if (this.disableBatching || this.batchTimeMillis <= 0.0 && this.batchMaxMessages <= 0) {
            producerBuilder.enableBatching(false);
        } else {
            long batchTimeUsec = (long)(this.batchTimeMillis * 1000.0);
            producerBuilder.batchingMaxPublishDelay(batchTimeUsec, TimeUnit.MICROSECONDS).enableBatching(true);
        }
        if (this.batchMaxMessages > 0) {
            producerBuilder.batchingMaxMessages(this.batchMaxMessages);
        }
        if (this.batchMaxBytes > 0) {
            producerBuilder.batchingMaxBytes(this.batchMaxBytes);
        }
        producerBuilder.blockIfQueueFull(true);
        if (StringUtils.isNotBlank((CharSequence)this.encKeyName) && StringUtils.isNotBlank((CharSequence)this.encKeyFile)) {
            producerBuilder.addEncryptionKey(this.encKeyName);
            producerBuilder.defaultCryptoKeyReader(this.encKeyFile);
        }
        return producerBuilder;
    }

    /*
     * Exception decompiling
     */
    private void runProducer(int producerId, PerformanceProducer arguments, long numMessages, int msgRate, List<byte[]> payloadByteList, byte[] payloadBytes, CountDownLatch doneLatch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesSent.sum() / elapsed;
        double throughput = (double)totalBytesSent.sum() / elapsed / 1024.0 / 1024.0 * 8.0;
        long totalTxnSuccess = 0L;
        long totalTxnFail = 0L;
        double rateOpenTxn = 0.0;
        long numTransactionOpenFailed = 0L;
        long numTransactionOpenSuccess = 0L;
        if (this.isEnableTransaction) {
            totalTxnSuccess = totalEndTxnOpSuccessNum.sum();
            totalTxnFail = totalEndTxnOpFailNum.sum();
            rateOpenTxn = elapsed / (double)(totalTxnFail + totalTxnSuccess);
            numTransactionOpenFailed = totalNumTxnOpenTxnFail.sum();
            numTransactionOpenSuccess = totalNumTxnOpenTxnSuccess.sum();
            log.info("--- Transaction : {} transaction end successfully --- {} transaction end failed --- {} transaction open successfully --- {} transaction open failed --- {} Txn/s", new Object[]{totalTxnSuccess, totalTxnFail, numTransactionOpenSuccess, numTransactionOpenFailed, TOTALFORMAT.format(rateOpenTxn)});
        }
        log.info("Aggregated throughput stats --- {} records sent --- {} msg/s --- {} Mbit/s ", new Object[]{totalMessagesSent.sum(), TOTALFORMAT.format(rate), TOTALFORMAT.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = cumulativeRecorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), DEC.format((double)reportHistogram.getMaxValue() / 1000.0)});
    }

    private static /* synthetic */ Void lambda$runProducer$7(Transaction transaction, Throwable exception) {
        log.error("Abort transaction {} failed with exception", (Object)transaction.getTxnID().toString(), (Object)exception);
        totalEndTxnOpFailNum.increment();
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$6(Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("Abort transaction {}", (Object)transaction.getTxnID().toString());
        }
        totalEndTxnOpSuccessNum.increment();
        numTxnOpSuccess.increment();
    }

    private static /* synthetic */ Void lambda$runProducer$5(Throwable exception) {
        log.error("Commit transaction failed with exception : ", exception);
        totalEndTxnOpFailNum.increment();
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$4(Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("Committed transaction {}", (Object)transaction.getTxnID().toString());
        }
        totalEndTxnOpSuccessNum.increment();
        numTxnOpSuccess.increment();
    }

    private /* synthetic */ Void lambda$runProducer$3(Throwable ex) {
        if (ex.getCause() instanceof ArrayIndexOutOfBoundsException) {
            return null;
        }
        log.warn("Write message error with exception", ex);
        messagesFailed.increment();
        if (this.exitOnFailure) {
            PerfClientUtils.exit(1);
        }
        return null;
    }

    private static /* synthetic */ void lambda$runProducer$2(byte[] payloadData, AtomicLong totalSent, long warmupEndTime, long sendTime) {
        bytesSent.add(payloadData.length);
        messagesSent.increment();
        totalSent.incrementAndGet();
        totalMessagesSent.increment();
        totalBytesSent.add(payloadData.length);
        long now = System.nanoTime();
        if (now > warmupEndTime) {
            long latencyMicros = TimeUnit.NANOSECONDS.toMicros(now - sendTime);
            recorder.recordValue(latencyMicros);
            cumulativeRecorder.recordValue(latencyMicros);
        }
    }

    public static enum MessageKeyGenerationMode {
        autoIncrement,
        random;

    }

    static class RangeConvert
    implements CommandLine.ITypeConverter<Range<Long>> {
        RangeConvert() {
        }

        public Range<Long> convert(String rangeStr) {
            try {
                Objects.requireNonNull(rangeStr);
                String[] facts = rangeStr.split(",");
                long min = Long.parseLong(facts[0].trim());
                long max = Long.parseLong(facts[1].trim());
                return Range.closedOpen((Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
            }
            catch (Throwable ex) {
                throw new CommandLine.TypeConversionException("Unknown delay range interval, the format should be \"<origin>,<bound>\". error message: " + rangeStr);
            }
        }
    }
}

