/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.callback.LogSegmentNamesListener;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.LogSegmentNotFoundException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.distributedlog.zk.DefaultZKOp;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.distributedlog.zk.ZKVersionedSetOp;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKLogSegmentMetadataStore
implements LogSegmentMetadataStore,
Watcher,
AsyncCallback.Children2Callback {
    private static final Logger logger = LoggerFactory.getLogger(ZKLogSegmentMetadataStore.class);
    private static final List<String> EMPTY_LIST = ImmutableList.of();
    final DistributedLogConfiguration conf;
    final int minZKBackoffMs;
    final int maxZKBackoffMs;
    final boolean skipMinVersionCheck;
    final ZooKeeperClient zkc;
    final ConcurrentMap<String, Map<LogSegmentNamesListener, VersionedLogSegmentNamesListener>> listeners;
    final OrderedScheduler scheduler;
    final ReentrantReadWriteLock closeLock;
    boolean closed = false;

    public ZKLogSegmentMetadataStore(DistributedLogConfiguration conf, ZooKeeperClient zkc, OrderedScheduler scheduler) {
        this.conf = conf;
        this.zkc = zkc;
        this.listeners = new ConcurrentHashMap<String, Map<LogSegmentNamesListener, VersionedLogSegmentNamesListener>>();
        this.scheduler = scheduler;
        this.closeLock = new ReentrantReadWriteLock();
        this.minZKBackoffMs = conf.getZKRetryBackoffStartMillis();
        this.maxZKBackoffMs = conf.getZKRetryBackoffMaxMillis();
        this.skipMinVersionCheck = conf.getDLLedgerMetadataSkipMinVersionCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTask(Object key, Runnable r, long delayMs) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.scheduler.scheduleOrdered(key, r, delayMs, TimeUnit.MILLISECONDS);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    protected void submitTask(Object key, Runnable r) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.scheduler.executeOrdered(key, r);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public void storeMaxLogSegmentSequenceNumber(Transaction<Object> txn, LogMetadata logMetadata, Versioned<Long> lssn, Transaction.OpListener<Version> listener) {
        Version version = lssn.getVersion();
        assert (version instanceof LongVersion);
        LongVersion zkVersion = (LongVersion)version;
        byte[] data = DLUtils.serializeLogSegmentSequenceNumber((Long)lssn.getValue());
        Op setDataOp = Op.setData((String)logMetadata.getLogSegmentsPath(), (byte[])data, (int)((int)zkVersion.getLongVersion()));
        ZKVersionedSetOp zkOp = new ZKVersionedSetOp(setDataOp, listener);
        txn.addOp(zkOp);
    }

    @Override
    public void storeMaxTxnId(Transaction<Object> txn, LogMetadataForWriter logMetadata, Versioned<Long> transactionId, Transaction.OpListener<Version> listener) {
        Version version = transactionId.getVersion();
        assert (version instanceof LongVersion);
        LongVersion zkVersion = (LongVersion)version;
        byte[] data = DLUtils.serializeTransactionId((Long)transactionId.getValue());
        Op setDataOp = Op.setData((String)logMetadata.getMaxTxIdPath(), (byte[])data, (int)((int)zkVersion.getLongVersion()));
        ZKVersionedSetOp zkOp = new ZKVersionedSetOp(setDataOp, listener);
        txn.addOp(zkOp);
    }

    @Override
    public Transaction<Object> transaction() {
        return new ZKTransaction(this.zkc);
    }

    @Override
    public void createLogSegment(Transaction<Object> txn, LogSegmentMetadata segment, Transaction.OpListener<Void> listener) {
        byte[] finalisedData = segment.getFinalisedData().getBytes(StandardCharsets.UTF_8);
        Op createOp = Op.create((String)segment.getZkPath(), (byte[])finalisedData, this.zkc.getDefaultACL(), (CreateMode)CreateMode.PERSISTENT);
        txn.addOp(DefaultZKOp.of(createOp, listener));
    }

    @Override
    public void deleteLogSegment(Transaction<Object> txn, final LogSegmentMetadata segment, final Transaction.OpListener<Void> listener) {
        Op deleteOp = Op.delete((String)segment.getZkPath(), (int)-1);
        logger.info("Delete segment : {}", (Object)segment);
        txn.addOp(DefaultZKOp.of(deleteOp, new Transaction.OpListener<Void>(){

            @Override
            public void onCommit(Void r) {
                if (null != listener) {
                    listener.onCommit(r);
                }
            }

            @Override
            public void onAbort(Throwable t) {
                KeeperException.Code kc;
                logger.info("Aborted transaction on deleting segment {}", (Object)segment);
                if (t instanceof KeeperException) {
                    kc = ((KeeperException)t).code();
                } else if (t instanceof ZKException) {
                    kc = ((ZKException)((Object)t)).getKeeperExceptionCode();
                } else {
                    this.abortListener(t);
                    return;
                }
                if (KeeperException.Code.NONODE == kc) {
                    this.abortListener((Throwable)new LogSegmentNotFoundException(segment.getZkPath()));
                    return;
                }
                this.abortListener(t);
            }

            private void abortListener(Throwable t) {
                if (null != listener) {
                    listener.onAbort(t);
                }
            }
        }));
    }

    @Override
    public void updateLogSegment(Transaction<Object> txn, LogSegmentMetadata segment) {
        byte[] finalisedData = segment.getFinalisedData().getBytes(StandardCharsets.UTF_8);
        Op updateOp = Op.setData((String)segment.getZkPath(), (byte[])finalisedData, (int)-1);
        txn.addOp(DefaultZKOp.of(updateOp, null));
    }

    public void process(WatchedEvent event) {
        if (Watcher.Event.EventType.None == event.getType() && Watcher.Event.KeeperState.Expired == event.getState()) {
            HashSet keySet = new HashSet(this.listeners.keySet());
            for (String logSegmentsPath : keySet) {
                this.scheduleTask(logSegmentsPath, new ReadLogSegmentsTask(logSegmentsPath, this), 0L);
            }
            return;
        }
        String path = event.getPath();
        if (null == path) {
            return;
        }
        switch (event.getType()) {
            case NodeDeleted: {
                this.notifyLogStreamDeleted(path, (Map)this.listeners.remove(path));
                break;
            }
            case NodeChildrenChanged: {
                new ReadLogSegmentsTask(path, this).run();
                break;
            }
        }
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> getLogSegment(String logSegmentPath) {
        return LogSegmentMetadata.read(this.zkc, logSegmentPath, this.skipMinVersionCheck);
    }

    CompletableFuture<Versioned<List<String>>> zkGetLogSegmentNames(String logSegmentsPath, Watcher watcher) {
        CompletableFuture<Versioned<List<String>>> result = new CompletableFuture<Versioned<List<String>>>();
        try {
            this.zkc.get().getChildren(logSegmentsPath, watcher, (AsyncCallback.Children2Callback)this, result);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            result.completeExceptionally(Utils.zkException(e, logSegmentsPath));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(Utils.zkException(e, logSegmentsPath));
        }
        return result;
    }

    public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
        CompletableFuture result = (CompletableFuture)ctx;
        if (KeeperException.Code.OK.intValue() == rc) {
            LongVersion zkVersion = new LongVersion((long)stat.getCversion());
            result.complete(new Versioned(children, (Version)zkVersion));
        } else if (KeeperException.Code.NONODE.intValue() == rc) {
            result.completeExceptionally(new LogNotFoundException("Log " + path + " not found"));
        } else {
            result.completeExceptionally((Throwable)((Object)new ZKException("Failed to get log segments from " + path, KeeperException.Code.get((int)rc))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Versioned<List<String>>> getLogSegmentNames(String logSegmentsPath, LogSegmentNamesListener listener) {
        ZKLogSegmentMetadataStore zkWatcher;
        block12: {
            if (null == listener) {
                zkWatcher = null;
            } else {
                this.closeLock.readLock().lock();
                try {
                    if (this.closed) {
                        zkWatcher = null;
                        break block12;
                    }
                    Map<LogSegmentNamesListener, VersionedLogSegmentNamesListener> listenerSet = (HashMap<LogSegmentNamesListener, VersionedLogSegmentNamesListener>)this.listeners.get(logSegmentsPath);
                    if (null == listenerSet) {
                        HashMap<LogSegmentNamesListener, VersionedLogSegmentNamesListener> newListenerSet = new HashMap<LogSegmentNamesListener, VersionedLogSegmentNamesListener>();
                        Map oldListenerSet = this.listeners.putIfAbsent(logSegmentsPath, newListenerSet);
                        listenerSet = null != oldListenerSet ? oldListenerSet : newListenerSet;
                    }
                    HashMap<LogSegmentNamesListener, VersionedLogSegmentNamesListener> hashMap = listenerSet;
                    synchronized (hashMap) {
                        listenerSet.put(listener, new VersionedLogSegmentNamesListener(listener));
                        if (!this.listeners.containsKey(logSegmentsPath) && null != this.listeners.putIfAbsent(logSegmentsPath, listenerSet)) {
                            logger.debug("Listener set is already found for log segments path {}", (Object)logSegmentsPath);
                        }
                    }
                    zkWatcher = this;
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
        }
        CompletableFuture<Versioned<List<String>>> getLogSegmentNamesResult = this.zkGetLogSegmentNames(logSegmentsPath, zkWatcher);
        if (null != listener) {
            getLogSegmentNamesResult.whenComplete((BiConsumer)((Object)new ReadLogSegmentsTask(logSegmentsPath, this)));
        }
        return this.zkGetLogSegmentNames(logSegmentsPath, zkWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLogSegmentListener(String logSegmentsPath, LogSegmentNamesListener listener) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                return;
            }
            Map listenerSet = (Map)this.listeners.get(logSegmentsPath);
            if (null == listenerSet) {
                return;
            }
            Map map = listenerSet;
            synchronized (map) {
                listenerSet.remove(listener);
                if (listenerSet.isEmpty()) {
                    this.listeners.remove(logSegmentsPath, listenerSet);
                }
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    void notifyLogStreamDeleted(String logSegmentsPath, Map<LogSegmentNamesListener, VersionedLogSegmentNamesListener> listeners) {
        if (null == listeners) {
            return;
        }
        this.submitTask(logSegmentsPath, () -> {
            Map map = listeners;
            synchronized (map) {
                for (LogSegmentNamesListener listener : listeners.keySet()) {
                    listener.onLogStreamDeleted();
                }
            }
        });
    }

    void notifyLogSegmentsUpdated(String logSegmentsPath, Map<LogSegmentNamesListener, VersionedLogSegmentNamesListener> listeners, Versioned<List<String>> segments) {
        if (null == listeners) {
            return;
        }
        this.submitTask(logSegmentsPath, () -> {
            Map map = listeners;
            synchronized (map) {
                for (VersionedLogSegmentNamesListener listener : listeners.values()) {
                    listener.onSegmentsUpdated(segments);
                }
            }
        });
    }

    static class VersionedLogSegmentNamesListener {
        private final LogSegmentNamesListener listener;
        private Versioned<List<String>> lastNotifiedLogSegments;

        VersionedLogSegmentNamesListener(LogSegmentNamesListener listener) {
            this.listener = listener;
            this.lastNotifiedLogSegments = new Versioned((Object)EMPTY_LIST, Version.NEW);
        }

        synchronized void onSegmentsUpdated(Versioned<List<String>> logSegments) {
            if (this.lastNotifiedLogSegments.getVersion() == Version.NEW || this.lastNotifiedLogSegments.getVersion().compare(logSegments.getVersion()) == Version.Occurred.BEFORE) {
                this.lastNotifiedLogSegments = logSegments;
                this.listener.onSegmentsUpdated(logSegments);
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VersionedLogSegmentNamesListener)) {
                return false;
            }
            VersionedLogSegmentNamesListener other = (VersionedLogSegmentNamesListener)obj;
            return this.listener.equals(other.listener);
        }

        public String toString() {
            return this.listener.toString();
        }
    }

    private static class ReadLogSegmentsTask
    implements Runnable,
    FutureEventListener<Versioned<List<String>>> {
        private final String logSegmentsPath;
        private final ZKLogSegmentMetadataStore store;
        private int currentZKBackOffMs;

        ReadLogSegmentsTask(String logSegmentsPath, ZKLogSegmentMetadataStore metadataStore) {
            this.logSegmentsPath = logSegmentsPath;
            this.store = metadataStore;
            this.currentZKBackOffMs = this.store.minZKBackoffMs;
        }

        public void onSuccess(Versioned<List<String>> segments) {
            this.currentZKBackOffMs = this.store.minZKBackoffMs;
            this.store.notifyLogSegmentsUpdated(this.logSegmentsPath, (Map)this.store.listeners.get(this.logSegmentsPath), segments);
        }

        public void onFailure(Throwable cause) {
            if (cause instanceof LogNotFoundException) {
                this.store.notifyLogStreamDeleted(this.logSegmentsPath, (Map)this.store.listeners.remove(this.logSegmentsPath));
                return;
            }
            int backoffMs = this.currentZKBackOffMs;
            this.currentZKBackOffMs = Math.min(2 * this.currentZKBackOffMs, this.store.maxZKBackoffMs);
            this.store.scheduleTask(this.logSegmentsPath, this, backoffMs);
        }

        @Override
        public void run() {
            if (null != this.store.listeners.get(this.logSegmentsPath)) {
                this.store.zkGetLogSegmentNames(this.logSegmentsPath, this.store).whenComplete((BiConsumer)((Object)this));
            } else {
                logger.debug("Log segments listener for {} has been removed.", (Object)this.logSegmentsPath);
            }
        }
    }
}

