/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.InjectedAttributeStatisticOrOperation;
import org.apache.qpid.server.model.OperationParameter;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class ConfiguredObjectInjectedOperation<C extends ConfiguredObject<?>>
implements ConfiguredObjectOperation<C>,
InjectedAttributeStatisticOrOperation<C> {
    private final Method _operation;
    private final List<OperationParameter> _params;
    private final Set<String> _validNames;
    private final InjectedAttributeStatisticOrOperation.TypeValidator _validator;
    private final String _name;
    private final String _description;
    private final boolean _nonModifying;
    private final boolean _secure;
    private final Object[] _staticParams;
    private final String _secureParam;

    public ConfiguredObjectInjectedOperation(String name, String description, boolean nonModifying, boolean secure, String secureParam, OperationParameter[] parameters, Method operation, Object[] staticParams, InjectedAttributeStatisticOrOperation.TypeValidator validator) {
        this._operation = operation;
        this._name = name;
        this._description = description;
        this._nonModifying = nonModifying;
        this._secure = secure;
        this._validator = validator;
        this._staticParams = staticParams == null ? new Object[]{} : staticParams;
        this._secureParam = secureParam;
        this._params = parameters == null ? List.of() : Arrays.asList(parameters);
        LinkedHashSet<String> validNames = new LinkedHashSet<String>();
        for (OperationParameter parameter : this._params) {
            validNames.add(parameter.getName());
        }
        this._validNames = Collections.unmodifiableSet(validNames);
        Class<?>[] opParameterTypes = operation.getParameterTypes();
        if (!(Modifier.isStatic(operation.getModifiers()) && Modifier.isPublic(operation.getModifiers()) && opParameterTypes.length == this._params.size() + this._staticParams.length + 1 && ConfiguredObject.class.isAssignableFrom(opParameterTypes[0]))) {
            throw new IllegalArgumentException("Passed method must be public and static.  The first parameter must derive from ConfiguredObject, and the rest of the parameters must match the passed in specifications");
        }
        for (int i = 0; i < this._staticParams.length; ++i) {
            if (opParameterTypes[i + 1].isPrimitive() && this._staticParams[i] == null) {
                throw new IllegalArgumentException("Static parameter has null value, but the " + opParameterTypes[i + 1].getSimpleName() + " type is a primitive");
            }
            if (AttributeValueConverter.convertPrimitiveToBoxed(opParameterTypes[i + 1]).isAssignableFrom(this._staticParams[i].getClass())) continue;
            throw new IllegalArgumentException("Static parameter cannot be assigned value as it is of incompatible type");
        }
        int paramId = 1 + this._staticParams.length;
        for (OperationParameter parameter : this._params) {
            if (!opParameterTypes[paramId].isAssignableFrom(parameter.getType())) {
                throw new IllegalArgumentException("Type for parameter " + parameter.getName() + " does not match");
            }
            ++paramId;
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public List<OperationParameter> getParameters() {
        return this._params;
    }

    @Override
    public Object perform(C subject, Map<String, Object> parameters) {
        int i;
        if (!this._validator.appliesToType(subject.getClass())) {
            throw new IllegalArgumentException("Operation " + this._operation.getName() + " cannot be used on an object of type " + subject.getClass().getSimpleName());
        }
        HashSet<String> providedNames = new HashSet<String>(parameters.keySet());
        providedNames.removeAll(this._validNames);
        if (!providedNames.isEmpty()) {
            throw new IllegalArgumentException("Parameters " + providedNames + " are not accepted by " + this.getName());
        }
        Object[] paramValues = new Object[1 + this._staticParams.length + this._params.size()];
        paramValues[0] = subject;
        for (i = 0; i < this._staticParams.length; ++i) {
            paramValues[i + 1] = this._staticParams[i];
        }
        for (i = 0; i < this._params.size(); ++i) {
            paramValues[i + 1 + this._staticParams.length] = this.getParameterValue(subject, parameters, this._params.get(i));
        }
        try {
            return this._operation.invoke(null, paramValues);
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new ServerScopedRuntimeException(e);
        }
    }

    private Object getParameterValue(C subject, Map<String, Object> parameters, OperationParameter param) {
        Object convertedVal;
        Object providedVal = parameters.containsKey(param.getName()) ? parameters.get(param.getName()) : (!"".equals(param.getDefaultValue()) ? param.getDefaultValue() : null);
        if (providedVal == null && param.isMandatory()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' of operation %s in %s requires a non-null value", param.getName(), this._operation.getName(), this._operation.getDeclaringClass().getSimpleName()));
        }
        AttributeValueConverter<?> converter = AttributeValueConverter.getConverter(AttributeValueConverter.convertPrimitiveToBoxed(param.getType()), param.getGenericType());
        try {
            convertedVal = converter.convert(providedVal, (ConfiguredObject)subject);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " for parameter '" + param.getName() + "' in " + this._operation.getDeclaringClass().getSimpleName() + "." + this._operation.getName() + "(...) operation", e.getCause());
        }
        return convertedVal;
    }

    @Override
    public boolean hasSameParameters(ConfiguredObjectOperation<?> other) {
        List<OperationParameter> otherParams = other.getParameters();
        if (this._params.size() == otherParams.size()) {
            for (int i = 0; i < this._params.size(); ++i) {
                if (this._params.get(i).isCompatible(otherParams.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getReturnType() {
        return this._operation.getReturnType();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public boolean isNonModifying() {
        return this._nonModifying;
    }

    @Override
    public boolean isAssociateAsIfChildren() {
        return false;
    }

    @Override
    public boolean isSecure(C subject, Map<String, Object> arguments) {
        return this._secure || this.requiresSecure(subject, arguments);
    }

    private boolean requiresSecure(C subject, Map<String, Object> arguments) {
        if (this._secureParam != null && !"".equals(this._secureParam)) {
            for (OperationParameter param : this._params) {
                if (!this._secureParam.equals(param.getName())) continue;
                Object value = this.getParameterValue(subject, arguments, param);
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                return value != null;
            }
        }
        return false;
    }

    @Override
    public Type getGenericReturnType() {
        return this._operation.getGenericReturnType();
    }

    @Override
    public boolean appliesToConfiguredObjectType(Class<? extends ConfiguredObject<?>> type) {
        return this._validator.appliesToType(type);
    }
}

