/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject(creatable=false, amqpName="org.apache.qpid.Producer")
public interface Producer<X extends Producer<X>>
extends ConfiguredObject<X> {
    public void registerMessageDelivered(long var1);

    @DerivedAttribute(description="Session ID")
    public String getSessionId();

    @DerivedAttribute(description="Session name")
    public String getSessionName();

    @DerivedAttribute(description="Connection principal")
    public String getPrincipal();

    @DerivedAttribute(description="Connection remote address")
    public String getRemoteAddress();

    @DerivedAttribute(description="Destination name")
    public String getDestination();

    public void setDestination(String var1);

    @DerivedAttribute(description="Destination id")
    public UUID getDestinationId();

    public void setDestinationId(UUID var1);

    @DerivedAttribute(description="DeliveryType type (standard or delayed)")
    public DeliveryType getDeliveryType();

    @DerivedAttribute(description="Destination type (exchange or queue)")
    public DestinationType getDestinationType();

    public void setDestinationType(DestinationType var1);

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, resettable=true)
    public int getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, resettable=true)
    public long getBytesOut();

    @ManagedOperation(description="Resets producer statistics", changesConfiguredObjectState=true)
    public void resetStatistics();

    public ListenableFuture<Void> deleteNoChecks();

    public static enum DestinationType {
        EXCHANGE,
        QUEUE;


        public static DestinationType from(MessageDestination messageDestination) {
            if (messageDestination instanceof Exchange) {
                return EXCHANGE;
            }
            if (messageDestination instanceof Queue) {
                return QUEUE;
            }
            return null;
        }

        public static UUID getId(MessageDestination messageDestination) {
            DestinationType destinationType = DestinationType.from(messageDestination);
            return destinationType == null ? null : ((ConfiguredObject)((Object)messageDestination)).getId();
        }
    }

    public static enum DeliveryType {
        DELAYED_DELIVERY,
        STANDARD_DELIVERY;

    }
}

