/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.MessageGroupManager;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinedGroupMessageGroupManager
implements MessageGroupManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefinedGroupMessageGroupManager.class);
    private final String _groupId;
    private final String _defaultGroup;
    private final Map<Object, Group> _groupMap = new HashMap<Object, Group>();
    private final MessageGroupManager.ConsumerResetHelper _resetHelper;

    DefinedGroupMessageGroupManager(String groupId, String defaultGroup, MessageGroupManager.ConsumerResetHelper resetHelper) {
        this._groupId = groupId;
        this._defaultGroup = defaultGroup;
        this._resetHelper = resetHelper;
    }

    @Override
    public synchronized boolean mightAssign(QueueEntry entry, QueueConsumer sub) {
        boolean possibleAssignment;
        Object groupId = this.getKey(entry);
        Group group = this._groupMap.get(groupId);
        boolean bl = possibleAssignment = group == null || !group.isValid() || group.getConsumer() == sub;
        if (!possibleAssignment) {
            group.addSkippedEntry(entry);
        }
        return possibleAssignment;
    }

    @Override
    public synchronized boolean acceptMessage(QueueConsumer<?, ?> sub, QueueEntry entry) {
        return this.assignMessage(sub, entry) && entry.acquire(sub);
    }

    private boolean assignMessage(QueueConsumer<?, ?> sub, QueueEntry entry) {
        QueueConsumer<?, ?> assignedSub;
        Object groupId = this.getKey(entry);
        Group group = this._groupMap.get(groupId);
        if (group == null || !group.isValid()) {
            group = new Group(groupId, sub);
            this._groupMap.put(groupId, group);
            if (this._resetHelper.isEntryAheadOfConsumer(entry, sub)) {
                return false;
            }
        }
        if ((assignedSub = group.getConsumer()) == sub) {
            entry.addStateChangeListener(new GroupStateChangeListener(group));
            return true;
        }
        group.addSkippedEntry(entry);
        return false;
    }

    @Override
    public synchronized QueueEntry findEarliestAssignedAvailableEntry(QueueConsumer<?, ?> sub) {
        EntryFinder visitor = new EntryFinder(sub);
        sub.getQueue().visit(visitor);
        return visitor.getEntry();
    }

    @Override
    public void clearAssignments(QueueConsumer<?, ?> sub) {
    }

    private Object getKey(QueueEntry entry) {
        String groupVal;
        AMQMessageHeader messageHeader;
        ServerMessage message = entry.getMessage();
        AMQMessageHeader aMQMessageHeader = messageHeader = message == null ? null : message.getMessageHeader();
        if (messageHeader == null) {
            groupVal = this._defaultGroup;
        } else {
            String string = groupVal = this._groupId == null ? messageHeader.getGroupId() : messageHeader.getHeader(this._groupId);
        }
        if (groupVal == null) {
            groupVal = this._defaultGroup;
        }
        return groupVal;
    }

    private class GroupStateChangeListener
    implements StateChangeListener<MessageInstance, MessageInstance.EntryState> {
        private final Group _group;

        GroupStateChangeListener(Group group) {
            this._group = group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(MessageInstance entry, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            DefinedGroupMessageGroupManager definedGroupMessageGroupManager = DefinedGroupMessageGroupManager.this;
            synchronized (definedGroupMessageGroupManager) {
                if (this._group.isValid()) {
                    if (this.isConsumerAcquiredStateForThisGroup(newState) && !this.isConsumerAcquiredStateForThisGroup(oldState)) {
                        this._group.add();
                    } else if (this.isConsumerAcquiredStateForThisGroup(oldState) && !this.isConsumerAcquiredStateForThisGroup(newState)) {
                        this._group.subtract((QueueEntry)entry, newState.getState() == MessageInstance.State.AVAILABLE);
                    }
                } else {
                    entry.removeStateChangeListener(this);
                }
            }
        }

        private boolean isConsumerAcquiredStateForThisGroup(MessageInstance.EntryState state) {
            return state instanceof MessageInstance.ConsumerAcquiredState && ((MessageInstance.ConsumerAcquiredState)state).getConsumer() == this._group.getConsumer();
        }
    }

    private class EntryFinder
    implements QueueEntryVisitor {
        private final QueueConsumer<?, ?> _sub;
        private QueueEntry _entry;

        EntryFinder(QueueConsumer<?, ?> sub) {
            this._sub = sub;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            if (!entry.isAvailable()) {
                return false;
            }
            Object groupId = DefinedGroupMessageGroupManager.this.getKey(entry);
            Group group = DefinedGroupMessageGroupManager.this._groupMap.get(groupId);
            if (group != null && group.getConsumer() == this._sub) {
                this._entry = entry;
                return true;
            }
            return false;
        }

        public QueueEntry getEntry() {
            return this._entry;
        }
    }

    private final class Group {
        private final Object _group;
        private final SortedSet<QueueEntry> _skippedEntries = new TreeSet<QueueEntry>();
        private QueueConsumer<?, ?> _consumer;
        private int _activeCount;

        private Group(Object key, QueueConsumer<?, ?> consumer) {
            this._group = key;
            this._consumer = consumer;
        }

        public boolean add() {
            if (this._consumer != null) {
                ++this._activeCount;
                return true;
            }
            return false;
        }

        void subtract(QueueEntry entry, boolean released) {
            if (!released) {
                this._skippedEntries.remove(entry);
            }
            if (--this._activeCount == 0) {
                DefinedGroupMessageGroupManager.this._groupMap.remove(this._group);
                if (!this._skippedEntries.isEmpty()) {
                    DefinedGroupMessageGroupManager.this._resetHelper.resetSubPointersForGroups(this._skippedEntries.first());
                    this._skippedEntries.clear();
                }
                this._consumer = null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group = (Group)o;
            return this._group.equals(group._group);
        }

        public int hashCode() {
            return this._group.hashCode();
        }

        public boolean isValid() {
            return this._consumer != null && (this._activeCount != 0 || !this._consumer.isClosed());
        }

        public QueueConsumer<?, ?> getConsumer() {
            return this._consumer;
        }

        public String toString() {
            return "Group{_group=" + this._group + ", _consumer=" + this._consumer + ", _activeCount=" + this._activeCount + "}";
        }

        void addSkippedEntry(QueueEntry entry) {
            this._skippedEntries.add(entry);
        }
    }
}

