/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class SessionRequestTimeout
extends Method {
    public static final int TYPE = 517;
    private short packing_flags = 0;
    private long timeout;

    @Override
    public final int getStructType() {
        return 517;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 2;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionRequestTimeout() {
    }

    public SessionRequestTimeout(long timeout, Option ... _options) {
        this.setTimeout(timeout);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionRequestTimeout(context, this);
    }

    public final boolean hasTimeout() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionRequestTimeout clearTimeout() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.timeout = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final SessionRequestTimeout setTimeout(long value) {
        this.timeout = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final SessionRequestTimeout timeout(long value) {
        return this.setTimeout(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeUint32(this.timeout);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.timeout = dec.readUint32();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("timeout", this.getTimeout());
        }
        return result;
    }
}

