/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.plugins;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.access.config.AclFileParser;
import org.apache.qpid.server.security.access.config.RuleBasedAccessControl;
import org.apache.qpid.server.security.access.plugins.AbstractLegacyAccessControlProvider;
import org.apache.qpid.server.security.access.plugins.AclFileAccessControlProvider;
import org.apache.qpid.server.util.StringUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclFileAccessControlProviderImpl
extends AbstractLegacyAccessControlProvider<AclFileAccessControlProviderImpl, Broker<?>, AccessControlProvider<?>>
implements AclFileAccessControlProvider<AclFileAccessControlProviderImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AclFileAccessControlProviderImpl.class);
    private final Broker _broker;
    @ManagedAttributeField(afterSet="reloadAclFile")
    private String _path;

    @ManagedObjectFactoryConstructor
    public AclFileAccessControlProviderImpl(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
        this._broker = broker;
    }

    @Override
    protected RuleBasedAccessControl createRuleBasedAccessController() {
        return new RuleBasedAccessControl(AclFileParser.parse(this.getPath(), (EventLoggerProvider)this), this.getModel());
    }

    @Override
    public void reload() {
        this.authorise(Operation.UPDATE);
        this.reloadAclFile();
    }

    private void reloadAclFile() {
        try {
            this.recreateAccessController();
            LOGGER.debug("Calling changeAttributes to try to force update");
            this.changeAttributes(Map.of());
            this.getEventLogger().message(AccessControlMessages.LOADED((CharSequence)StringUtil.elideDataUrl((String)this.getPath())));
        }
        catch (RuntimeException e) {
            throw new IllegalConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        try {
            this.recreateAccessController();
            this.setState(this._broker.isManagementMode() ? State.QUIESCED : State.ACTIVE);
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            if (this._broker.isManagementMode()) {
                LOGGER.warn("Failed to activate ACL provider: " + this.getName(), (Throwable)e);
            }
            throw e;
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public String getPath() {
        return this._path;
    }

    public int compareTo(AccessControlProvider<?> o) {
        return ACCESS_CONTROL_PROVIDER_COMPARATOR.compare(this, o);
    }

    static {
        Handler.register();
    }
}

