/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.SectionDecoderRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AbstractSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.codec.AbstractLazyConstructor;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;

public abstract class DescribedMapSectionConstructor<S extends AbstractSection>
implements DescribedTypeConstructor<S> {
    @Override
    public TypeConstructor<S> construct(Object descriptor, QpidByteBuffer in, int originalPosition, ValueHandler valueHandler) throws AmqpErrorException {
        int sizeBytes;
        if (!in.hasRemaining()) {
            throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode section.", new Object[0]);
        }
        short constructorByte = in.getUnsignedByte();
        switch (constructorByte) {
            case 193: {
                sizeBytes = 1;
                break;
            }
            case 209: {
                sizeBytes = 4;
                break;
            }
            default: {
                throw new AmqpErrorException(ConnectionError.FRAMING_ERROR, "The described section must always be a map", new Object[0]);
            }
        }
        return new LazyConstructor(sizeBytes, originalPosition);
    }

    protected abstract S createObject(DescribedTypeConstructorRegistry var1, QpidByteBuffer var2);

    private class LazyConstructor
    extends AbstractLazyConstructor<S> {
        private final int _sizeBytes;

        LazyConstructor(int sizeBytes, int originalPosition) {
            super(originalPosition);
            this._sizeBytes = sizeBytes;
        }

        @Override
        protected S createObject(QpidByteBuffer encoding, ValueHandler handler) {
            return DescribedMapSectionConstructor.this.createObject(((SectionDecoderRegistry)handler.getDescribedTypeRegistry()).getUnderlyingRegistry(), encoding);
        }

        @Override
        protected void skipValue(QpidByteBuffer in) throws AmqpErrorException {
            int size;
            if (!in.hasRemaining(this._sizeBytes)) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode section.", new Object[0]);
            }
            switch (this._sizeBytes) {
                case 1: {
                    size = in.getUnsignedByte();
                    break;
                }
                case 4: {
                    size = in.getInt();
                    break;
                }
                default: {
                    throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Unexpected constructor type, can only be 1 or 4", new Object[0]);
                }
            }
            if (!in.hasRemaining(size)) {
                throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Insufficient data to decode section.", new Object[0]);
            }
            in.position(in.position() + size);
        }
    }
}

