/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.Objects;
import org.apache.shenyu.admin.config.properties.ZookeeperConfig;
import org.apache.shenyu.admin.config.properties.ZookeeperProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.zookeeper.ZookeeperClient;
import org.apache.shenyu.admin.listener.zookeeper.ZookeeperDataChangedInit;
import org.apache.shenyu.admin.listener.zookeeper.ZookeeperDataChangedListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.sync.zookeeper", name={"url"})
@EnableConfigurationProperties(value={ZookeeperProperties.class})
public class ZookeeperSyncConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ZookeeperClient.class})
    public ZookeeperClient zookeeperClient(ZookeeperProperties zookeeperProp) {
        int sessionTimeout = Objects.isNull(zookeeperProp.getSessionTimeout()) ? 3000 : zookeeperProp.getSessionTimeout();
        int connectionTimeout = Objects.isNull(zookeeperProp.getConnectionTimeout()) ? 3000 : zookeeperProp.getConnectionTimeout();
        ZookeeperConfig zkConfig = new ZookeeperConfig(zookeeperProp.getUrl());
        zkConfig.setSessionTimeoutMilliseconds(sessionTimeout).setConnectionTimeoutMilliseconds(connectionTimeout);
        ZookeeperClient client = new ZookeeperClient(zkConfig);
        client.start();
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={ZookeeperDataChangedListener.class})
    public DataChangedListener zookeeperDataChangedListener(ZookeeperClient zkClient) {
        return new ZookeeperDataChangedListener(zkClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={ZookeeperDataChangedInit.class})
    public DataChangedInit zookeeperDataChangedInit(ZookeeperClient zkClient) {
        return new ZookeeperDataChangedInit(zkClient);
    }
}

