/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aot;

import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;

class GatewayProxyInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    GatewayProxyInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Stream gatewayProxyInterfaces = Arrays.stream(beanFactory.getBeanDefinitionNames()).map(beanName -> RegisteredBean.of((ConfigurableListableBeanFactory)beanFactory, (String)beanName)).filter(bean -> GatewayProxyFactoryBean.class.isAssignableFrom(bean.getBeanClass())).flatMap(bean -> Stream.ofNullable(bean.getBeanType().getGeneric(new int[]{0}).resolve()));
        return (generationContext, beanFactoryInitializationCode) -> {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            gatewayProxyInterfaces.forEach(gatewayInterface -> proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces((Class[])new Class[]{gatewayInterface})));
        };
    }
}

