/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.role;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class RoleChangedEvent
extends AdminDataModelChangedEvent {
    public RoleChangedEvent(RoleDO source, RoleDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        RoleDO after = (RoleDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the role [%s] is %s", after.getRoleName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the role [%s] is %s : %s", after.getRoleName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        RoleDO before = (RoleDO)this.getBefore();
        Objects.requireNonNull(before);
        RoleDO after = (RoleDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getRoleName(), after.getRoleName())) {
            builder.append(String.format("name[%s => %s] ", before.getRoleName(), after.getRoleName()));
        }
        if (!Objects.equals(before.getDescription(), after.getDescription())) {
            builder.append(String.format("disc[%s => %s] ", before.getDescription(), after.getDescription()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "role";
    }
}

