/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.admin.utils.CommonUpstreamUtils;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PluginNameAdapter;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class ShenyuClientRegisterGrpcServiceImpl
extends AbstractShenyuClientRegisterServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientRegisterGrpcServiceImpl.class);

    @Override
    public String rpcType() {
        return RpcTypeEnum.GRPC.getName();
    }

    @Override
    protected String selectorHandler(MetaDataRegisterDTO metaDataDTO) {
        return "";
    }

    @Override
    protected String ruleHandler() {
        return "";
    }

    @Override
    protected void registerMetadata(MetaDataRegisterDTO metaDataDTO) {
        MetaDataService metaDataService = this.getMetaDataService();
        if (LOG.isDebugEnabled()) {
            LOG.debug("grpc register metadata:{}", (Object)GsonUtils.getInstance().toJson((Object)metaDataDTO));
        }
        MetaDataDO exist = metaDataService.findByPathAndNamespaceId(metaDataDTO.getPath(), metaDataDTO.getNamespaceId());
        metaDataService.saveOrUpdateMetaData(exist, metaDataDTO);
    }

    @Override
    protected String buildHandle(List<URIRegisterDTO> uriList, SelectorDO selectorDO) {
        List existList;
        boolean isEventDeleted;
        List<GrpcUpstream> addList = this.buildGrpcUpstreamList(uriList);
        List<Object> canAddList = new CopyOnWriteArrayList();
        boolean bl = isEventDeleted = uriList.size() == 1 && EventType.DELETED.equals((Object)uriList.get(0).getEventType());
        if (isEventDeleted) {
            addList.get(0).setStatus(false);
        }
        if (CollectionUtils.isEmpty((Collection)(existList = GsonUtils.getInstance().fromCurrentList(selectorDO.getHandle(), GrpcUpstream.class)))) {
            canAddList = addList;
        } else {
            List diffStatusList;
            List diffList = addList.stream().filter(upstream -> !existList.contains(upstream)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(diffList)) {
                canAddList.addAll(diffList);
                existList.addAll(diffList);
            }
            if (CollectionUtils.isNotEmpty(diffStatusList = addList.stream().filter(upstream -> !upstream.isStatus() || existList.stream().anyMatch(e -> e.equals(upstream) && e.isStatus() != upstream.isStatus())).collect(Collectors.toList()))) {
                canAddList.addAll(diffStatusList);
            }
        }
        if (this.doSubmit(selectorDO.getId(), canAddList)) {
            return null;
        }
        return GsonUtils.getInstance().toJson(CollectionUtils.isEmpty((Collection)existList) ? canAddList : existList);
    }

    private List<GrpcUpstream> buildGrpcUpstreamList(List<URIRegisterDTO> uriList) {
        return uriList.stream().map(dto -> CommonUpstreamUtils.buildDefaultGrpcUpstream(dto.getHost(), dto.getPort(), dto.getNamespaceId())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    @Override
    public String offline(String selectorName, List<URIRegisterDTO> offlineList, String namespaceId) {
        String pluginName = PluginNameAdapter.rpcTypeAdapter((String)this.rpcType());
        SelectorService selectorService = this.getSelectorService();
        SelectorDO selectorDO = selectorService.findByNameAndPluginNameAndNamespaceId(selectorName, pluginName, namespaceId);
        if (Objects.isNull(selectorDO)) {
            return "success";
        }
        List validOfflineUrl = offlineList.stream().filter(dto -> Objects.nonNull(dto.getPort()) && StringUtils.isNotBlank((CharSequence)dto.getHost())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validOfflineUrl)) {
            for (URIRegisterDTO offlineUrl : validOfflineUrl) {
                GrpcUpstream grpcUpstream = CommonUpstreamUtils.buildDefaultGrpcUpstream(offlineUrl.getHost(), offlineUrl.getPort(), offlineUrl.getNamespaceId());
                this.removeDiscoveryUpstream(selectorDO.getId(), grpcUpstream.getUpstreamUrl());
            }
            DiscoverySyncData discoverySyncData = this.fetch(selectorDO.getId(), selectorDO.getName(), pluginName, selectorDO.getNamespaceId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("grpc offline discoverySyncData:{}", (Object)GsonUtils.getInstance().toJson((Object)discoverySyncData));
            }
            this.getEventPublisher().publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData)));
        }
        return "success";
    }
}

