/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.metadata;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.metadata.FailOverType;
import com.tencent.polaris.plugins.router.metadata.MetadataRouterConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataRouter
extends AbstractServiceRouter
implements PluginConfigProvider {
    public static final String ROUTER_TYPE_METADATA = "metadataRoute";
    private static final String KEY_METADATA_FAILOVER_TYPE = "internal-metadata-failover-type";
    private static final Map<String, FailOverType> valueToFailoverType = new HashMap<String, FailOverType>();
    private static final Map<MetadataFailoverType, FailOverType> inputToFailoverType = new HashMap<MetadataFailoverType, FailOverType>();
    private MetadataRouterConfig config;

    @Override
    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        MetadataFailoverType metadataFailoverType;
        String value;
        FailOverType failOverType = this.config.getMetadataFailOverType();
        Map<String, String> svcMetadata = instances.getMetadata();
        if (MapUtils.isNotEmpty(svcMetadata) && svcMetadata.containsKey(KEY_METADATA_FAILOVER_TYPE) && valueToFailoverType.containsKey(value = svcMetadata.get(KEY_METADATA_FAILOVER_TYPE))) {
            failOverType = valueToFailoverType.get(value);
        }
        if (null != (metadataFailoverType = routeInfo.getMetadataFailoverType())) {
            failOverType = inputToFailoverType.get((Object)metadataFailoverType);
        }
        Map<String, String> reqMetadata = this.getRouterMetadata(routeInfo);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Instance ins : instances.getInstances()) {
            boolean availableInsFlag = true;
            for (Map.Entry<String, String> entry : reqMetadata.entrySet()) {
                if (ins.getMetadata().containsKey(entry.getKey()) && ins.getMetadata().get(entry.getKey()).equals(entry.getValue())) continue;
                availableInsFlag = false;
                break;
            }
            if (!availableInsFlag) continue;
            instanceList.add(ins);
        }
        if (!CollectionUtils.isEmpty(instanceList)) {
            return new RouteResult(instanceList, RouteResult.State.Next);
        }
        switch (failOverType) {
            case all: {
                return new RouteResult(instances.getInstances(), RouteResult.State.Next);
            }
            case others: {
                return new RouteResult(this.addNotContainKeyIns(instances, reqMetadata), RouteResult.State.Next);
            }
        }
        throw new PolarisException(ErrorCode.METADATA_MISMATCH, String.format("can not find any instance by service %s", routeInfo.getDestService()));
    }

    private List<Instance> addNotContainKeyIns(ServiceInstances instances, Map<String, String> reqMetadata) {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Instance ins : instances.getInstances()) {
            boolean containKey = true;
            for (Map.Entry<String, String> entry : reqMetadata.entrySet()) {
                if (ins.getMetadata().containsKey(entry.getKey())) continue;
                containKey = false;
            }
            if (containKey) continue;
            instanceList.add(ins);
        }
        return instanceList;
    }

    @Override
    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.config = ctx.getConfig().getConsumer().getServiceRouter().getPluginConfig(this.getName(), MetadataRouterConfig.class);
    }

    @Override
    public String getName() {
        return "metadataRouter";
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return MetadataRouterConfig.class;
    }

    public MetadataRouterConfig getConfig() {
        return this.config;
    }

    @Override
    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.MIDDLE;
    }

    @Override
    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        if (!super.enable(routeInfo, dstSvcInfo)) {
            return false;
        }
        Map<String, String> metadata = this.getRouterMetadata(routeInfo);
        return !MapUtils.isEmpty(metadata);
    }

    private Map<String, String> getRouterMetadata(RouteInfo routeInfo) {
        Map<String, String> metadata = routeInfo.getDestService().getMetadata();
        if (MapUtils.isNotEmpty(metadata)) {
            return metadata;
        }
        return routeInfo.getRouterMetadata(ROUTER_TYPE_METADATA);
    }

    static {
        valueToFailoverType.put("none", FailOverType.none);
        valueToFailoverType.put("all", FailOverType.all);
        valueToFailoverType.put("others", FailOverType.others);
        inputToFailoverType.put(MetadataFailoverType.METADATAFAILOVERNONE, FailOverType.none);
        inputToFailoverType.put(MetadataFailoverType.METADATAFAILOVERALL, FailOverType.all);
        inputToFailoverType.put(MetadataFailoverType.METADATAFAILOVERNOTKEY, FailOverType.others);
    }
}

