/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import io.etcd.jetcd.Client;
import org.apache.shenyu.admin.config.properties.EtcdProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.etcd.EtcdClient;
import org.apache.shenyu.admin.listener.etcd.EtcdDataChangedInit;
import org.apache.shenyu.admin.listener.etcd.EtcdDataDataChangedListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.sync.etcd", name={"url"})
@EnableConfigurationProperties(value={EtcdProperties.class})
public class EtcdSyncConfiguration {
    @Bean
    public EtcdClient etcdClient(EtcdProperties etcdProperties) {
        Client client = Client.builder().endpoints(etcdProperties.getUrl().split(",")).build();
        return new EtcdClient(client);
    }

    @Bean
    @ConditionalOnMissingBean(value={EtcdDataDataChangedListener.class})
    public DataChangedListener etcdDataChangedListener(EtcdClient etcdClient) {
        return new EtcdDataDataChangedListener(etcdClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={EtcdDataChangedInit.class})
    public DataChangedInit etcdDataChangedInit(EtcdClient etcdClient) {
        return new EtcdDataChangedInit(etcdClient);
    }
}

