/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.AfterScopeEnd;
import org.apache.cayenne.di.spi.DefaultScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScopeProvider<T>
implements Provider<T> {
    private Provider<T> delegate;
    private DefaultScope scope;
    private volatile T instance;

    public DefaultScopeProvider(DefaultScope scope, Provider<T> delegate) {
        this.scope = scope;
        this.delegate = delegate;
        scope.addScopeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.instance == null) {
            DefaultScopeProvider defaultScopeProvider = this;
            synchronized (defaultScopeProvider) {
                if (this.instance == null) {
                    this.instance = this.delegate.get();
                    if (this.instance == null) {
                        throw new ConfigurationException("Underlying provider (%s) returned NULL instance", this.delegate.getClass().getName());
                    }
                    this.scope.addScopeEventListener(this.instance);
                }
            }
        }
        return this.instance;
    }

    @AfterScopeEnd
    public void afterScopeEnd() throws Exception {
        T localInstance = this.instance;
        if (localInstance != null) {
            this.instance = null;
            this.scope.removeScopeEventListener(localInstance);
        }
    }
}

