/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import shaded.org.apache.commons.lang3.StringUtils;

public final class TarTest
extends AbstractTest {
    private String createLongName(int nameLength) {
        return StringUtils.repeat((char)'a', (int)nameLength);
    }

    private byte[] createTarWithOneLongNameEntry(String longName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry longFileNameEntry = new TarArchiveEntry(longName);
            tos.putArchiveEntry(longFileNameEntry);
            tos.closeArchiveEntry();
        }
        return bos.toByteArray();
    }

    @Test
    public void testCOMPRESS114() throws Exception {
        File input = TarTest.getFile("COMPRESS-114.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is, StandardCharsets.ISO_8859_1.name());){
            TarArchiveEntry entry = in.getNextEntry();
            Assertions.assertEquals((Object)"3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            entry = in.getNextEntry();
            Assertions.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
        }
    }

    @Test
    public void testCOMPRESS178() throws Exception {
        File input = TarTest.getFile("COMPRESS-178-fail.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);){
            IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> ((ArchiveInputStream)in).getNextEntry(), (String)"Expected IOException");
            Throwable t = e.getCause();
            Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)t, (String)"Expected cause = IllegalArgumentException");
        }
    }

    @Test
    public void testCOMPRESS178Lenient() throws Exception {
        File input = TarTest.getFile("COMPRESS-178-fail.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is, true);){
            in.getNextEntry();
        }
    }

    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        TarArchiveEntry out;
        long beforeArchiveWrite;
        File archive = this.createTempFile("test.", ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            File dir = this.getTempDirFile();
            beforeArchiveWrite = dir.lastModified();
            TarArchiveEntry in = new TarArchiveEntry(dir, "foo");
            tos.putArchiveEntry(in);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextTarEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo/", (Object)out.getName());
        Assertions.assertEquals((byte)53, (byte)out.getLinkFlag());
        Assertions.assertEquals((long)0L, (long)out.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)out.isDirectory());
    }

    @Test
    public void testDirectoryRead() throws IOException {
        File input = TarTest.getFile("directory.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = new TarArchiveInputStream(is);){
            TarArchiveEntry directoryEntry = in.getNextTarEntry();
            Assertions.assertEquals((Object)"directory/", (Object)directoryEntry.getName());
            Assertions.assertEquals((byte)53, (byte)directoryEntry.getLinkFlag());
            Assertions.assertTrue((boolean)directoryEntry.isDirectory());
            byte[] directoryRead = IOUtils.toByteArray((InputStream)in);
            Assertions.assertArrayEquals((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (byte[])directoryRead);
        }
    }

    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        TarArchiveEntry out;
        long beforeArchiveWrite;
        File archive = this.createTempFile("test.", ".tar");
        TarArchiveEntry in = new TarArchiveEntry("foo/");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            beforeArchiveWrite = this.getTempDirFile().lastModified();
            in.setModTime(beforeArchiveWrite);
            tos.putArchiveEntry(in);
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextTarEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo/", (Object)out.getName());
        Assertions.assertEquals((byte)53, (byte)in.getLinkFlag());
        Assertions.assertEquals((long)0L, (long)out.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)out.isDirectory());
    }

    @Test
    public void testExplicitFileEntry() throws Exception {
        TarArchiveEntry entryOut;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            TarArchiveEntry entryIn = new TarArchiveEntry("foo");
            entryIn.setModTime(tmp.lastModified());
            entryIn.setSize(tmp.length());
            tos.putArchiveEntry(entryIn);
            byte[] b = new byte[(int)tmp.length()];
            try (InputStream fis = Files.newInputStream(tmp.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            entryOut = tis.getNextTarEntry();
        }
        Assertions.assertNotNull((Object)entryOut);
        Assertions.assertEquals((Object)"foo", (Object)entryOut.getName());
        Assertions.assertEquals((byte)48, (byte)entryOut.getLinkFlag());
        Assertions.assertEquals((long)tmp.length(), (long)entryOut.getSize());
        Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(entryOut.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)entryOut.isDirectory());
    }

    @Test
    public void testFileEntryFromFile() throws Exception {
        TarArchiveEntry out;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".tar");
        TarArchiveEntry in = new TarArchiveEntry(tmp, "foo");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            tos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmp.length()];
            try (InputStream fis = Files.newInputStream(tmp.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
        }
        try (TarArchiveInputStream tis = new TarArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextTarEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((byte)48, (byte)out.getLinkFlag());
        Assertions.assertEquals((long)tmp.length(), (long)out.getSize());
        Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Test
    public void testLongNameLargerThanBuffer() throws IOException {
        List<Integer> nameLength = Arrays.asList(300, 4096);
        for (Integer length : nameLength) {
            String fileName = this.createLongName(length);
            Assertions.assertEquals((int)length, (int)fileName.length());
            byte[] data = this.createTarWithOneLongNameEntry(fileName);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
                 TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)bis);){
                Assertions.assertEquals((Object)fileName, (Object)tis.getNextTarEntry().getName());
            }
        }
    }

    @Test
    public void testTarArchiveCreation() throws Exception {
        File output = this.newTempFile("bla.tar");
        File file1 = TarTest.getFile("test1.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             TarArchiveOutputStream os = (TarArchiveOutputStream)ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
            TarArchiveEntry entry = new TarArchiveEntry("testdata/test1.xml");
            entry.setModTime(0L);
            entry.setSize(file1.length());
            entry.setUserId(0);
            entry.setGroupId(0);
            entry.setUserName("avalon");
            entry.setGroupName("excalibur");
            entry.setMode(32768);
            os.putArchiveEntry(entry);
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
    }

    @Test
    public void testTarArchiveLongNameCreation() throws Exception {
        String name = "testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml";
        byte[] bytes = "testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml".getBytes(StandardCharsets.UTF_8);
        Assertions.assertEquals((int)bytes.length, (int)99);
        File output = this.newTempFile("bla.tar");
        File file1 = TarTest.getFile("test1.xml");
        TarArchiveEntry entry = new TarArchiveEntry("testdata/12345678901234567890123456789012345678901234567890123456789012345678901234567890123456.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             TarArchiveOutputStream os = (TarArchiveOutputStream)ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
            entry.setModTime(0L);
            entry.setSize(file1.length());
            entry.setUserId(0);
            entry.setGroupId(0);
            entry.setUserName("avalon");
            entry.setGroupName("excalibur");
            entry.setMode(32768);
            os.putArchiveEntry(entry);
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        String toLongName = "testdata/123456789012345678901234567890123456789012345678901234567890123456789012345678901234567.xml";
        File output2 = this.newTempFile("bla.tar");
        try (OutputStream out2 = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
             TarArchiveOutputStream os2 = (TarArchiveOutputStream)ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out2);){
            TarArchiveEntry entry2 = new TarArchiveEntry("testdata/123456789012345678901234567890123456789012345678901234567890123456789012345678901234567.xml");
            entry2.setModTime(0L);
            entry2.setSize(file1.length());
            entry2.setUserId(0);
            entry2.setGroupId(0);
            entry2.setUserName("avalon");
            entry2.setGroupName("excalibur");
            entry2.setMode(32768);
            os2.putArchiveEntry(entry);
            Files.copy(file1.toPath(), (OutputStream)os2);
            os2.closeArchiveEntry();
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testTarFileCOMPRESS114() throws Exception {
        File input = TarTest.getFile("COMPRESS-114.tar");
        try (TarFile tarFile = new TarFile(input, StandardCharsets.ISO_8859_1.name());){
            List entries = tarFile.getEntries();
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(0);
            Assertions.assertEquals((Object)"3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
            entry = (TarArchiveEntry)entries.get(1);
            Assertions.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W2345\u00b1ZB\u00b1la\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1BLA", (Object)entry.getName());
            Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
        }
    }

    @Test
    public void testTarFileCOMPRESS178() throws Exception {
        File input = TarTest.getFile("COMPRESS-178-fail.tar");
        IOException e = (IOException)Assertions.assertThrows(IOException.class, () -> {
            TarFile tarFile = new TarFile(input);
            tarFile.close();
        }, (String)"Expected IOException");
        Throwable t = e.getCause();
        Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)t, (String)"Expected cause = IllegalArgumentException");
    }

    @Test
    public void testTarFileCOMPRESS178Lenient() throws Exception {
        File input = TarTest.getFile("COMPRESS-178-fail.tar");
        TarFile tarFile = new TarFile(input, true);
        tarFile.close();
    }

    @Test
    public void testTarFileDirectoryEntryFromFile() throws Exception {
        File archive = this.createTempFile("test.", ".tar");
        File dir = this.getTempDirFile();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            long beforeArchiveWrite = dir.lastModified();
            TarArchiveEntry in = new TarArchiveEntry(dir, "foo");
            tos.putArchiveEntry(in);
            tos.closeArchiveEntry();
            tos.close();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"foo/", (Object)entry.getName());
                Assertions.assertEquals((byte)53, (byte)entry.getLinkFlag());
                Assertions.assertEquals((long)0L, (long)entry.getSize());
                Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assertions.assertTrue((boolean)entry.isDirectory());
            }
        }
    }

    @Test
    public void testTarFileDirectoryRead() throws IOException {
        File input = TarTest.getFile("directory.tar");
        try (TarFile tarFile = new TarFile(input);){
            TarArchiveEntry directoryEntry = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assertions.assertEquals((Object)"directory/", (Object)directoryEntry.getName());
            Assertions.assertEquals((byte)53, (byte)directoryEntry.getLinkFlag());
            Assertions.assertTrue((boolean)directoryEntry.isDirectory());
            try (InputStream directoryStream = tarFile.getInputStream(directoryEntry);){
                byte[] directoryRead = IOUtils.toByteArray((InputStream)directoryStream);
                Assertions.assertArrayEquals((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (byte[])directoryRead);
            }
        }
    }

    @Test
    public void testTarFileEntryFromFile() throws Exception {
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            TarArchiveEntry in = new TarArchiveEntry(tmp, "foo");
            tos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmp.length()];
            try (InputStream fis = Files.newInputStream(tmp.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
            tos.close();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"foo", (Object)entry.getName());
                Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
                Assertions.assertEquals((long)tmp.length(), (long)entry.getSize());
                Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assertions.assertFalse((boolean)entry.isDirectory());
            }
        }
    }

    @Test
    public void testTarFileExplicitDirectoryEntry() throws Exception {
        File archive = this.createTempFile("test.", ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            long beforeArchiveWrite = this.getTempDirFile().lastModified();
            TarArchiveEntry in = new TarArchiveEntry("foo/");
            in.setModTime(beforeArchiveWrite);
            tos.putArchiveEntry(in);
            tos.closeArchiveEntry();
            tos.close();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"foo/", (Object)entry.getName());
                Assertions.assertEquals((byte)53, (byte)entry.getLinkFlag());
                Assertions.assertEquals((long)0L, (long)entry.getSize());
                Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assertions.assertTrue((boolean)entry.isDirectory());
            }
        }
    }

    @Test
    public void testTarFileExplicitFileEntry() throws Exception {
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".tar");
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            TarArchiveEntry in = new TarArchiveEntry("foo");
            in.setModTime(tmp.lastModified());
            in.setSize(tmp.length());
            tos.putArchiveEntry(in);
            byte[] b = new byte[(int)tmp.length()];
            try (InputStream fis = Files.newInputStream(tmp.toPath(), new OpenOption[0]);){
                while (fis.read(b) > 0) {
                    tos.write(b);
                }
            }
            tos.closeArchiveEntry();
            try (TarFile tarFile = new TarFile(archive);){
                TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"foo", (Object)entry.getName());
                Assertions.assertEquals((byte)48, (byte)entry.getLinkFlag());
                Assertions.assertEquals((long)tmp.length(), (long)entry.getSize());
                Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
                Assertions.assertFalse((boolean)entry.isDirectory());
            }
        }
    }

    @Test
    public void testTarFileLongNameLargerThanBuffer() throws IOException {
        List<Integer> nameLength = Arrays.asList(300, 4096);
        for (Integer length : nameLength) {
            String fileName = this.createLongName(length);
            Assertions.assertEquals((int)length, (int)fileName.length());
            byte[] data = this.createTarWithOneLongNameEntry(fileName);
            try (TarFile tarFile = new TarFile(data);){
                List entries = tarFile.getEntries();
                Assertions.assertEquals((Object)fileName, (Object)((TarArchiveEntry)entries.get(0)).getName());
                Assertions.assertEquals((byte)48, (byte)((TarArchiveEntry)entries.get(0)).getLinkFlag());
            }
        }
    }

    @Test
    public void testTarFileUnarchive() throws Exception {
        File file = TarTest.getFile("bla.tar");
        try (TarFile tarFile = new TarFile(file);){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (InputStream inputStream = tarFile.getInputStream(entry);){
                Files.copy(inputStream, this.newTempFile(entry.getName()).toPath(), new CopyOption[0]);
            }
        }
    }

    @Test
    public void testTarUnarchive() throws Exception {
        File input = TarTest.getFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             TarArchiveInputStream in = (TarArchiveInputStream)ArchiveStreamFactory.DEFAULT.createArchiveInputStream("tar", is);){
            TarArchiveEntry entry = in.getNextEntry();
            Files.copy((InputStream)in, this.newTempFile(entry.getName()).toPath(), new CopyOption[0]);
        }
    }
}

