/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CpioArchiveOutputStreamTest
extends AbstractTest {
    @Test
    public void testWriteOldBinary() throws Exception {
        File f = CpioArchiveOutputStreamTest.getFile("test1.xml");
        File output = this.newTempFile("test.cpio");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CpioArchiveOutputStream os = new CpioArchiveOutputStream(out, 8);){
            os.putArchiveEntry(new CpioArchiveEntry(8, f, "test1.xml"));
            Files.copy(f.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
            CpioArchiveEntry e = in.getNextCPIOEntry();
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertNull((Object)in.getNextEntry());
        }
    }
}

