/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.PasswordRequiredException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.compress.utils.TimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZ;

public class SevenZOutputFileTest
extends AbstractTest {
    private static final boolean XZ_BCJ_IS_BUGGY;

    private static void assertContentMethodsEquals(Iterable<? extends SevenZMethodConfiguration> expected, Iterable<? extends SevenZMethodConfiguration> actual) {
        Assertions.assertNotNull(actual);
        Iterator<? extends SevenZMethodConfiguration> actualIter = actual.iterator();
        for (SevenZMethodConfiguration sevenZMethodConfiguration : expected) {
            Assertions.assertTrue((boolean)actualIter.hasNext());
            SevenZMethodConfiguration actConfig = actualIter.next();
            Assertions.assertEquals((Object)sevenZMethodConfiguration.getMethod(), (Object)actConfig.getMethod());
        }
        Assertions.assertFalse((boolean)actualIter.hasNext());
    }

    private void addDir(SevenZOutputFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.createArchiveEntry(this.getTempDirFile(), "foo/");
        archive.putArchiveEntry(entry);
        archive.closeArchiveEntry();
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty) throws Exception {
        this.addFile(archive, index, nonEmpty, null);
    }

    private void addFile(SevenZOutputFile archive, int index, boolean nonEmpty, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        this.addFile(archive, index, nonEmpty ? 1 : 0, methods);
    }

    private void addFile(SevenZOutputFile archive, int index, int size, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        SevenZArchiveEntry entry = new SevenZArchiveEntry();
        entry.setName("foo/" + index + ".txt");
        entry.setContentMethods(methods);
        archive.putArchiveEntry(entry);
        archive.write(this.generateFileData(size));
        archive.closeArchiveEntry();
    }

    private void createAndReadBack(File output, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(methods);
            this.addFile(outArchive, 0, true);
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, methods));
        }
    }

    private void createAndReadBack(SeekableInMemoryByteChannel output, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        try (SevenZOutputFile outArchive = new SevenZOutputFile((SeekableByteChannel)output);){
            outArchive.setContentMethods(methods);
            this.addFile(outArchive, 0, true);
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setByteArray(output.array())).setDefaultName("in memory").get();){
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, methods));
        }
    }

    private byte[] generateFileData(int size) {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)(65 + i % 26);
        }
        return data;
    }

    private FileTime getHundredNanosFileTime() {
        Instant now = Instant.now();
        FileTime fileTime = FileTime.from(Instant.ofEpochSecond(now.getEpochSecond(), now.getNano() + 999900));
        return TimeUtils.truncateToHundredNanos((FileTime)fileTime);
    }

    @Test
    public void testArchiveWithMixedMethods() throws Exception {
        File output = this.newTempFile("mixed-methods.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            this.addFile(outArchive, 0, true);
            this.addFile(outArchive, 1, true, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2)));
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2))));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 1, Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.BZIP2))));
        }
    }

    @Test
    public void testBCJARMRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_FILTER));
    }

    @Test
    public void testBCJARMThumbRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_ARM_THUMB_FILTER));
    }

    @Test
    public void testBCJIA64Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_IA64_FILTER));
    }

    @Test
    public void testBCJPPCRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_PPC_FILTER));
    }

    @Test
    public void testBCJSparcRoundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_SPARC_FILTER));
    }

    @Test
    public void testBCJX86Roundtrip() throws Exception {
        if (XZ_BCJ_IS_BUGGY) {
            return;
        }
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.BCJ_X86_FILTER));
    }

    @Test
    public void testBzip2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.BZIP2);
    }

    @Test
    public void testBzip2WithConfiguration() throws Exception {
        File output = this.newTempFile("bzip2-options.7z");
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.BZIP2, (Object)4)));
    }

    @Test
    public void testCantFinishTwice() throws IOException {
        File output = this.newTempFile("finish.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.finish();
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> ((SevenZOutputFile)outArchive).finish(), (String)"shouldn't be able to call finish twice");
            Assertions.assertEquals((Object)"This archive has already been finished", (Object)ex.getMessage());
        }
    }

    private void testCompress252(int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        int nonEmptyModulus = numberOfNonEmptyFiles != 0 ? numberOfFiles / numberOfNonEmptyFiles : numberOfFiles + 1;
        int nonEmptyFilesAdded = 0;
        File output = this.newTempFile("COMPRESS252-" + numberOfFiles + "-" + numberOfNonEmptyFiles + ".7z");
        try (SevenZOutputFile archive = new SevenZOutputFile(output);){
            this.addDir(archive);
            for (int i = 0; i < numberOfFiles; ++i) {
                this.addFile(archive, i, (i + 1) % nonEmptyModulus == 0 && nonEmptyFilesAdded++ < numberOfNonEmptyFiles);
            }
        }
        this.verifyCompress252(output, numberOfFiles, numberOfNonEmptyFiles);
    }

    @Test
    public void testCopyRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.COPY);
    }

    @Test
    public void testDeflateRoundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.DEFLATE);
    }

    @Test
    public void testDeflateWithConfiguration() throws Exception {
        File output = this.newTempFile("deflate-options.7z");
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.DEFLATE, (Object)1)));
    }

    @Test
    public void testDeltaRoundtrip() throws Exception {
        this.testFilterRoundTrip(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER));
    }

    @Test
    public void testDirectoriesAndEmptyFiles() throws Exception {
        SevenZArchiveEntry entry;
        File output = this.newTempFile("empties.7z");
        FileTime accessTime = this.getHundredNanosFileTime();
        Date accessDate = new Date(accessTime.toMillis());
        Calendar cal = Calendar.getInstance();
        cal.add(10, -1);
        Date creationDate = cal.getTime();
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            entry = outArchive.createArchiveEntry(this.getTempDirFile(), "foo/");
            outArchive.putArchiveEntry(entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar");
            entry.setCreationDate(creationDate);
            entry.setAccessTime(accessTime);
            outArchive.putArchiveEntry(entry);
            outArchive.write(ByteUtils.EMPTY_BYTE_ARRAY);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo0");
            entry.setCreationDate(creationDate);
            entry.setAccessTime(accessTime);
            outArchive.putArchiveEntry(entry);
            outArchive.write((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo1");
            entry.setCreationDate(creationDate);
            entry.setAccessTime(accessTime);
            outArchive.putArchiveEntry(entry);
            outArchive.write((InputStream)new ByteArrayInputStream(new byte[]{97}));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/boo10000");
            entry.setCreationDate(creationDate);
            entry.setAccessTime(accessTime);
            outArchive.putArchiveEntry(entry);
            outArchive.write((InputStream)new ByteArrayInputStream(new byte[10000]));
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("foo/bar/test.txt");
            entry.setCreationDate(creationDate);
            entry.setAccessTime(accessTime);
            outArchive.putArchiveEntry(entry);
            outArchive.write(Paths.get("src/test/resources/test.txt", new String[0]), new OpenOption[0]);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("xyzzy");
            outArchive.putArchiveEntry(entry);
            outArchive.write(0);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.getTempDirFile(), "baz/");
            entry.setAntiItem(true);
            outArchive.putArchiveEntry(entry);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.getTempDirFile().toPath(), "baz2/", new LinkOption[0]);
            entry.setAntiItem(true);
            outArchive.putArchiveEntry(entry);
            outArchive.closeArchiveEntry();
            entry = new SevenZArchiveEntry();
            entry.setName("dada");
            entry.setHasWindowsAttributes(true);
            entry.setWindowsAttributes(17);
            outArchive.putArchiveEntry(entry);
            outArchive.write(5);
            outArchive.write(42);
            outArchive.closeArchiveEntry();
            outArchive.finish();
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/", (Object)entry.getName());
            Assertions.assertTrue((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/bar", (Object)entry.getName());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertEquals((long)0L, (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assertions.assertEquals((Object)accessTime, (Object)entry.getAccessTime());
            Assertions.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assertions.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/bar/boo0", (Object)entry.getName());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertEquals((long)0L, (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assertions.assertEquals((Object)accessTime, (Object)entry.getAccessTime());
            Assertions.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assertions.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/bar/boo1", (Object)entry.getName());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertEquals((long)1L, (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assertions.assertEquals((Object)accessTime, (Object)entry.getAccessTime());
            Assertions.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assertions.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/bar/boo10000", (Object)entry.getName());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertEquals((long)10000L, (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assertions.assertEquals((Object)accessTime, (Object)entry.getAccessTime());
            Assertions.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assertions.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"foo/bar/test.txt", (Object)entry.getName());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertEquals((long)Files.size(Paths.get("src/test/resources/test.txt", new String[0])), (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasLastModifiedDate());
            Assertions.assertEquals((Object)accessTime, (Object)entry.getAccessTime());
            Assertions.assertEquals((Object)accessDate, (Object)entry.getAccessDate());
            Assertions.assertEquals((Object)creationDate, (Object)entry.getCreationDate());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"xyzzy", (Object)entry.getName());
            Assertions.assertEquals((long)1L, (long)entry.getSize());
            Assertions.assertFalse((boolean)entry.getHasAccessDate());
            Assertions.assertFalse((boolean)entry.getHasCreationDate());
            Assertions.assertEquals((int)0, (int)archive.read());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"baz/", (Object)entry.getName());
            Assertions.assertTrue((boolean)entry.isDirectory());
            Assertions.assertTrue((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"baz2/", (Object)entry.getName());
            Assertions.assertTrue((boolean)entry.isDirectory());
            Assertions.assertTrue((boolean)entry.isAntiItem());
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"Entry should not be null");
            Assertions.assertEquals((Object)"dada", (Object)entry.getName());
            Assertions.assertEquals((long)2L, (long)entry.getSize());
            byte[] content = new byte[2];
            Assertions.assertEquals((int)2, (int)archive.read(content));
            Assertions.assertEquals((int)5, (int)content[0]);
            Assertions.assertEquals((int)42, (int)content[1]);
            Assertions.assertEquals((int)17, (int)entry.getWindowsAttributes());
            Assertions.assertNull((Object)archive.getNextEntry(), (String)"getNextEntry should return null");
        }
    }

    @Test
    public void testDirectoriesOnly() throws Exception {
        SevenZArchiveEntry entry;
        File output = this.newTempFile("dirs.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            entry = new SevenZArchiveEntry();
            entry.setName("foo/");
            entry.setDirectory(true);
            outArchive.putArchiveEntry(entry);
            outArchive.closeArchiveEntry();
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            entry = archive.getNextEntry();
            Assertions.assertNotNull((Object)entry, (String)"entry should not be null");
            Assertions.assertEquals((Object)"foo/", (Object)entry.getName());
            Assertions.assertTrue((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isAntiItem());
            Assertions.assertNull((Object)archive.getNextEntry(), (String)"getnextEntry should return null");
        }
    }

    @Test
    public void testEightEmptyFiles() throws Exception {
        this.testCompress252(8, 0);
    }

    @Test
    public void testEightFilesSomeNotEmpty() throws Exception {
        this.testCompress252(8, 2);
    }

    @Test
    public void testEncrypt() throws Exception {
        File output = this.newTempFile("encrypted.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output, "foo".toCharArray());){
            this.addFile(outArchive, 0, 1, null);
            this.addFile(outArchive, 1, 16, null);
            this.addFile(outArchive, 2, 32, null);
            this.addFile(outArchive, 3, 33, null);
            this.addFile(outArchive, 4, 10000, null);
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            Assertions.assertThrows(PasswordRequiredException.class, () -> this.verifyFile(archive, 0), (String)"A password should be needed");
        }
        archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).setPassword("foo").get();
        try {
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 0, 1, null));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 1, 16, null));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 2, 32, null));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 3, 33, null));
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.verifyFile(archive, 4, 10000, null));
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    private void testFilterRoundTrip(SevenZMethodConfiguration method) throws Exception {
        File output = this.newTempFile(method.getMethod() + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(method);
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        this.createAndReadBack(output, methods);
    }

    @Test
    public void testLzma2Roundtrip() throws Exception {
        this.testRoundTrip(SevenZMethod.LZMA2);
    }

    @Test
    public void testLzma2WithIntConfiguration() throws Exception {
        File output = this.newTempFile("lzma2-options.7z");
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
    }

    @Test
    public void testLzma2WithOptionsConfiguration() throws Exception {
        File output = this.newTempFile("lzma2-options2.7z");
        LZMA2Options opts = new LZMA2Options(1);
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)opts)));
    }

    @Test
    public void testLzmaWithIntConfiguration() throws Exception {
        File output = this.newTempFile("lzma-options.7z");
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)0x100000)));
    }

    @Test
    public void testLzmaWithOptionsConfiguration() throws Exception {
        File output = this.newTempFile("lzma-options2.7z");
        LZMA2Options opts = new LZMA2Options(1);
        this.createAndReadBack(output, Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA, (Object)opts)));
    }

    @Test
    public void testNineEmptyFiles() throws Exception {
        this.testCompress252(9, 0);
    }

    @Test
    public void testNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(9, 2);
    }

    private void testRoundTrip(SevenZMethod method) throws Exception {
        File output = this.newTempFile(method + "-roundtrip.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(method));
        this.createAndReadBack(output, methods);
    }

    @Test
    public void testSevenEmptyFiles() throws Exception {
        this.testCompress252(7, 0);
    }

    @Test
    public void testSevenFilesSomeNotEmpty() throws Exception {
        this.testCompress252(7, 2);
    }

    @Test
    public void testSixEmptyFiles() throws Exception {
        this.testCompress252(6, 0);
    }

    @Test
    public void testSixFilesSomeNotEmpty() throws Exception {
        this.testCompress252(6, 2);
    }

    @Test
    public void testStackOfContentCompressions() throws Exception {
        File output = this.newTempFile("multiple-methods.7z");
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.COPY));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.DEFLATE));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.BZIP2));
        this.createAndReadBack(output, methods);
    }

    @Test
    public void testStackOfContentCompressionsInMemory() throws Exception {
        ArrayList<SevenZMethodConfiguration> methods = new ArrayList<SevenZMethodConfiguration>();
        methods.add(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.COPY));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.DEFLATE));
        methods.add(new SevenZMethodConfiguration(SevenZMethod.BZIP2));
        try (SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel();){
            this.createAndReadBack(channel, methods);
        }
    }

    @Test
    public void testTwentyNineEmptyFiles() throws Exception {
        this.testCompress252(29, 0);
    }

    @Test
    public void testTwentyNineFilesSomeNotEmpty() throws Exception {
        this.testCompress252(29, 7);
    }

    private void verifyCompress252(File output, int numberOfFiles, int numberOfNonEmptyFiles) throws Exception {
        int filesFound = 0;
        int nonEmptyFilesFound = 0;
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(output)).get();){
            this.verifyDir(archive);
            Boolean b = this.verifyFile(archive, filesFound++);
            while (b != null) {
                if (Boolean.TRUE.equals(b)) {
                    ++nonEmptyFilesFound;
                }
                b = this.verifyFile(archive, filesFound++);
            }
        }
        Assertions.assertEquals((int)(numberOfFiles + 1), (int)filesFound);
        Assertions.assertEquals((int)numberOfNonEmptyFiles, (int)nonEmptyFilesFound);
    }

    private void verifyDir(SevenZFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        Assertions.assertNotNull((Object)entry);
        Assertions.assertEquals((Object)"foo/", (Object)entry.getName());
        Assertions.assertTrue((boolean)entry.isDirectory());
    }

    private Boolean verifyFile(SevenZFile archive, int index) throws Exception {
        return this.verifyFile(archive, index, null);
    }

    private Boolean verifyFile(SevenZFile archive, int index, int size, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        int read;
        SevenZArchiveEntry entry = archive.getNextEntry();
        if (entry == null) {
            return null;
        }
        Assertions.assertEquals((Object)("foo/" + index + ".txt"), (Object)entry.getName());
        Assertions.assertFalse((boolean)entry.isDirectory());
        if (entry.getSize() == 0L) {
            return Boolean.FALSE;
        }
        Assertions.assertEquals((long)size, (long)entry.getSize());
        byte[] actual = new byte[size];
        for (int count = 0; count < size; count += read) {
            read = archive.read(actual, count, actual.length - count);
            Assertions.assertNotEquals((int)-1, (int)read, (String)"EOF reached before reading all expected data");
        }
        Assertions.assertArrayEquals((byte[])this.generateFileData(size), (byte[])actual);
        Assertions.assertEquals((int)-1, (int)archive.read());
        if (methods != null) {
            SevenZOutputFileTest.assertContentMethodsEquals(methods, entry.getContentMethods());
        }
        return Boolean.TRUE;
    }

    private Boolean verifyFile(SevenZFile archive, int index, Iterable<SevenZMethodConfiguration> methods) throws Exception {
        return this.verifyFile(archive, index, 1, methods);
    }

    static {
        String version = XZ.class.getPackage().getImplementationVersion();
        boolean bl = XZ_BCJ_IS_BUGGY = version != null && version.equals("1.4");
        if (XZ_BCJ_IS_BUGGY) {
            System.out.println("XZ version is " + version + " - skipping BCJ tests");
        }
    }
}

