/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class Compress686Test {
    @TempDir
    private Path tempDir;

    private Path compressFile(Path file, boolean bufferOutput) throws IOException {
        Path newFile = this.tempDir.resolve(file.getFileName().toString() + ".bz2");
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
             BZip2CompressorOutputStream bzOut = new BZip2CompressorOutputStream(this.newOutputStream(newFile, bufferOutput));){
            IOUtils.copy((InputStream)in, (OutputStream)bzOut);
        }
        return newFile;
    }

    private Path decompressBzip2File(Path file) throws IOException {
        Path decompressedFile = file.resolveSibling(file.getFileName().toString() + ".decompressed");
        try (BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream(Files.newInputStream(file, new OpenOption[0]));
             OutputStream outputStream = Files.newOutputStream(decompressedFile, new OpenOption[0]);){
            IOUtils.copy((InputStream)bzIn, (OutputStream)outputStream);
        }
        return decompressedFile;
    }

    private OutputStream newOutputStream(Path newFile, boolean bufferOutput) throws IOException {
        OutputStream outputStream = Files.newOutputStream(newFile, new OpenOption[0]);
        return bufferOutput ? new BufferedOutputStream(outputStream) : outputStream;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRoundtrip(boolean bufferCompressOutput) throws Exception {
        Path file = this.tempDir.resolve("test.txt");
        String contents = "a";
        try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            IOUtils.write((String)"a", (Writer)w);
        }
        Path compressedFile = this.compressFile(file, bufferCompressOutput);
        this.decompressBzip2File(compressedFile);
        Assertions.assertEquals((Object)"a", (Object)IOUtils.toString((URI)file.toUri(), (Charset)StandardCharsets.UTF_8));
    }
}

