/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.harmony.unpack200.Archive;
import org.apache.commons.compress.harmony.unpack200.Pack200UnpackerAdapter;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ArchiveTest
extends AbstractTempDirTest {
    @Test
    public void testAlternativeConstructor() throws Exception {
        String inputFile = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI()).getPath();
        File file = this.createTempFile("sql", ".jar");
        String outputFile = file.getPath();
        new Archive(inputFile, outputFile).unpack();
    }

    @Test
    public void testDeflateHint() throws Exception {
        File file = this.createTempFile("sql", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.setDeflateHint(true);
            archive.unpack();
        }
        try (JarFile jarFile = new JarFile(file);){
            Assertions.assertEquals((int)8, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
            try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");){
                file = this.createTempFile("sql", ".jar");
                try (JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
                    Archive archive = new Archive(in, out);
                    archive.setDeflateHint(false);
                    archive.unpack();
                }
            }
        }
        jarFile = new JarFile(file);
        try {
            Assertions.assertEquals((int)0, (int)jarFile.getEntry("bin/test/org/apache/harmony/sql/tests/internal/rowset/CachedRowSetImplTest.class").getMethod());
        }
        finally {
            jarFile.close();
        }
    }

    @Test
    public void testJustResourcesGZip() throws Exception {
        File file = this.createTempFile("Just", "ResourcesGz.jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/JustResources.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Archive(in, out).unpack();
        }
    }

    @Test
    public void testLoggingOptions() throws Exception {
        Archive archive;
        JarOutputStream out;
        Archive archive2;
        JarOutputStream out2;
        File file = this.createTempFile("logtest", ".jar");
        File logFile = this.createTempFile("logfile", ".txt");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");){
            out2 = new JarOutputStream(new FileOutputStream(file));
            try {
                archive2 = new Archive(in, out2);
                archive2.setLogFile(logFile.getPath());
                archive2.unpack();
            }
            finally {
                out2.close();
            }
        }
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
        file = this.createTempFile("logtest", ".jar");
        in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        try {
            out2 = new JarOutputStream(new FileOutputStream(file));
            try {
                archive2 = new Archive(in, out2);
                logFile = this.createTempFile("logfile", ".txt");
                archive2.setLogFile(logFile.getPath());
                archive2.setVerbose(true);
                archive2.unpack();
            }
            finally {
                out2.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        reader = new FileReader(logFile);
        try {
            Assertions.assertTrue((boolean)reader.ready());
        }
        finally {
            reader.close();
        }
        long length = logFile.length();
        file = this.createTempFile("logtest", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");){
            out = new JarOutputStream(new FileOutputStream(file));
            try {
                archive = new Archive(in, out);
                archive.setLogFile(logFile.getPath(), true);
                archive.setVerbose(true);
                archive.unpack();
            }
            finally {
                out.close();
            }
        }
        Assertions.assertTrue((logFile.length() > length ? 1 : 0) != 0);
        file = this.createTempFile("logtest", ".jar");
        in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        try {
            out = new JarOutputStream(new FileOutputStream(file));
            try {
                archive = new Archive(in, out);
                archive.setLogFile(logFile.getPath(), false);
                archive.setVerbose(true);
                archive.unpack();
            }
            finally {
                out.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        Assertions.assertEquals((long)logFile.length(), (long)length);
        file = this.createTempFile("logtest", ".jar");
        in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
        try {
            out = new JarOutputStream(new FileOutputStream(file));
            try {
                archive = new Archive(in, out);
                logFile = this.createTempFile("logfile", ".txt");
                archive.setLogFile(logFile.getPath());
                archive.setQuiet(true);
                archive.unpack();
            }
            finally {
                out.close();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        try (FileReader reader = new FileReader(logFile);){
            Assertions.assertFalse((boolean)reader.ready());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bandint_oom.pack", "cpfloat_oom.pack", "cputf8_oom.pack", "favoured_oom.pack", "filebits_oom.pack", "flags_oom.pack", "references_oom.pack", "segment_header_oom.pack", "signatures_oom.pack"})
    public void testParsingOOMBounded(String testFileName) throws Exception {
        URL url = Segment.class.getResource("/org/apache/commons/compress/pack/" + testFileName);
        try (BoundedInputStream in = Pack200UnpackerAdapter.newBoundedInputStream((URL)url);
             JarOutputStream out = new JarOutputStream((OutputStream)NullOutputStream.INSTANCE);){
            Assert.assertThrows(IOException.class, () -> new Archive((InputStream)in, out).unpack());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bandint_oom.pack", "cpfloat_oom.pack", "cputf8_oom.pack", "favoured_oom.pack", "filebits_oom.pack", "flags_oom.pack", "references_oom.pack", "segment_header_oom.pack", "signatures_oom.pack"})
    public void testParsingOOMUnbounded(String testFileName) throws Exception {
        try (InputStream is = Segment.class.getResourceAsStream("/org/apache/commons/compress/pack/" + testFileName);
             JarOutputStream out = new JarOutputStream((OutputStream)NullOutputStream.INSTANCE);){
            Assert.assertThrows(IOException.class, () -> new Archive(is, out).unpack());
        }
    }

    @Test
    public void testRemovePackFile() throws Exception {
        File copy = this.createTempFile("sqlcopy", ".pack.gz");
        File original = new File(Archive.class.getResource("/pack200/sql.pack.gz").toURI());
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(original));
             BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(copy));){
            byte[] bytes = new byte[256];
            int read = inputStream.read(bytes);
            while (read > 0) {
                outputStream.write(bytes, 0, read);
                read = inputStream.read(bytes);
            }
        }
        String inputFileName = copy.getPath();
        File file = this.createTempFile("sqlout", ".jar");
        String outputFileName = file.getPath();
        Archive archive = new Archive(inputFileName, outputFileName);
        archive.setRemovePackFile(true);
        archive.unpack();
        Assertions.assertFalse((boolean)copy.exists());
    }

    @Test
    public void testWithAnnotations() throws Exception {
        File file = this.createTempFile("annotations", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/annotations.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithE0() throws Exception {
        File file = this.createTempFile("simple-e0", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/simple-E0.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithJNDIE1() throws Exception {
        File file = this.createTempFile("jndi-e1", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/jndi-e1.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithLargeClass() throws Exception {
        File file = this.createTempFile("largeClass", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/LargeClass.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithPack200() throws Exception {
        File file = this.createTempFile("p200", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/pack200.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithPack200E1() throws Exception {
        File file = this.createTempFile("p200-e1", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/pack200-e1.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }

    @Test
    public void testWithSql() throws Exception {
        File file = this.createTempFile("sql", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            new Archive(in, out).unpack();
        }
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        try (JarFile jarFile = new JarFile(file);
             JarFile jarFile2 = new JarFile(compareFile);){
            long differenceInJarSizes = Math.abs(compareFile.length() - file.length());
            Assertions.assertTrue((differenceInJarSizes < 100L ? 1 : 0) != 0, (String)("Expected jar files to be a similar size, difference was " + differenceInJarSizes + " bytes"));
            Enumeration<JarEntry> entries = jarFile.entries();
            Enumeration<JarEntry> entries2 = jarFile2.entries();
            while (entries.hasMoreElements() && entries2.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                Assertions.assertNotNull((Object)entry);
                String name = entry.getName();
                JarEntry entry2 = entries2.nextElement();
                Assertions.assertNotNull((Object)entry2);
                String name2 = entry2.getName();
                Assertions.assertEquals((Object)name, (Object)name2);
                InputStream ours = jarFile.getInputStream(entry);
                try {
                    InputStream expected = jarFile2.getInputStream(entry2);
                    try (BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
                         BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));){
                        String line1 = reader1.readLine();
                        String line2 = reader2.readLine();
                        int i = 1;
                        while (line1 != null || line2 != null) {
                            Assertions.assertEquals((Object)line2, (Object)line1, (String)("Unpacked class files differ for " + name));
                            line1 = reader1.readLine();
                            line2 = reader2.readLine();
                            ++i;
                        }
                        Assertions.assertTrue((i > 0 ? 1 : 0) != 0);
                    }
                    finally {
                        if (expected == null) continue;
                        expected.close();
                    }
                }
                finally {
                    if (ours == null) continue;
                    ours.close();
                }
            }
        }
    }

    @Test
    public void testWithSqlE1() throws Exception {
        File file = this.createTempFile("sql-e1", ".jar");
        try (InputStream in = Archive.class.getResourceAsStream("/pack200/sql-e1.pack.gz");
             JarOutputStream out = new JarOutputStream(new FileOutputStream(file));){
            Archive archive = new Archive(in, out);
            archive.unpack();
        }
    }
}

