/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.osgi;

import java.lang.reflect.Method;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.ops4j.pax.exam.Option;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

abstract class AbstractOsgiITest {
    private static final String EXPECTED_BUNDLE_NAME = "org.apache.commons.commons-compress";
    @Inject
    private BundleContext ctx;

    AbstractOsgiITest() {
    }

    public abstract Option[] config();

    private Bundle loadBundle() {
        for (Bundle b : this.ctx.getBundles()) {
            if (!EXPECTED_BUNDLE_NAME.equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    @Test
    public void testCanLoadBundle() {
        Assert.assertNotNull((String)"Expected to find bundle org.apache.commons.commons-compress", (Object)this.loadBundle());
    }

    @Test
    public void testProperlyDetectsRunningInsideOsgiEnv() throws Exception {
        Class osgiUtils = this.loadBundle().loadClass("org.apache.commons.compress.utils.OsgiUtils");
        Assert.assertNotNull((String)"Can load OsgiUtils via bundle", (Object)osgiUtils);
        Method method = osgiUtils.getMethod("isRunningInOsgiEnvironment", new Class[0]);
        Assert.assertNotNull((String)"Can access isRunningInOsgiEnvironment method", (Object)method);
        Assert.assertTrue((String)"Compress detects OSGi environment", (boolean)((Boolean)method.invoke(null, new Object[0])));
    }
}

